/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.PersistentChosenRequest;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.Logger;

public class PersistentChosenBlock
extends ChosenBlock {
    public final PersistentChosenRequest parent;
    public final boolean isInsert;
    private boolean finished;
    private LowLevelGetException failedGet;
    private boolean fetchSucceeded;
    private boolean insertSucceeded;
    private LowLevelPutException failedPut;

    public PersistentChosenBlock(boolean isInsert, PersistentChosenRequest parent, SendableRequestItem token, Key key, ClientKey ckey, RequestScheduler sched) {
        super(token, key, ckey, parent.localRequestOnly, parent.cacheLocalRequests, parent.ignoreStore, sched);
        this.isInsert = isInsert;
        this.parent = parent;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Created " + this + " for " + parent + " ckey=" + ckey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetchSuccess(ClientContext context) {
        assert (!this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onSuccess() on " + this, new Exception("debug"));
                return;
            }
            this.finished = true;
            this.fetchSucceeded = true;
        }
        this.parent.onFinished(this, context);
        this.parent.scheduler.succeeded((SendableGet)this.parent.request, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(LowLevelGetException e, ClientContext context) {
        assert (!this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onFailure() on " + this, new Exception("debug"));
                return;
            }
            if (e == null) {
                throw new NullPointerException();
            }
            this.failedGet = e;
            this.finished = true;
        }
        this.parent.onFinished(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInsertSuccess(ClientContext context) {
        assert (this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onSuccess() on " + this, new Exception("debug"));
                return;
            }
            this.insertSucceeded = true;
            this.finished = true;
        }
        this.parent.onFinished(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(LowLevelPutException e, ClientContext context) {
        assert (this.isInsert);
        PersistentChosenBlock persistentChosenBlock = this;
        synchronized (persistentChosenBlock) {
            if (this.finished) {
                Logger.error(this, "Already finished in onFailure() on " + this, new Exception("debug"));
                return;
            }
            if (e == null) {
                throw new NullPointerException();
            }
            this.failedPut = e;
            this.finished = true;
        }
        this.parent.onFinished(this, context);
    }

    LowLevelGetException failedGet() {
        return this.failedGet;
    }

    boolean insertSucceeded() {
        return this.insertSucceeded;
    }

    boolean fetchSucceeded() {
        return this.fetchSucceeded;
    }

    LowLevelPutException failedPut() {
        return this.failedPut;
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(NodeClientCore core, RequestScheduler sched) {
        boolean wasFinished2;
        PersistentChosenBlock persistentChosenBlock;
        boolean bl;
        try {
            bl = super.send(core, sched);
            Object var5_4 = null;
            persistentChosenBlock = this;
        }
        catch (Throwable throwable) {
            block13: {
                boolean wasFinished2;
                Object var5_5 = null;
                PersistentChosenBlock persistentChosenBlock2 = this;
                synchronized (persistentChosenBlock2) {
                    wasFinished2 = this.finished;
                    if (!this.finished) {
                        this.finished = true;
                        if (this.parent.request instanceof SendableGet) {
                            Logger.error(this, "SendableGet " + this.parent.request + " didn't call a callback on " + this);
                        }
                    }
                }
                if (wasFinished2) break block13;
                this.parent.onFinished(this, sched.getContext());
            }
            throw throwable;
        }
        synchronized (persistentChosenBlock) {
            wasFinished2 = this.finished;
            if (!this.finished) {
                this.finished = true;
                if (this.parent.request instanceof SendableGet) {
                    Logger.error(this, "SendableGet " + this.parent.request + " didn't call a callback on " + this);
                }
            }
        }
        if (!wasFinished2) {
            this.parent.onFinished(this, sched.getContext());
        }
        return bl;
    }

    public short getPriority() {
        return this.parent.prio;
    }

    public SendableRequestSender getSender(ClientContext context) {
        return this.parent.sender;
    }
}

