/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.crypt.RandomSource;
import freenet.keys.Key;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfferedKeysList
extends BaseSendableGet
implements RequestClient {
    private final HashSet<Key> keys = new HashSet();
    private final Vector<Key> keysList = new Vector();
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final RandomSource random;
    private final short priorityClass;
    private final NodeClientCore core;
    private final boolean isSSK;

    OfferedKeysList(NodeClientCore core, RandomSource random, short priorityClass, boolean isSSK) {
        super(false);
        this.random = random;
        this.priorityClass = priorityClass;
        this.core = core;
        this.isSSK = isSSK;
    }

    public synchronized void remove(Key key) {
        assert (this.keysList.size() == this.keys.size());
        if (this.keys.remove(key)) {
            this.keysList.remove(key);
            if (logMINOR) {
                Logger.minor(this, "Found " + key + " , removing it " + " for " + this + " size now " + this.keysList.size());
            }
        }
        assert (this.keysList.size() == this.keys.size());
    }

    @Override
    public synchronized boolean isEmpty(ObjectContainer container) {
        return this.keys.isEmpty();
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long countSendableKeys(ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized SendableRequestItem chooseKey(KeysFetchingLocally fetching, ObjectContainer container, ClientContext context) {
        assert (this.keysList.size() == this.keys.size());
        if (this.keys.size() == 1) {
            Key k = this.keysList.get(0);
            if (fetching.hasKey(k)) {
                return null;
            }
            this.keys.remove(k);
            this.keysList.setSize(0);
            return new MySendableRequestItem(k);
        }
        for (int i = 0; i < 10; ++i) {
            if (this.keysList.isEmpty()) {
                return null;
            }
            int ptr = this.random.nextInt(this.keysList.size());
            Key k = this.keysList.get(ptr);
            if (fetching.hasKey(k)) continue;
            this.keysList.set(ptr, this.keysList.get(this.keysList.size() - 1));
            this.keysList.setSize(this.keysList.size() - 1);
            this.keys.remove(k);
            assert (this.keysList.size() == this.keys.size());
            return new MySendableRequestItem(k);
        }
        return null;
    }

    @Override
    public synchronized boolean hasValidKeys(KeysFetchingLocally fetching, ObjectContainer container, ClientContext context) {
        assert (this.keysList.size() == this.keys.size());
        if (this.keys.size() == 1) {
            Key k = this.keysList.get(0);
            return !fetching.hasKey(k);
        }
        for (int i = 0; i < 10; ++i) {
            if (this.keysList.isEmpty()) {
                return false;
            }
            int ptr = this.random.nextInt(this.keysList.size());
            Key k = this.keysList.get(ptr);
            if (fetching.hasKey(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        return this;
    }

    @Override
    public ClientRequester getClientRequest() {
        return null;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        return this.priorityClass;
    }

    @Override
    public int getRetryCount() {
        return 0;
    }

    @Override
    public void internalError(Throwable t, RequestScheduler sched, ObjectContainer container, ClientContext context, boolean persistent) {
        Logger.error(this, "Internal error: " + t, t);
    }

    @Override
    public SendableRequestSender getSender(ObjectContainer container, ClientContext context) {
        return new SendableRequestSender(){

            public boolean send(NodeClientCore core, RequestScheduler sched, ClientContext context, ChosenBlock req) {
                Key key = ((MySendableRequestItem)req.token).key;
                core.asyncGet(key, true, true, new NodeClientCore.SimpleRequestSenderCompletionListener(){

                    public void completed(boolean success) {
                    }
                });
                return true;
            }
        };
    }

    @Override
    public boolean isCancelled(ObjectContainer container) {
        return false;
    }

    public synchronized void queueKey(Key key) {
        assert (this.keysList.size() == this.keys.size());
        if (this.keys.add(key)) {
            this.keysList.add(key);
            if (logMINOR) {
                Logger.minor(this, "Queued key " + key + " on " + this);
            }
        }
        assert (this.keysList.size() == this.keys.size());
    }

    @Override
    public Key getNodeKey(SendableRequestItem token, ObjectContainer container) {
        return ((MySendableRequestItem)token).key;
    }

    @Override
    public boolean isSSK() {
        return this.isSSK;
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, ObjectContainer container, ClientContext context) {
        throw new UnsupportedOperationException("Transient only");
    }

    @Override
    public boolean isInsert() {
        return false;
    }

    @Override
    public ClientRequestScheduler getScheduler(ClientContext context) {
        if (this.isSSK) {
            return context.getSskFetchScheduler();
        }
        return context.getChkFetchScheduler();
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void preRegister(ObjectContainer container, ClientContext context, boolean toNetwork) {
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }

    private static class MySendableRequestItem
    implements SendableRequestItem {
        final Key key;

        MySendableRequestItem(Key key) {
            this.key = key;
        }

        public void dump() {
        }
    }
}

