/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.keys.BaseClientKey;
import freenet.support.Logger;
import java.util.Vector;

public class MultiPutCompletionCallback
implements PutCompletionCallback,
ClientPutState {
    private final Vector<ClientPutState> waitingFor;
    private final Vector<ClientPutState> waitingForBlockSet;
    private final Vector<ClientPutState> waitingForFetchable;
    private final PutCompletionCallback cb;
    private ClientPutState generator;
    private final BaseClientPutter parent;
    private InsertException e;
    private boolean finished;
    private boolean started;
    public final Object token;
    private final boolean persistent;

    public void objectOnActivate(ObjectContainer container) {
        container.activate(this.waitingFor, 1);
        container.activate(this.waitingForBlockSet, 1);
        container.activate(this.waitingForFetchable, 1);
    }

    public MultiPutCompletionCallback(PutCompletionCallback cb, BaseClientPutter parent, Object token, boolean persistent) {
        this.cb = cb;
        this.waitingFor = new Vector();
        this.waitingForBlockSet = new Vector();
        this.waitingForFetchable = new Vector();
        this.parent = parent;
        this.token = token;
        this.finished = false;
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        this.onBlockSetFinished(state, container, context);
        this.onFetchable(state, container);
        if (this.persistent) {
            container.activate(this.waitingFor, 2);
        }
        boolean complete = true;
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (this.finished) {
                Logger.error(this, "Already finished but got onSuccess() for " + state + " on " + this);
                return;
            }
            this.waitingFor.remove(state);
            this.waitingForBlockSet.remove(state);
            this.waitingForFetchable.remove(state);
            if (!this.waitingFor.isEmpty() || !this.started) {
                if (this.persistent) {
                    container.ext().store(this.waitingFor, 1);
                }
                complete = false;
            }
            if (state == this.generator) {
                this.generator = null;
                if (this.persistent) {
                    container.store((Object)this);
                }
            }
        }
        if (this.persistent) {
            container.ext().store(this.waitingFor, 2);
            container.ext().store(this.waitingForBlockSet, 2);
            container.ext().store(this.waitingForFetchable, 2);
            state.removeFrom(container, context);
        }
        if (complete) {
            Logger.minor(this, "Completing...");
            this.complete(null, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        boolean complete = true;
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (this.finished) {
                Logger.error(this, "Already finished but got onFailure() for " + state + " on " + this);
                return;
            }
            this.waitingFor.remove(state);
            this.waitingForBlockSet.remove(state);
            this.waitingForFetchable.remove(state);
            if (!this.waitingFor.isEmpty() || !this.started) {
                if (this.e != null && this.persistent) {
                    container.activate((Object)this.e, 10);
                    this.e.removeFrom(container);
                }
                this.e = e;
                if (this.persistent) {
                    container.store((Object)this);
                }
                complete = false;
            }
            if (state == this.generator) {
                this.generator = null;
                if (this.persistent) {
                    container.store((Object)this);
                }
            }
        }
        if (this.persistent) {
            container.ext().store(this.waitingFor, 2);
            container.ext().store(this.waitingForBlockSet, 2);
            container.ext().store(this.waitingForFetchable, 2);
            state.removeFrom(container, context);
        }
        if (complete) {
            this.complete(e, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(InsertException e, ObjectContainer container, ClientContext context) {
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            if (e != null && this.e != null && this.e != e) {
                if (this.persistent) {
                    container.activate((Object)this.e, 10);
                }
                if (e.getMode() == 10) {
                    e = this.e;
                    if (this.persistent) {
                        container.activate((Object)e, 5);
                        e = e.clone();
                    }
                } else {
                    this.e.removeFrom(container);
                    this.e = e;
                }
            }
            if (e == null) {
                e = this.e;
                if (this.persistent && e != null) {
                    container.activate((Object)e, 10);
                    e = e.clone();
                }
            }
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.cb, 1);
        }
        if (e != null) {
            this.cb.onFailure(e, this, container, context);
        } else {
            this.cb.onSuccess(this, container, context);
        }
    }

    public synchronized void addURIGenerator(ClientPutState ps, ObjectContainer container) {
        this.add(ps, container);
        this.generator = ps;
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    public synchronized void add(ClientPutState ps, ObjectContainer container) {
        if (this.finished) {
            return;
        }
        this.waitingFor.add(ps);
        this.waitingForBlockSet.add(ps);
        this.waitingForFetchable.add(ps);
        if (this.persistent) {
            container.store((Object)ps);
            container.ext().store(this.waitingFor, 2);
            container.ext().store(this.waitingForBlockSet, 2);
            container.ext().store(this.waitingForFetchable, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arm(ObjectContainer container, ClientContext context) {
        boolean allGotBlocks;
        boolean allDone;
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            this.started = true;
            allDone = this.waitingFor.isEmpty();
            allGotBlocks = this.waitingForBlockSet.isEmpty();
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.cb, 1);
        }
        if (allGotBlocks) {
            this.cb.onBlockSetFinished(this, container, context);
        }
        if (allDone) {
            if (this.persistent && this.e != null) {
                container.activate((Object)this.e, 5);
            }
            this.complete(this.e, container, context);
        }
    }

    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            if (state != this.generator) {
                return;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onEncode(key, this, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        ClientPutState[] states = new ClientPutState[this.waitingFor.size()];
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            states = this.waitingFor.toArray(states);
        }
        boolean logDEBUG = Logger.shouldLog(2, this);
        for (int i = 0; i < states.length; ++i) {
            if (this.persistent) {
                container.activate((Object)states[i], 1);
            }
            if (logDEBUG) {
                Logger.minor(this, "Cancelling state " + i + " of " + states.length + " : " + states[i]);
            }
            states[i].cancel(container, context);
        }
    }

    public synchronized void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        int i;
        if (this.generator == oldState) {
            this.generator = newState;
        }
        if (oldState == newState) {
            return;
        }
        for (i = 0; i < this.waitingFor.size(); ++i) {
            if (this.waitingFor.get(i) != oldState) continue;
            this.waitingFor.set(i, newState);
            container.ext().store(this.waitingFor, 2);
        }
        for (i = 0; i < this.waitingForBlockSet.size(); ++i) {
            if (this.waitingForBlockSet.get(i) != oldState) continue;
            this.waitingForBlockSet.set(i, newState);
            container.ext().store(this.waitingFor, 2);
        }
        for (i = 0; i < this.waitingForFetchable.size(); ++i) {
            if (this.waitingForFetchable.get(i) != oldState) continue;
            this.waitingForFetchable.set(i, newState);
            container.ext().store(this.waitingFor, 2);
        }
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    public synchronized void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        if (this.generator == state) {
            this.cb.onMetadata(m, this, container, context);
        } else {
            Logger.error(this, "Got metadata for " + state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate(this.waitingForBlockSet, 2);
        }
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            this.waitingForBlockSet.remove(state);
            if (this.persistent) {
                container.ext().store(this.waitingForBlockSet, 2);
            }
            if (!this.started) {
                return;
            }
            if (!this.waitingForBlockSet.isEmpty()) {
                return;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onBlockSetFinished(this, container, context);
    }

    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
    }

    public Object getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetchable(ClientPutState state, ObjectContainer container) {
        if (this.persistent) {
            container.activate(this.waitingForFetchable, 2);
        }
        MultiPutCompletionCallback multiPutCompletionCallback = this;
        synchronized (multiPutCompletionCallback) {
            this.waitingForFetchable.remove(state);
            if (this.persistent) {
                container.ext().store(this.waitingForFetchable, 2);
            }
            if (!this.started) {
                return;
            }
            if (!this.waitingForFetchable.isEmpty()) {
                return;
            }
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFetchable(this, container);
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate(this.waitingFor, 2);
        container.activate(this.waitingForBlockSet, 2);
        container.activate(this.waitingForFetchable, 2);
        if (!this.waitingFor.isEmpty()) {
            Logger.error(this, "waitingFor not empty in removeFrom() on " + this + " : " + this.waitingFor);
        }
        if (!this.waitingForBlockSet.isEmpty()) {
            Logger.error(this, "waitingForBlockSet not empty in removeFrom() on " + this + " : " + this.waitingFor);
        }
        if (!this.waitingForFetchable.isEmpty()) {
            Logger.error(this, "waitingForFetchable not empty in removeFrom() on " + this + " : " + this.waitingFor);
        }
        container.delete(this.waitingFor);
        container.delete(this.waitingForBlockSet);
        container.delete(this.waitingForFetchable);
        if (this.e != null) {
            container.activate((Object)this.e, 5);
            this.e.removeFrom(container);
        }
        container.delete((Object)this);
    }
}

