/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.support.api.Bucket;

public class ManifestElement {
    final String name;
    final String fullName;
    Bucket data;
    final String mimeOverride;
    final long dataSize;
    final FreenetURI targetURI;

    public ManifestElement(String name, String fullName, Bucket data, String mimeOverride, long size) {
        this.name = name;
        this.fullName = fullName;
        this.data = data;
        this.mimeOverride = mimeOverride;
        this.dataSize = size;
        this.targetURI = null;
    }

    public ManifestElement(String name, Bucket data, String mimeOverride, long size) {
        this.name = name;
        this.fullName = name;
        this.data = data;
        this.mimeOverride = mimeOverride;
        this.dataSize = size;
        this.targetURI = null;
    }

    public ManifestElement(ManifestElement me, String newName) {
        this.name = newName;
        this.fullName = me.fullName;
        this.data = me.data;
        this.mimeOverride = me.mimeOverride;
        this.dataSize = me.dataSize;
        this.targetURI = me.targetURI;
    }

    public ManifestElement(String name, FreenetURI targetURI, String mimeOverride) {
        this.name = name;
        this.fullName = name;
        this.data = null;
        this.mimeOverride = mimeOverride;
        this.dataSize = -1L;
        this.targetURI = targetURI;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ManifestElement && ((ManifestElement)o).name.equals(this.name);
    }

    public void freeData(ObjectContainer container, boolean persistForever) {
        if (this.data != null) {
            if (persistForever) {
                container.activate((Object)this.data, 1);
            }
            this.data.free();
            if (persistForever) {
                this.data.removeFrom(container);
            }
            this.data = null;
        }
        if (persistForever) {
            container.delete((Object)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMimeTypeOverride() {
        return this.mimeOverride;
    }

    public Bucket getData() {
        return this.data;
    }

    public long getSize() {
        return this.dataSize;
    }

    public FreenetURI getTargetURI() {
        return this.targetURI;
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.data, 1);
        this.data.removeFrom(container);
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.delete((Object)this);
    }
}

