/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.CompressionOutput;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.SingleFileInserter;
import freenet.node.PrioRunnable;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressJob;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketChainBucketFactory;
import java.io.IOException;

public class InsertCompressor
implements CompressJob {
    public final long nodeDBHandle;
    public final SingleFileInserter inserter;
    final Bucket origData;
    public final int minSize;
    public final BucketFactory bucketFactory;
    public final boolean persistent;
    private transient boolean scheduled;
    private static volatile boolean logMINOR;

    public InsertCompressor(long nodeDBHandle2, SingleFileInserter inserter2, Bucket origData2, int minSize2, BucketFactory bf, boolean persistent) {
        this.nodeDBHandle = nodeDBHandle2;
        this.inserter = inserter2;
        this.origData = origData2;
        this.minSize = minSize2;
        this.bucketFactory = bf;
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ObjectContainer container, ClientContext ctx) {
        if (this.persistent) {
            container.activate((Object)this.inserter, 1);
            container.activate((Object)this.origData, 1);
        }
        if (this.origData == null) {
            if (this.inserter == null || this.inserter.cancelled()) {
                container.delete((Object)this);
                return;
            }
            if (this.inserter.parent == null) {
                Logger.error(this, "InsertCompressor for " + this.inserter + " has no parent! Not compressing...");
                container.delete((Object)this);
                return;
            }
            if (this.inserter.started()) {
                Logger.error(this, "Inserter started already, but we are about to attempt to compress the data!");
                container.delete((Object)this);
                return;
            }
            Logger.error(this, "Original data was deleted but inserter neither deleted nor cancelled nor missing!");
            container.delete((Object)this);
            return;
        }
        InsertCompressor insertCompressor = this;
        synchronized (insertCompressor) {
            if (this.scheduled) {
                Logger.error(this, "Already scheduled compression, not rescheduling");
                return;
            }
            this.scheduled = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Compressing " + this + " : origData.size=" + this.origData.size() + " for " + this.inserter + " origData=" + this.origData);
        }
        ctx.rc.enqueueNewJob(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tryCompress(final ClientContext context) throws InsertException {
        long origSize = this.origData.size();
        Compressor.COMPRESSOR_TYPE bestCodec = null;
        Bucket bestCompressedData = this.origData;
        long bestCompressedDataSize = origSize;
        if (logMINOR) {
            Logger.minor(this, "Attempt to compress the data");
        }
        try {
            BucketChainBucketFactory bucketFactory2 = new BucketChainBucketFactory(this.bucketFactory, 32768, this.persistent ? context.jobRunner : null, 1024);
            for (final Compressor.COMPRESSOR_TYPE comp : Compressor.COMPRESSOR_TYPE.values()) {
                Object var19_21;
                boolean shouldFreeOnFinally = true;
                Bucket result = null;
                try {
                    try {
                        if (logMINOR) {
                            Logger.minor(this, "Attempt to compress using " + comp);
                        }
                        short phase = comp.metadataID;
                        if (this.persistent) {
                            context.jobRunner.queue(new DBJob(){

                                public boolean run(ObjectContainer container, ClientContext context) {
                                    if (!container.ext().isStored((Object)InsertCompressor.this.inserter)) {
                                        if (logMINOR) {
                                            Logger.minor(this, "Already deleted (start compression): " + InsertCompressor.this.inserter + " for " + InsertCompressor.this);
                                        }
                                        return false;
                                    }
                                    if (container.ext().isActive((Object)InsertCompressor.this.inserter)) {
                                        Logger.error(this, "ALREADY ACTIVE in start compression callback: " + InsertCompressor.this.inserter);
                                    }
                                    container.activate((Object)InsertCompressor.this.inserter, 1);
                                    InsertCompressor.this.inserter.onStartCompression(comp, container, context);
                                    container.deactivate((Object)InsertCompressor.this.inserter, 1);
                                    return false;
                                }
                            }, 6, false);
                        } else {
                            try {
                                this.inserter.onStartCompression(comp, null, context);
                            }
                            catch (Throwable t) {
                                Logger.error(this, "Transient insert callback threw " + t, t);
                            }
                        }
                        result = comp.compress(this.origData, bucketFactory2, origSize, bestCompressedDataSize);
                        long resultSize = result.size();
                        if (resultSize <= (long)this.minSize) {
                            if (logMINOR) {
                                Logger.minor(this, "New size " + resultSize + " smaller then minSize " + this.minSize);
                            }
                            bestCodec = comp;
                            if (bestCompressedData != null && bestCompressedData != this.origData) {
                                bestCompressedData.free();
                            }
                            bestCompressedData = result;
                            bestCompressedDataSize = resultSize;
                            shouldFreeOnFinally = false;
                            var19_21 = null;
                            if (!shouldFreeOnFinally || result == null || result == this.origData) break;
                            result.free();
                            break;
                        }
                        if (resultSize < bestCompressedDataSize) {
                            if (logMINOR) {
                                Logger.minor(this, "New size " + resultSize + " better than old best " + bestCompressedDataSize);
                            }
                            if (bestCompressedData != null && bestCompressedData != this.origData) {
                                bestCompressedData.free();
                            }
                            bestCompressedData = result;
                            bestCompressedDataSize = resultSize;
                            bestCodec = comp;
                            shouldFreeOnFinally = false;
                        }
                    }
                    catch (CompressionOutputSizeException e) {
                        var19_21 = null;
                        if (!shouldFreeOnFinally || result == null || result == this.origData) continue;
                        result.free();
                        continue;
                    }
                    catch (DatabaseDisabledException e) {
                        Logger.error(this, "Database disabled compressing data", new Exception("error"));
                        shouldFreeOnFinally = true;
                        if (bestCompressedData != null && bestCompressedData != this.origData && bestCompressedData != result) {
                            bestCompressedData.free();
                        }
                        var19_21 = null;
                        if (!shouldFreeOnFinally || result == null || result == this.origData) continue;
                        result.free();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var19_21 = null;
                    if (!shouldFreeOnFinally) throw throwable;
                    if (result == null) throw throwable;
                    if (result == this.origData) throw throwable;
                    result.free();
                    throw throwable;
                }
                var19_21 = null;
                if (!shouldFreeOnFinally || result == null || result == this.origData) continue;
                result.free();
            }
            final CompressionOutput output = new CompressionOutput(bestCompressedData, bestCodec);
            if (this.persistent) {
                context.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (!container.ext().isStored((Object)InsertCompressor.this.inserter)) {
                            if (logMINOR) {
                                Logger.minor(this, "Already deleted: " + InsertCompressor.this.inserter + " for " + InsertCompressor.this);
                            }
                            container.delete((Object)InsertCompressor.this);
                            return false;
                        }
                        if (container.ext().isActive((Object)InsertCompressor.this.inserter)) {
                            Logger.error(this, "ALREADY ACTIVE in compressed callback: " + InsertCompressor.this.inserter);
                        }
                        container.activate((Object)InsertCompressor.this.inserter, 1);
                        InsertCompressor.this.inserter.onCompressed(output, container, context);
                        container.deactivate((Object)InsertCompressor.this.inserter, 1);
                        container.delete((Object)InsertCompressor.this);
                        return true;
                    }
                }, 6, false);
                return;
            }
            context.mainExecutor.execute(new PrioRunnable(){

                public int getPriority() {
                    return 5;
                }

                public void run() {
                    try {
                        InsertCompressor.this.inserter.onCompressed(output, null, context);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " running compression job", t);
                    }
                }
            }, "Insert thread for " + this);
            return;
        }
        catch (IOException e) {
            if (!this.persistent) {
                this.inserter.cb.onFailure(new InsertException(2, e, null), this.inserter, null, context);
                return;
            }
            try {
                context.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (!container.ext().isStored((Object)InsertCompressor.this.inserter)) {
                            if (logMINOR) {
                                Logger.minor(this, "Already deleted (on failed): " + InsertCompressor.this.inserter + " for " + InsertCompressor.this);
                            }
                            container.delete((Object)InsertCompressor.this);
                            return false;
                        }
                        if (container.ext().isActive((Object)InsertCompressor.this.inserter)) {
                            Logger.error(this, "ALREADY ACTIVE in compress failure callback: " + InsertCompressor.this.inserter);
                        }
                        container.activate((Object)InsertCompressor.this.inserter, 1);
                        container.activate((Object)InsertCompressor.this.inserter.cb, 1);
                        InsertCompressor.this.inserter.cb.onFailure(new InsertException(2, e, null), InsertCompressor.this.inserter, container, context);
                        container.deactivate((Object)InsertCompressor.this.inserter.cb, 1);
                        container.deactivate((Object)InsertCompressor.this.inserter, 1);
                        container.delete((Object)InsertCompressor.this);
                        return true;
                    }
                }, 6, false);
                return;
            }
            catch (DatabaseDisabledException e1) {
                Logger.error(this, "Database disabled compressing data", new Exception("error"));
                if (bestCompressedData == null) return;
                if (bestCompressedData == this.origData) return;
                bestCompressedData.free();
                return;
            }
        }
        catch (DatabaseDisabledException e) {
            Logger.error(this, "Database disabled compressing data", new Exception("error"));
            if (bestCompressedData == null) return;
            if (bestCompressedData == this.origData) return;
            bestCompressedData.free();
        }
    }

    public static InsertCompressor start(ObjectContainer container, ClientContext context, SingleFileInserter inserter, Bucket origData, int minSize, BucketFactory bf, boolean persistent) {
        if (persistent != (container != null)) {
            throw new IllegalStateException("Starting compression, persistent=" + persistent + " but container=" + container);
        }
        InsertCompressor compressor = new InsertCompressor(context.nodeDBHandle, inserter, origData, minSize, bf, persistent);
        if (persistent) {
            container.store((Object)compressor);
        }
        compressor.init(container, context);
        return compressor;
    }

    public static void load(ObjectContainer container, ClientContext context) {
        long handle = context.nodeDBHandle;
        Query query = container.query();
        query.constrain(InsertCompressor.class);
        query.descend("nodeDBHandle").constrain((Object)handle);
        ObjectSet results = query.execute();
        while (results.hasNext()) {
            InsertCompressor comp = (InsertCompressor)results.next();
            if (!container.ext().isActive((Object)comp)) {
                Logger.error(InsertCompressor.class, "InsertCompressor not activated by query?!?!");
                container.activate((Object)comp, 1);
            }
            comp.init(container, context);
        }
    }

    public void onFailure(final InsertException e, ClientPutState c, ClientContext context) {
        if (this.persistent) {
            try {
                context.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)InsertCompressor.this.inserter)) {
                            Logger.error(this, "ALREADY ACTIVE in compress failure callback: " + InsertCompressor.this.inserter);
                        }
                        container.activate((Object)InsertCompressor.this.inserter, 1);
                        container.activate((Object)InsertCompressor.this.inserter.cb, 1);
                        InsertCompressor.this.inserter.cb.onFailure(e, InsertCompressor.this.inserter, container, context);
                        container.deactivate((Object)InsertCompressor.this.inserter.cb, 1);
                        container.deactivate((Object)InsertCompressor.this.inserter, 1);
                        container.delete((Object)InsertCompressor.this);
                        return true;
                    }
                }, 6, false);
            }
            catch (DatabaseDisabledException e1) {}
        } else {
            this.inserter.cb.onFailure(e, this.inserter, null, context);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

