/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertContext;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ManifestElement;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.ContainerSizeEstimator;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManifestPutter
extends BaseManifestPutter {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    public static final long DEFAULT_MAX_CONTAINERSIZE = 0x200000L;
    public static final long DEFAULT_MAX_CONTAINERITEMSIZE = 0x100000L;
    public static final long DEFAULT_CONTAINERSIZE_SPARE = 200704L;

    public DefaultManifestPutter(ClientPutCallback clientCallback, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly, RequestClient clientContext, boolean earlyEncode) {
        super(clientCallback, manifestElements, prioClass, target, defaultName, ctx, getCHKOnly, clientContext, earlyEncode);
    }

    @Override
    protected void makePutHandlers(HashMap<String, Object> manifestElements, HashMap<String, Object> putHandlersByName) {
        this.verifyManifest(manifestElements);
        this.makePutHandlers(this.getRootContainer(), manifestElements, "", 0x200000L, null);
    }

    private void verifyManifest(HashMap<String, Object> metadata) {
        Set<String> set = metadata.keySet();
        for (String name : set) {
            Object o = metadata.get(name);
            if (o instanceof HashMap) {
                HashMap hm = (HashMap)o;
                this.verifyManifest(hm);
                continue;
            }
            if (o instanceof ManifestElement) continue;
            throw new IllegalArgumentException("FATAL: unknown manifest element: " + o);
        }
    }

    private long makePutHandlers(BaseManifestPutter.ContainerBuilder containerBuilder, HashMap<String, Object> manifestElements, String prefix, long maxSize, String parentName) {
        HashMap hm;
        Object o;
        ContainerSizeEstimator.ContainerSize wholeSize;
        System.out.println("STAT: handling " + (parentName == null ? "<root>?" : parentName));
        if (maxSize == 0x200000L) {
            maxSize = 1896448L;
        }
        if ((wholeSize = ContainerSizeEstimator.getSubTreeSize(manifestElements, 0x100000L, maxSize, Integer.MAX_VALUE)).getSizeTotalNoLimit() <= maxSize) {
            System.out.println("PackStat2: the whole tree (unlimited) fits into container (no externals)");
            this.makeEveryThingUnlimitedPutHandlers(containerBuilder, manifestElements, prefix);
            return wholeSize.getSizeTotalNoLimit();
        }
        if (wholeSize.getSizeTotal() <= maxSize) {
            System.out.println("PackStat2: the whole tree fits into container (with externals)");
            this.makeEveryThingPutHandlers(containerBuilder, manifestElements, prefix);
            return wholeSize.getSizeTotal();
        }
        Set<String> keyset = manifestElements.keySet();
        long tmpSize = 0L;
        if (wholeSize.getSizeFiles() < maxSize || wholeSize.getSizeFilesNoLimit() < maxSize) {
            ManifestElement me;
            Object o2;
            System.out.println("PackStat2: the files in dir fits into container with spare, so it need to grab stuff from sub's to fill container up");
            if (wholeSize.getSizeFilesNoLimit() < maxSize) {
                for (String name : keyset) {
                    o2 = manifestElements.get(name);
                    if (!(o2 instanceof ManifestElement)) continue;
                    me = (ManifestElement)o2;
                    containerBuilder.addItem(name, prefix + name, me.getMimeTypeOverride(), me.getData());
                }
                tmpSize = wholeSize.getSizeFilesNoLimit();
            } else {
                for (String name : keyset) {
                    o2 = manifestElements.get(name);
                    if (!(o2 instanceof ManifestElement)) continue;
                    me = (ManifestElement)o2;
                    if (me.getSize() > 0x100000L) {
                        containerBuilder.addExternal(name, me.getMimeTypeOverride(), me.getData());
                        continue;
                    }
                    containerBuilder.addItem(name, prefix + name, me.getMimeTypeOverride(), me.getData());
                }
                tmpSize = wholeSize.getSizeFiles();
            }
            for (String name : keyset) {
                o2 = manifestElements.get(name);
                if (!(o2 instanceof HashMap)) continue;
                HashMap hm2 = (HashMap)o2;
                if ((tmpSize += 512L) < maxSize) {
                    containerBuilder.pushCurrentDir();
                    containerBuilder.makeSubDirCD(name);
                    tmpSize += this.makePutHandlers(containerBuilder, hm2, "", maxSize - tmpSize, name);
                    containerBuilder.popCurrentDir();
                    continue;
                }
                BaseManifestPutter.ContainerBuilder subC = containerBuilder.makeSubContainer(name);
                this.makePutHandlers(subC, hm2, "", 0x200000L, name);
            }
            return tmpSize;
        }
        if (wholeSize.getSizeSubTrees() < maxSize || wholeSize.getSizeSubTreesNoLimit() < maxSize) {
            System.out.print("PackStat2: the sub dirs fit into container with spare, so it need to grab files to fill container up");
            if (wholeSize.getSizeSubTreesNoLimit() < maxSize) {
                System.out.println(" (unlimited)");
                for (String name : keyset) {
                    o = manifestElements.get(name);
                    if (!(o instanceof HashMap)) continue;
                    hm = (HashMap)o;
                    containerBuilder.pushCurrentDir();
                    containerBuilder.makeSubDirCD(name);
                    this.makeEveryThingUnlimitedPutHandlers(containerBuilder, hm, prefix);
                    containerBuilder.popCurrentDir();
                }
                tmpSize = wholeSize.getSizeSubTreesNoLimit();
            } else {
                System.out.println(" (limited)");
                for (String name : keyset) {
                    o = manifestElements.get(name);
                    if (!(o instanceof HashMap)) continue;
                    hm = (HashMap)o;
                    containerBuilder.pushCurrentDir();
                    containerBuilder.makeSubDirCD(name);
                    this.makeEveryThingPutHandlers(containerBuilder, hm, prefix);
                    containerBuilder.popCurrentDir();
                }
                tmpSize = wholeSize.getSizeSubTrees();
            }
        } else {
            System.out.print("PackStat2: sub dirs does not fit into container, make each its own");
            for (String name : keyset) {
                o = manifestElements.get(name);
                if (!(o instanceof HashMap)) continue;
                hm = (HashMap)o;
                BaseManifestPutter.ContainerBuilder subC = containerBuilder.makeSubContainer(name);
                this.makePutHandlers(subC, hm, "", 0x200000L, name);
                tmpSize += 512L;
            }
        }
        HashMap<String, Object> itemsLeft = new HashMap<String, Object>();
        for (String name : keyset) {
            Object o3 = manifestElements.get(name);
            if (!(o3 instanceof ManifestElement)) continue;
            ManifestElement me = (ManifestElement)o3;
            if (me.getSize() > -1L && me.getSize() <= 0x100000L && me.getSize() < maxSize - tmpSize) {
                containerBuilder.addItem(name, name, me.getMimeTypeOverride(), me.getData());
                tmpSize += ContainerSizeEstimator.tarItemSize(me.getSize());
                continue;
            }
            tmpSize += 512L;
            itemsLeft.put(name, me);
        }
        while (!itemsLeft.isEmpty()) {
            System.out.println("ItemsLeft checker: " + itemsLeft.size());
            if (itemsLeft.size() == 1) {
                Set lKeySetset = itemsLeft.keySet();
                for (String lname : lKeySetset) {
                    ManifestElement me = (ManifestElement)itemsLeft.get(lname);
                    containerBuilder.addExternal(lname, me.getMimeTypeOverride(), me.getData());
                }
                itemsLeft.clear();
                continue;
            }
            long leftLimit = 1896448L;
            ContainerSizeEstimator.ContainerSize leftSize = ContainerSizeEstimator.getSubTreeSize(itemsLeft, 0x100000L, 1896448L, 0);
            if (leftSize.getSizeFiles() > 0L && leftSize.getSizeFilesNoLimit() <= 1896448L) {
                BaseManifestPutter.ContainerBuilder archive = this.makeArchive();
                Set<String> lKeySetset = itemsLeft.keySet();
                for (String lname : lKeySetset) {
                    ManifestElement me = (ManifestElement)itemsLeft.get(lname);
                    containerBuilder.addArchiveItem(archive, lname, lname, me.getMimeTypeOverride(), me.getData());
                }
                itemsLeft.clear();
                continue;
            }
            if (leftSize.getSizeFiles() == 0L && leftSize.getSizeFilesNoLimit() > 0L) {
                Set<String> lKeySetset = itemsLeft.keySet();
                for (String lname : lKeySetset) {
                    ManifestElement me = (ManifestElement)itemsLeft.get(lname);
                    containerBuilder.addExternal(lname, me.getMimeTypeOverride(), me.getData());
                }
                itemsLeft.clear();
                continue;
            }
            long archiveLimit = 200704L;
            Set<String> lKeySetset = itemsLeft.keySet();
            BaseManifestPutter.ContainerBuilder archive = this.makeArchive();
            for (String lname : lKeySetset) {
                ManifestElement me = (ManifestElement)itemsLeft.get(lname);
                if (me.getSize() <= -1L || me.getSize() > 0x100000L || me.getSize() >= 0x200000L - archiveLimit) continue;
                containerBuilder.addArchiveItem(archive, lname, lname, me.getMimeTypeOverride(), me.getData());
                tmpSize += 512L;
                archiveLimit += ContainerSizeEstimator.tarItemSize(me.getSize());
                lKeySetset.remove(lname);
            }
        }
        return tmpSize;
    }

    private void makeEveryThingUnlimitedPutHandlers(BaseManifestPutter.ContainerBuilder containerBuilder, HashMap<String, Object> manifestElements, String prefix) {
        Object o;
        for (String name : manifestElements.keySet()) {
            o = manifestElements.get(name);
            if (!(o instanceof ManifestElement)) continue;
            ManifestElement element = (ManifestElement)o;
            containerBuilder.addItem(name, prefix + name, element.getMimeTypeOverride(), element.getData());
        }
        for (String name : manifestElements.keySet()) {
            o = manifestElements.get(name);
            if (!(o instanceof HashMap)) continue;
            HashMap hm = (HashMap)o;
            containerBuilder.pushCurrentDir();
            containerBuilder.makeSubDirCD(name);
            this.makeEveryThingUnlimitedPutHandlers(containerBuilder, hm, "");
            containerBuilder.popCurrentDir();
        }
    }

    private void makeEveryThingPutHandlers(BaseManifestPutter.ContainerBuilder containerBuilder, HashMap<String, Object> manifestElements, String prefix) {
        Object o;
        for (String name : manifestElements.keySet()) {
            o = manifestElements.get(name);
            if (!(o instanceof ManifestElement)) continue;
            ManifestElement element = (ManifestElement)o;
            if (element.getSize() > 0x100000L) {
                containerBuilder.addExternal(name, element.getMimeTypeOverride(), element.getData());
                continue;
            }
            containerBuilder.addItem(name, prefix + name, element.getMimeTypeOverride(), element.getData());
        }
        for (String name : manifestElements.keySet()) {
            o = manifestElements.get(name);
            if (!(o instanceof HashMap)) continue;
            HashMap hm = (HashMap)o;
            containerBuilder.pushCurrentDir();
            containerBuilder.makeSubDirCD(name);
            this.makeEveryThingPutHandlers(containerBuilder, hm, "");
            containerBuilder.popCurrentDir();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }
}

