/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.async.BlockSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.DatastoreCheckerItem;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.Node;
import freenet.node.PrioRunnable;
import freenet.node.SendableGet;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;

public class DatastoreChecker
implements PrioRunnable {
    private static volatile boolean logMINOR;
    static final int MAX_PERSISTENT_KEYS = 1024;
    private final ArrayList<Key[]>[] persistentKeys;
    private final ArrayList<SendableGet>[] persistentGetters;
    private final ArrayList<Boolean>[] persistentDontCache;
    private final ArrayList<ClientRequestScheduler>[] persistentSchedulers;
    private final ArrayList<DatastoreCheckerItem>[] persistentCheckerItems;
    private final ArrayList<BlockSet>[] persistentBlockSets;
    private final ArrayList<Key[]>[] transientKeys;
    private final ArrayList<SendableGet>[] transientGetters;
    private final ArrayList<BlockSet>[] transientBlockSets;
    private ClientContext context;
    private final Node node;
    private final DBJob loader = new DBJob(){

        public boolean run(ObjectContainer container, ClientContext context) {
            DatastoreChecker.this.loadPersistentRequests(container, context);
            return false;
        }
    };

    public synchronized void setContext(ClientContext context) {
        this.context = context;
    }

    public DatastoreChecker(Node node) {
        int i;
        this.node = node;
        int priorities = 7;
        this.persistentKeys = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.persistentKeys[i] = new ArrayList();
        }
        this.persistentGetters = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.persistentGetters[i] = new ArrayList();
        }
        this.persistentDontCache = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.persistentDontCache[i] = new ArrayList();
        }
        this.persistentSchedulers = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.persistentSchedulers[i] = new ArrayList();
        }
        this.persistentCheckerItems = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.persistentCheckerItems[i] = new ArrayList();
        }
        this.persistentBlockSets = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.persistentBlockSets[i] = new ArrayList();
        }
        this.transientKeys = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.transientKeys[i] = new ArrayList();
        }
        this.transientGetters = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.transientGetters[i] = new ArrayList();
        }
        this.transientBlockSets = new ArrayList[priorities];
        for (i = 0; i < priorities; ++i) {
            this.transientBlockSets[i] = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPersistentRequests(ObjectContainer container, ClientContext context) {
        int totalSize = 0;
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            for (int i = 0; i < this.persistentKeys.length; ++i) {
                for (int j = 0; j < this.persistentKeys[i].size(); ++j) {
                    totalSize += this.persistentKeys[i].get(j).length;
                }
            }
            if (totalSize > 1024) {
                if (logMINOR) {
                    Logger.minor(this, "Persistent datastore checker queue already full");
                }
                return;
            }
        }
        for (short p = 0; p <= 6; p = (short)(p + 1)) {
            short prio = p;
            Query query = container.query();
            query.constrain(DatastoreCheckerItem.class);
            query.descend("nodeDBHandle").constrain((Object)context.nodeDBHandle).and(query.descend("prio").constrain((Object)prio));
            ObjectSet results = query.execute();
            for (DatastoreCheckerItem item : results) {
                if (item.chosenBy == context.bootID) continue;
                SendableGet getter = item.getter;
                if (getter == null || !container.ext().isStored((Object)getter)) {
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring DatastoreCheckerItem because the SendableGet has already been deleted from the database");
                    }
                    container.delete((Object)item);
                    continue;
                }
                BlockSet blocks = item.blocks;
                container.activate((Object)getter, 1);
                boolean dontCache = getter.dontCache(container);
                ClientRequestScheduler sched = getter.getScheduler(context);
                DatastoreChecker datastoreChecker2 = this;
                synchronized (datastoreChecker2) {
                    if (this.persistentGetters[prio].contains(getter)) {
                        continue;
                    }
                }
                Key[] keys = getter.listKeys(container);
                item.chosenBy = context.bootID;
                container.store((Object)item);
                DatastoreChecker datastoreChecker3 = this;
                synchronized (datastoreChecker3) {
                    if (this.persistentGetters[prio].contains(getter)) {
                        continue;
                    }
                    ArrayList<Key> finalKeysToCheck = new ArrayList<Key>();
                    for (Key key : keys) {
                        key = key.cloneKey();
                        finalKeysToCheck.add(key);
                    }
                    Key[] finalKeys = finalKeysToCheck.toArray(new Key[finalKeysToCheck.size()]);
                    this.persistentKeys[prio].add(finalKeys);
                    this.persistentGetters[prio].add(getter);
                    this.persistentDontCache[prio].add(dontCache);
                    this.persistentSchedulers[prio].add(sched);
                    this.persistentCheckerItems[prio].add(item);
                    this.persistentBlockSets[prio].add(blocks);
                    if (totalSize == 0) {
                        this.notifyAll();
                    }
                    if ((totalSize += finalKeys.length) > 1024) {
                        boolean full = this.trimPersistentQueue(prio, container);
                        this.notifyAll();
                        if (full) {
                            return;
                        }
                    } else {
                        this.notifyAll();
                    }
                }
                container.deactivate((Object)getter, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trimPersistentQueue(short prio, ObjectContainer container) {
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            int i;
            int i2;
            int preQueueSize = 0;
            for (i2 = 0; i2 < prio; ++i2) {
                for (int x = 0; x < this.persistentKeys[i2].size(); ++x) {
                    preQueueSize += this.persistentKeys[i2].get(x).length;
                }
            }
            if (preQueueSize > 1024) {
                for (i2 = prio + 1; i2 < this.persistentKeys.length; ++i2) {
                    for (DatastoreCheckerItem item : this.persistentCheckerItems[i2]) {
                        item.chosenBy = 0L;
                        container.store((Object)item);
                    }
                    this.persistentSchedulers[i2].clear();
                    this.persistentDontCache[i2].clear();
                    this.persistentGetters[i2].clear();
                    this.persistentKeys[i2].clear();
                    this.persistentBlockSets[i2].clear();
                }
                return true;
            }
            int postQueueSize = 0;
            for (i = prio + 1; i < this.persistentKeys.length; ++i) {
                for (int x = 0; x < this.persistentKeys[i].size(); ++x) {
                    postQueueSize += this.persistentKeys[i].get(x).length;
                }
            }
            if (postQueueSize + preQueueSize < 1024) {
                return false;
            }
            for (i = this.persistentKeys.length - 1; i > prio; --i) {
                while (!this.persistentKeys[i].isEmpty()) {
                    int idx = this.persistentKeys[i].size() - 1;
                    DatastoreCheckerItem item = this.persistentCheckerItems[i].remove(idx);
                    this.persistentSchedulers[i].remove(idx);
                    this.persistentDontCache[i].remove(idx);
                    this.persistentGetters[i].remove(idx);
                    Key[] keys = this.persistentKeys[i].remove(idx);
                    this.persistentBlockSets[i].remove(idx);
                    item.chosenBy = 0L;
                    container.store((Object)item);
                    if (postQueueSize + preQueueSize - keys.length < 1024) {
                        return false;
                    }
                    postQueueSize -= keys.length;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTransientRequest(SendableGet getter, BlockSet blocks) {
        if (logMINOR) {
            Logger.minor(this, "Queueing transient request " + getter);
        }
        Key[] checkKeys = getter.listKeys(null);
        short prio = getter.getPriorityClass(null);
        ArrayList<Key> finalKeysToCheck = new ArrayList<Key>();
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            for (Key key : checkKeys) {
                finalKeysToCheck.add(key);
            }
            this.transientGetters[prio].add(getter);
            this.transientKeys[prio].add(finalKeysToCheck.toArray(new Key[finalKeysToCheck.size()]));
            this.transientBlockSets[prio].add(blocks);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePersistentRequest(SendableGet getter, BlockSet blocks, ObjectContainer container) {
        Key[] checkKeys = getter.listKeys(container);
        short prio = getter.getPriorityClass(container);
        boolean dontCache = getter.dontCache(container);
        ClientRequestScheduler sched = getter.getScheduler(this.context);
        DatastoreCheckerItem item = new DatastoreCheckerItem(getter, this.context.nodeDBHandle, prio, blocks);
        container.store((Object)item);
        container.activate((Object)blocks, 5);
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            int queueSize = 0;
            for (short p = 0; p <= prio; p = (short)(p + 1)) {
                for (int x = 0; x < this.persistentKeys[p].size(); ++x) {
                    queueSize += this.persistentKeys[p].get(x).length;
                }
            }
            if (queueSize > 1024) {
                return;
            }
            item.chosenBy = this.context.bootID;
            container.store((Object)item);
            ArrayList<Key> finalKeysToCheck = new ArrayList<Key>();
            for (Key key : checkKeys) {
                finalKeysToCheck.add(key);
            }
            this.persistentGetters[prio].add(getter);
            this.persistentKeys[prio].add(finalKeysToCheck.toArray(new Key[finalKeysToCheck.size()]));
            this.persistentDontCache[prio].add(dontCache);
            this.persistentSchedulers[prio].add(sched);
            this.persistentCheckerItems[prio].add(item);
            this.persistentBlockSets[prio].add(blocks);
            this.trimPersistentQueue(prio, container);
            this.notifyAll();
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " in datastore checker thread", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        Key[] keys = null;
        SendableGet getter = null;
        boolean persistent = false;
        boolean dontCache = false;
        ClientRequestScheduler sched = null;
        DatastoreCheckerItem item = null;
        BlockSet blocks = null;
        int queueSize = this.context.jobRunner.getQueueSize(6);
        if (queueSize > 500) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return;
        }
        boolean notPersistent = queueSize > 100;
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            while (true) {
                for (int prio = 0; prio < this.transientKeys.length; prio = (int)((short)(prio + 1))) {
                    if (!this.transientKeys[prio].isEmpty()) {
                        keys = this.transientKeys[prio].remove(0);
                        getter = this.transientGetters[prio].remove(0);
                        persistent = false;
                        item = null;
                        blocks = this.transientBlockSets[prio].remove(0);
                        if (!logMINOR) break;
                        Logger.minor(this, "Checking transient request " + getter + " prio " + prio);
                        break;
                    }
                    if (notPersistent || this.persistentGetters[prio].isEmpty()) continue;
                    keys = this.persistentKeys[prio].remove(0);
                    getter = this.persistentGetters[prio].remove(0);
                    persistent = true;
                    dontCache = this.persistentDontCache[prio].remove(0);
                    sched = this.persistentSchedulers[prio].remove(0);
                    item = this.persistentCheckerItems[prio].remove(0);
                    blocks = this.persistentBlockSets[prio].remove(0);
                    break;
                }
                if (keys != null) break;
                if (logMINOR) {
                    Logger.minor(this, "Waiting for more persistent requests");
                }
                try {
                    this.context.jobRunner.queue(this.loader, 7, true);
                }
                catch (DatabaseDisabledException e1) {
                    // empty catch block
                }
                try {
                    this.wait(100000L);
                }
                catch (InterruptedException e) {}
            }
        }
        if (!persistent) {
            dontCache = getter.dontCache(null);
            sched = getter.getScheduler(this.context);
        }
        boolean anyValid = false;
        for (Key key : keys) {
            KeyBlock block = null;
            if (blocks != null) {
                block = blocks.get(key);
            }
            if (blocks == null) {
                block = this.node.fetch(key, dontCache);
            }
            if (block != null) {
                if (logMINOR) {
                    Logger.minor(this, "Found key");
                }
                if (key instanceof NodeSSK) {
                    sched.tripPendingKey(block);
                    continue;
                }
                sched.tripPendingKey(block);
                continue;
            }
            anyValid = true;
        }
        if (persistent) {
            try {
                this.context.jobRunner.queue(this.loader, 7, true);
            }
            catch (DatabaseDisabledException e) {
                // empty catch block
            }
        }
        if (persistent) {
            final SendableGet get = getter;
            final ClientRequestScheduler scheduler = sched;
            final boolean valid = anyValid;
            final DatastoreCheckerItem it = item;
            try {
                this.context.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)get)) {
                            Logger.error(this, "ALREADY ACTIVATED: " + get);
                        }
                        if (!container.ext().isStored((Object)get)) {
                            if (logMINOR) {
                                Logger.minor(this, "Already deleted from database");
                            }
                            container.delete((Object)it);
                            return false;
                        }
                        container.activate((Object)get, 1);
                        scheduler.finishRegister(new SendableGet[]{get}, true, container, valid, it);
                        container.deactivate((Object)get, 1);
                        DatastoreChecker.this.loader.run(container, context);
                        return false;
                    }
                }, 5, false);
            }
            catch (DatabaseDisabledException e) {}
        } else {
            sched.finishRegister(new SendableGet[]{getter}, false, null, anyValid, item);
        }
    }

    synchronized void wakeUp() {
        this.notifyAll();
    }

    public void start(Executor executor, String name) {
        try {
            this.context.jobRunner.queue(this.loader, 6, true);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
        executor.execute(this, name);
    }

    public int getPriority() {
        return 5;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing DatastoreChecker in database", new Exception("error"));
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

