/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.ManifestElement;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInserter
implements ClientPutState {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private ArrayList<ContainerElement> containerItems;
    private final BaseClientPutter parent;
    private final PutCompletionCallback cb;
    private boolean cancelled;
    private boolean finished;
    private final boolean persistent;
    private final HashMap<String, Object> origMetadata;
    private final ArchiveManager.ARCHIVE_TYPE archiveType;
    private final FreenetURI targetURI;
    private final Object token;
    private final boolean getCHKOnly;
    private final boolean earlyEncode;
    private final InsertContext ctx;
    private final boolean reportMetadataOnly;
    private final boolean dontCompress;
    private final int hashCode;

    public ContainerInserter(BaseClientPutter parent2, PutCompletionCallback cb2, HashMap<String, Object> metadata2, FreenetURI targetURI2, InsertContext ctx2, boolean dontCompress2, boolean getCHKOnly2, boolean reportMetadataOnly2, Object token2, ArchiveManager.ARCHIVE_TYPE archiveType2, boolean freeData, boolean earlyEncode2) {
        this.parent = parent2;
        this.cb = cb2;
        this.hashCode = super.hashCode();
        this.persistent = this.parent.persistent();
        this.origMetadata = metadata2;
        this.archiveType = archiveType2;
        this.targetURI = targetURI2;
        this.token = token2;
        this.getCHKOnly = getCHKOnly2;
        this.earlyEncode = earlyEncode2;
        this.ctx = ctx2;
        this.dontCompress = dontCompress2;
        this.reportMetadataOnly = reportMetadataOnly2;
        this.containerItems = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        ContainerInserter containerInserter = this;
        synchronized (containerInserter) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
        }
        if (this.persistent) {
            container.store((Object)this);
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(new InsertException(10), this, container, context);
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void schedule(ObjectContainer container, ClientContext context) throws InsertException {
        this.start(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(ObjectContainer container, ClientContext context) {
        InsertBlock block;
        if (logDEBUG) {
            Logger.debug(this, "Atempt to start a container inserter", new Exception("debug"));
        }
        this.makeMetadata(context, container);
        ContainerInserter containerInserter = this;
        synchronized (containerInserter) {
            if (this.finished) {
                return;
            }
        }
        try {
            String mimeType;
            Bucket outputBucket = context.getBucketFactory(this.persistent).makeBucket(-1L);
            String string = mimeType = this.archiveType == ArchiveManager.ARCHIVE_TYPE.TAR ? this.createTarBucket(outputBucket, container) : this.createZipBucket(outputBucket, container);
            if (logMINOR) {
                Logger.minor(this, "We are using " + (Object)((Object)this.archiveType));
            }
            block = new InsertBlock(outputBucket, new ClientMetadata(mimeType), this.persistent ? this.targetURI.clone() : this.targetURI);
        }
        catch (IOException e) {
            this.fail(new InsertException(2, e, null), container, context);
            return;
        }
        boolean dc = this.dontCompress;
        if (!this.dontCompress) {
            dc = this.archiveType == ArchiveManager.ARCHIVE_TYPE.ZIP;
        }
        SingleFileInserter sfi = new SingleFileInserter(this.parent, this.cb, block, false, this.ctx, dc, this.getCHKOnly, this.reportMetadataOnly, this.token, this.archiveType, true, null, this.earlyEncode);
        if (logMINOR) {
            Logger.minor(this, "Inserting container: " + sfi + " for " + this);
        }
        this.cb.onTransition(this, sfi, container);
        try {
            sfi.schedule(container, context);
        }
        catch (InsertException e) {
            this.fail(new InsertException(2, e, null), container, context);
            return;
        }
        this.cb.onBlockSetFinished(this, container, context);
    }

    private void makeMetadata(ClientContext context, ObjectContainer container) {
        Bucket bucket = null;
        int x = 0;
        HashMap<String, Object> manifest = new HashMap<String, Object>();
        this.makeManifest(this.origMetadata, manifest, "/");
        Metadata md = Metadata.mkRedirectionManifestWithMetadata(manifest);
        while (true) {
            try {
                bucket = context.tempBucketFactory.makeBucket(-1L);
                byte[] buf = md.writeToByteArray();
                OutputStream os = bucket.getOutputStream();
                os.write(buf);
                os.close();
                this.containerItems.add(new ContainerElement(bucket, ".metadata"));
                return;
            }
            catch (IOException e) {
                this.fail(new InsertException(3, e, null), container, context);
                return;
            }
            catch (MetadataUnresolvedException e) {
                try {
                    x = this.resolve(e, x, bucket, null, null, container, context);
                }
                catch (IOException e1) {
                    this.fail(new InsertException(3, e, null), container, context);
                    return;
                }
            }
        }
    }

    private int resolve(MetadataUnresolvedException e, int x, Bucket bucket, FreenetURI key, String element2, ObjectContainer container, ClientContext context) throws IOException {
        Metadata[] m = e.mustResolve;
        for (int i = 0; i < m.length; ++i) {
            try {
                byte[] buf = m[i].writeToByteArray();
                OutputStream os = bucket.getOutputStream();
                os.write(buf);
                os.close();
                String nameInArchive = ".metadata-" + x++;
                this.containerItems.add(new ContainerElement(bucket, nameInArchive));
                m[i].resolve(nameInArchive);
                continue;
            }
            catch (MetadataUnresolvedException e1) {
                x = this.resolve(e, x, bucket, key, element2, container, context);
            }
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        ContainerInserter containerInserter = this;
        synchronized (containerInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container, context);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "objectCanUpdate() on " + this, (Throwable)new Exception("debug"));
        }
        return true;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "objectCanNew() on " + this, (Throwable)new Exception("debug"));
        }
        return true;
    }

    private String createTarBucket(Bucket outputBucket, ObjectContainer container) throws IOException {
        if (logMINOR) {
            Logger.minor(this, "Create a TAR Bucket");
        }
        BufferedOutputStream os = new BufferedOutputStream(outputBucket.getOutputStream());
        TarOutputStream tarOS = new TarOutputStream((OutputStream)os);
        tarOS.setLongFileMode(2);
        for (ContainerElement ph : this.containerItems) {
            if (logMINOR) {
                Logger.minor(this, "Putting into tar: " + ph + " data length " + ph.data.size() + " name " + ph.targetInArchive);
            }
            TarEntry ze = new TarEntry(ph.targetInArchive);
            ze.setModTime(0L);
            long size = ph.data.size();
            ze.setSize(size);
            tarOS.putNextEntry(ze);
            BucketTools.copyTo(ph.data, (OutputStream)tarOS, size);
            tarOS.closeEntry();
        }
        tarOS.closeEntry();
        tarOS.finish();
        tarOS.flush();
        tarOS.close();
        if (logMINOR) {
            Logger.minor(this, "Archive size is " + outputBucket.size());
        }
        return ArchiveManager.ARCHIVE_TYPE.TAR.mimeTypes[0];
    }

    private String createZipBucket(Bucket outputBucket, ObjectContainer container) throws IOException {
        if (logMINOR) {
            Logger.minor(this, "Create a ZIP Bucket");
        }
        BufferedOutputStream os = new BufferedOutputStream(outputBucket.getOutputStream());
        ZipOutputStream zos = new ZipOutputStream(os);
        for (ContainerElement ph : this.containerItems) {
            ZipEntry ze = new ZipEntry(ph.targetInArchive);
            ze.setTime(0L);
            zos.putNextEntry(ze);
            BucketTools.copyTo(ph.data, zos, ph.data.size());
            zos.closeEntry();
        }
        zos.closeEntry();
        zos.finish();
        zos.flush();
        zos.close();
        return ArchiveManager.ARCHIVE_TYPE.ZIP.mimeTypes[0];
    }

    private void makeManifest(HashMap<String, Object> manifestElements, HashMap<String, Object> manifest, String archivePrefix) {
        for (Map.Entry<String, Object> me : manifestElements.entrySet()) {
            Metadata m;
            String name = me.getKey();
            Object o = me.getValue();
            if (o instanceof HashMap) {
                HashMap hm = (HashMap)o;
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                manifest.put(name, subMap);
                this.makeManifest(hm, subMap, archivePrefix + name + '/');
                if (!Logger.shouldLog(2, this)) continue;
                Logger.debug(this, "Sub map for " + name + " : " + subMap.size() + " elements from " + hm.size());
                continue;
            }
            if (o instanceof Metadata) {
                manifest.put(name, o);
                continue;
            }
            ManifestElement element = (ManifestElement)o;
            String mimeType = element.mimeOverride;
            ClientMetadata cm = mimeType == null || mimeType.equals("application/octet-stream") ? null : new ClientMetadata(mimeType);
            if (element.targetURI != null) {
                m = new Metadata(0, null, null, element.targetURI, cm);
            } else {
                this.containerItems.add(new ContainerElement(element.data, archivePrefix + name));
                m = new Metadata(4, null, null, archivePrefix + element.fullName, cm);
            }
            manifest.put(name, m);
        }
    }

    static {
        Logger.registerClass(ContainerInserter.class);
    }

    private static class ContainerElement {
        private final Bucket data;
        private final String targetInArchive;

        private ContainerElement(Bucket data2, String targetInArchive2) {
            this.data = data2;
            this.targetInArchive = targetInArchive2;
        }
    }
}

