/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.PersistentSendableRequestSet;
import freenet.client.async.SendableRequestSet;
import freenet.client.async.TransientSendableRequestSet;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.node.SendableRequest;
import freenet.support.Logger;

public abstract class ClientRequester {
    private static volatile boolean logMINOR;
    protected short priorityClass;
    protected boolean cancelled;
    protected final RequestClient client;
    protected final SendableRequestSet requests;
    private final int hashCode;
    protected int totalBlocks;
    protected int successfulBlocks;
    protected int failedBlocks;
    protected int fatallyFailedBlocks;
    protected int minSuccessBlocks;
    protected boolean blockSetFinalized;
    protected boolean sentToNetwork;

    public abstract void onTransition(ClientGetState var1, ClientGetState var2, ObjectContainer var3);

    public short getPriorityClass() {
        return this.priorityClass;
    }

    protected ClientRequester(short priorityClass, RequestClient client) {
        this.priorityClass = priorityClass;
        this.client = client;
        if (client == null) {
            throw new NullPointerException();
        }
        this.hashCode = super.hashCode();
        this.requests = this.persistent() ? new PersistentSendableRequestSet() : new TransientSendableRequestSet();
    }

    public synchronized boolean cancel() {
        boolean ret = this.cancelled;
        this.cancelled = true;
        return ret;
    }

    public abstract void cancel(ObjectContainer var1, ClientContext var2);

    public boolean isCancelled() {
        return this.cancelled;
    }

    public abstract FreenetURI getURI();

    public abstract boolean isFinished();

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockSetFinalized(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.blockSetFinalized) {
                return;
            }
            this.blockSetFinalized = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Finalized set of blocks for " + this, (Throwable)new Exception("debug"));
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.notifyClients(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlock(ObjectContainer container) {
        boolean wasFinalized;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.totalBlocks;
            wasFinalized = this.blockSetFinalized;
        }
        if (wasFinalized) {
            if (Logger.globalGetThreshold() > 4) {
                Logger.error(this, "addBlock() but set finalized! on " + this);
            } else {
                Logger.error(this, "addBlock() but set finalized! on " + this, new Exception("error"));
            }
        }
        if (logMINOR) {
            Logger.minor(this, "addBlock(): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlocks(int num, ObjectContainer container) {
        boolean wasFinalized;
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            this.totalBlocks += num;
            wasFinalized = this.blockSetFinalized;
        }
        if (wasFinalized) {
            if (Logger.globalGetThreshold() > 4) {
                Logger.error(this, "addBlocks() but set finalized! on " + this);
            } else {
                Logger.error(this, "addBlocks() but set finalized! on " + this, new Exception("error"));
            }
        }
        if (logMINOR) {
            Logger.minor(this, "addBlocks(" + num + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completedBlock(boolean dontNotify, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Completed block (" + dontNotify + "): total=" + this.totalBlocks + " success=" + this.successfulBlocks + " failed=" + this.failedBlocks + " fatally=" + this.fatallyFailedBlocks + " finalised=" + this.blockSetFinalized + " required=" + this.minSuccessBlocks + " on " + this);
        }
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.cancelled) {
                return;
            }
            ++this.successfulBlocks;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (dontNotify) {
            return;
        }
        this.notifyClients(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failedBlock(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.failedBlocks;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.notifyClients(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatallyFailedBlock(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            ++this.fatallyFailedBlocks;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.notifyClients(container, context);
    }

    public synchronized void addMustSucceedBlocks(int blocks, ObjectContainer container) {
        this.minSuccessBlocks += blocks;
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (logMINOR) {
            Logger.minor(this, "addMustSucceedBlocks(" + blocks + "): total=" + this.totalBlocks + " successful=" + this.successfulBlocks + " failed=" + this.failedBlocks + " required=" + this.minSuccessBlocks);
        }
    }

    public abstract void notifyClients(ObjectContainer var1, ClientContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toNetwork(ObjectContainer container, ClientContext context) {
        ClientRequester clientRequester = this;
        synchronized (clientRequester) {
            if (this.sentToNetwork) {
                return;
            }
            this.sentToNetwork = true;
            if (this.persistent()) {
                container.store((Object)this);
            }
        }
        this.innerToNetwork(container, context);
    }

    protected abstract void innerToNetwork(ObjectContainer var1, ClientContext var2);

    public RequestClient getClient() {
        return this.client;
    }

    public void setPriorityClass(short newPriorityClass, ClientContext ctx, ObjectContainer container) {
        this.priorityClass = newPriorityClass;
        ctx.getChkFetchScheduler().reregisterAll(this, container);
        ctx.getChkInsertScheduler().reregisterAll(this, container);
        ctx.getSskFetchScheduler().reregisterAll(this, container);
        ctx.getSskInsertScheduler().reregisterAll(this, container);
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public boolean persistent() {
        return this.client.persistent();
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.requests, 1);
        this.requests.removeFrom(container);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        container.activate((Object)this.client, 1);
    }

    public void addToRequests(SendableRequest req, ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.requests, 1);
        }
        this.requests.addRequest(req, container);
        if (this.persistent()) {
            container.deactivate((Object)this.requests, 1);
        }
    }

    public SendableRequest[] getSendableRequests(ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.requests, 1);
        }
        SendableRequest[] reqs = this.requests.listRequests(container);
        if (this.persistent()) {
            container.deactivate((Object)this.requests, 1);
        }
        return reqs;
    }

    public void removeFromRequests(SendableRequest req, ObjectContainer container, boolean dontComplain) {
        if (this.persistent()) {
            container.activate((Object)this.requests, 1);
        }
        if (!this.requests.removeRequest(req, container) && !dontComplain) {
            Logger.error(this, "Not in request list for " + this + ": " + req);
        }
        if (this.persistent()) {
            container.deactivate((Object)this.requests, 1);
        }
    }

    static {
        Logger.registerClass(ClientRequester.class);
    }
}

