/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerBase;
import freenet.node.BaseSendableGet;
import freenet.support.Logger;
import java.util.LinkedList;
import java.util.List;

class ClientRequestSchedulerNonPersistent
extends ClientRequestSchedulerBase {
    private boolean logMINOR;
    protected final List<BaseSendableGet> recentSuccesses;

    ClientRequestSchedulerNonPersistent(ClientRequestScheduler sched, boolean forInserts, boolean forSSKs) {
        super(forInserts, forSSKs);
        this.sched = sched;
        this.recentSuccesses = !forInserts ? new LinkedList<BaseSendableGet>() : null;
        this.logMINOR = Logger.shouldLog(4, this);
    }

    boolean persistent() {
        return false;
    }

    ObjectContainer container() {
        return null;
    }

    public void succeeded(BaseSendableGet succeeded, ObjectContainer container) {
        if (this.isInsertScheduler) {
            return;
        }
        if (this.persistent()) {
            container.activate((Object)succeeded, 1);
        }
        if (succeeded.isEmpty(container)) {
            return;
        }
        if (this.logMINOR) {
            Logger.minor(this, "Recording successful fetch from " + succeeded);
        }
        this.recentSuccesses.add(succeeded);
        while (this.recentSuccesses.size() > 8) {
            this.recentSuccesses.remove(0);
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing ClientRequestSchedulerNonPersistent in database", new Exception("error"));
        return false;
    }
}

