/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import freenet.client.FetchContext;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerBase;
import freenet.client.async.ClientRequestSchedulerNonPersistent;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.OfferedKeysList;
import freenet.client.async.PersistentCooldownQueue;
import freenet.client.async.RegisterMe;
import freenet.client.async.TransientChosenBlock;
import freenet.crypt.RandomSource;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.Node;
import freenet.node.RequestStarter;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItem;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.PrioritizedSerialExecutor;
import freenet.support.RandomGrabArray;
import freenet.support.RandomGrabArrayItem;
import freenet.support.SectoredRandomGrabArrayWithInt;
import freenet.support.SectoredRandomGrabArrayWithObject;
import freenet.support.SortedVectorByNumber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class ClientRequestSchedulerCore
extends ClientRequestSchedulerBase
implements KeysFetchingLocally {
    private final long nodeDBHandle;
    final PersistentCooldownQueue persistentCooldownQueue;
    private transient long initTime;
    private static volatile boolean logMINOR;
    private transient HashSet<Key> keysFetching;
    private transient HashSet<RunningTransientInsert> runningTransientInserts;
    public final byte[] globalSalt;
    private transient List<RandomGrabArray> recentSuccesses;
    private transient DBJob preRegisterMeRunner;
    private int ctr;
    private static final short[] tweakedPrioritySelector;
    private static final short[] prioritySelector;
    private transient ObjectSet registerMeSet;
    private transient RegisterMeRunner registerMeRunner;

    public static ClientRequestSchedulerCore create(Node node, final boolean forInserts, final boolean forSSKs, ObjectContainer selectorContainer, long cooldownTime, PrioritizedSerialExecutor databaseExecutor, ClientRequestScheduler sched, ClientContext context) {
        ClientRequestSchedulerCore core;
        final long nodeDBHandle = node.nodeDBHandle;
        if (selectorContainer == null) {
            ClientRequestSchedulerCore core2 = new ClientRequestSchedulerCore(node, forInserts, forSSKs, selectorContainer, cooldownTime);
            core2.onStarted(selectorContainer, cooldownTime, sched, context);
            return core2;
        }
        ObjectSet results = selectorContainer.query((Predicate)new Predicate<ClientRequestSchedulerCore>(){

            public boolean match(ClientRequestSchedulerCore core) {
                if (core.nodeDBHandle != nodeDBHandle) {
                    return false;
                }
                if (core.isInsertScheduler != forInserts) {
                    return false;
                }
                return core.isSSKScheduler == forSSKs;
            }
        });
        if (results.hasNext()) {
            core = (ClientRequestSchedulerCore)results.next();
            selectorContainer.activate((Object)core, 2);
            System.err.println("Loaded core...");
            if (core.nodeDBHandle != nodeDBHandle) {
                throw new IllegalStateException("Wrong nodeDBHandle");
            }
            if (core.isInsertScheduler != forInserts) {
                throw new IllegalStateException("Wrong isInsertScheduler");
            }
            if (core.isSSKScheduler != forSSKs) {
                throw new IllegalStateException("Wrong forSSKs");
            }
        } else {
            core = new ClientRequestSchedulerCore(node, forInserts, forSSKs, selectorContainer, cooldownTime);
            selectorContainer.store((Object)core);
            System.err.println("Created new core...");
        }
        core.onStarted(selectorContainer, cooldownTime, sched, context);
        return core;
    }

    ClientRequestSchedulerCore(Node node, boolean forInserts, boolean forSSKs, ObjectContainer selectorContainer, long cooldownTime) {
        super(forInserts, forSSKs);
        this.nodeDBHandle = node.nodeDBHandle;
        this.persistentCooldownQueue = !forInserts ? new PersistentCooldownQueue() : null;
        this.globalSalt = new byte[32];
        node.random.nextBytes(this.globalSalt);
    }

    private void onStarted(ObjectContainer container, long cooldownTime, ClientRequestScheduler sched, ClientContext context) {
        super.onStarted();
        System.err.println("insert scheduler: " + this.isInsertScheduler);
        if (!this.isInsertScheduler) {
            this.persistentCooldownQueue.setCooldownTime(cooldownTime);
        }
        this.sched = sched;
        this.initTime = System.currentTimeMillis();
        if (!this.isInsertScheduler) {
            this.keysFetching = new HashSet();
            this.runningTransientInserts = null;
            this.recentSuccesses = new ArrayList<RandomGrabArray>();
        } else {
            this.keysFetching = null;
            this.runningTransientInserts = new HashSet();
        }
        if (this.isInsertScheduler) {
            this.preRegisterMeRunner = new DBJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean run(ObjectContainer container, ClientContext context) {
                    ClientRequestSchedulerCore clientRequestSchedulerCore = ClientRequestSchedulerCore.this;
                    synchronized (clientRequestSchedulerCore) {
                        if (ClientRequestSchedulerCore.this.registerMeSet != null) {
                            return false;
                        }
                    }
                    long tStart = System.currentTimeMillis();
                    ObjectSet results = null;
                    for (int i = 0; i <= 6; ++i) {
                        Query query = container.query();
                        query.constrain(RegisterMe.class);
                        query.descend("core").constrain((Object)ClientRequestSchedulerCore.this).and(query.descend("priority").constrain((Object)i));
                        results = query.execute();
                        if (results.hasNext()) break;
                        results = null;
                    }
                    if (results == null) {
                        return false;
                    }
                    ClientRequestSchedulerCore i = ClientRequestSchedulerCore.this;
                    synchronized (i) {
                        ClientRequestSchedulerCore.this.registerMeSet = results;
                    }
                    long tEnd = System.currentTimeMillis();
                    if (logMINOR) {
                        Logger.minor(this, "RegisterMe query took " + (tEnd - tStart) + " hasNext=" + ClientRequestSchedulerCore.this.registerMeSet.hasNext() + " for insert=" + ClientRequestSchedulerCore.this.isInsertScheduler + " ssk=" + ClientRequestSchedulerCore.this.isSSKScheduler);
                    }
                    boolean boost = ClientRequestSchedulerCore.this.sched.isQueueAlmostEmpty();
                    try {
                        context.jobRunner.queue(ClientRequestSchedulerCore.this.registerMeRunner, 4 + (boost ? 1 : 0), true);
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return false;
                }
            };
            this.registerMeRunner = new RegisterMeRunner();
        }
    }

    void start(DBJobRunner runner) {
        this.startRegisterMeRunner(runner);
    }

    private final void startRegisterMeRunner(DBJobRunner runner) {
        if (this.isInsertScheduler) {
            try {
                runner.queue(this.preRegisterMeRunner, 5, true);
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
        }
    }

    private int removeFirstAccordingToPriorities(boolean tryOfferedKeys, int fuzz, RandomSource random, OfferedKeysList[] offeredKeys, ClientRequestSchedulerNonPersistent schedTransient, boolean transientOnly, short maxPrio, ObjectContainer container) {
        SortedVectorByNumber result = null;
        int iteration = 0;
        while (true) {
            int n = iteration;
            iteration = (short)(iteration + 1);
            if (n >= 8) break;
            short priority = fuzz < 0 ? tweakedPrioritySelector[random.nextInt(tweakedPrioritySelector.length)] : prioritySelector[Math.abs(fuzz % prioritySelector.length)];
            result = transientOnly ? null : this.priorities[priority];
            if (result == null) {
                result = schedTransient.priorities[priority];
            }
            if (priority > maxPrio) {
                ++fuzz;
                continue;
            }
            if (result != null && !result.isEmpty() || tryOfferedKeys && !offeredKeys[priority].isEmpty(container)) {
                if (logMINOR) {
                    Logger.minor(this, "using priority : " + priority);
                }
                return priority;
            }
            if (logMINOR) {
                Logger.minor(this, "Priority " + priority + " is null (fuzz = " + fuzz + ')');
            }
            ++fuzz;
        }
        return -1;
    }

    ChosenBlock removeFirstTransient(int fuzz, RandomSource random, OfferedKeysList[] offeredKeys, RequestStarter starter, ClientRequestSchedulerNonPersistent schedTransient, short maxPrio, int retryCount, ClientContext context, ObjectContainer container) {
        SendableRequest req = this.removeFirstInner(fuzz, random, offeredKeys, starter, schedTransient, true, false, maxPrio, retryCount, context, container);
        if (this.isInsertScheduler && req instanceof SendableGet) {
            IllegalStateException e = new IllegalStateException("removeFirstInner returned a SendableGet on an insert scheduler!!");
            req.internalError(e, this.sched, container, context, req.persistent());
            throw e;
        }
        return this.maybeMakeChosenRequest(req, container, context);
    }

    public ChosenBlock maybeMakeChosenRequest(SendableRequest req, ObjectContainer container, ClientContext context) {
        boolean ignoreStore;
        boolean cacheLocalRequests;
        boolean localRequestOnly;
        ClientKey ckey;
        Key key;
        if (req == null) {
            return null;
        }
        if (req.isEmpty(container) || req.isCancelled(container)) {
            return null;
        }
        SendableRequestItem token = req.chooseKey(this, (ObjectContainer)(req.persistent() ? container : null), context);
        if (token == null) {
            return null;
        }
        if (this.isInsertScheduler) {
            key = null;
            ckey = null;
        } else {
            key = ((BaseSendableGet)req).getNodeKey(token, (ObjectContainer)(this.persistent() ? container : null));
            ckey = req instanceof SendableGet ? ((SendableGet)req).getKey(token, (ObjectContainer)(this.persistent() ? container : null)) : null;
        }
        assert (!req.persistent());
        if (key != null && key.getRoutingKey() == null) {
            throw new NullPointerException();
        }
        if (req instanceof SendableGet) {
            SendableGet sg = (SendableGet)req;
            FetchContext ctx = sg.getContext();
            localRequestOnly = ctx.localRequestOnly;
            cacheLocalRequests = ctx.cacheLocalRequests;
            ignoreStore = ctx.ignoreStore;
        } else {
            localRequestOnly = false;
            cacheLocalRequests = req instanceof SendableInsert ? ((SendableInsert)req).cacheInserts(null) : false;
            ignoreStore = false;
        }
        TransientChosenBlock ret = new TransientChosenBlock(req, token, key, ckey, localRequestOnly, cacheLocalRequests, ignoreStore, this.sched);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SendableRequest removeFirstInner(int fuzz, RandomSource random, OfferedKeysList[] offeredKeys, RequestStarter starter, ClientRequestSchedulerNonPersistent schedTransient, boolean transientOnly, boolean notTransient, short maxPrio, int retryCount, ClientContext context, ObjectContainer container) {
        boolean tryOfferedKeys;
        int choosenPriorityClass;
        if (logMINOR) {
            Logger.minor(this, "removeFirst()");
        }
        if ((choosenPriorityClass = this.removeFirstAccordingToPriorities(tryOfferedKeys = offeredKeys != null && !notTransient && random.nextBoolean(), fuzz, random, offeredKeys, schedTransient, transientOnly, maxPrio, container)) == -1 && offeredKeys != null && !tryOfferedKeys && !notTransient) {
            tryOfferedKeys = true;
            choosenPriorityClass = this.removeFirstAccordingToPriorities(tryOfferedKeys, fuzz, random, offeredKeys, schedTransient, transientOnly, maxPrio, container);
        }
        if (choosenPriorityClass == -1) {
            if (logMINOR) {
                Logger.minor(this, "Nothing to do");
            }
            return null;
        }
        if (maxPrio >= 6) {
            maxPrio = (short)6;
        }
        while (choosenPriorityClass <= maxPrio) {
            block71: {
                if (logMINOR) {
                    Logger.minor(this, "Using priority " + choosenPriorityClass);
                }
                if (tryOfferedKeys && offeredKeys[choosenPriorityClass].hasValidKeys(this, null, context)) {
                    return offeredKeys[choosenPriorityClass];
                }
                SortedVectorByNumber perm = null;
                if (!transientOnly) {
                    perm = this.priorities[choosenPriorityClass];
                }
                SortedVectorByNumber trans = null;
                if (!notTransient) {
                    trans = schedTransient.priorities[choosenPriorityClass];
                }
                if (perm == null && trans == null) {
                    if (logMINOR) {
                        Logger.minor(this, "No requests to run: chosen priority empty");
                    }
                } else {
                    short prio;
                    Object req;
                    SectoredRandomGrabArrayWithInt chosenTracker;
                    int permRetryIndex = 0;
                    int transRetryIndex = 0;
                    while (true) {
                        int transRetryCount;
                        int permRetryCount = perm == null ? Integer.MAX_VALUE : perm.getNumberByIndex(permRetryIndex);
                        int n = transRetryCount = trans == null ? Integer.MAX_VALUE : trans.getNumberByIndex(transRetryIndex);
                        if (choosenPriorityClass == maxPrio) {
                            if (permRetryCount >= retryCount) {
                                permRetryCount = Integer.MAX_VALUE;
                            }
                            if (transRetryCount >= retryCount) {
                                transRetryCount = Integer.MAX_VALUE;
                            }
                        }
                        if (permRetryCount == Integer.MAX_VALUE && transRetryCount == Integer.MAX_VALUE) {
                            if (logMINOR) {
                                Logger.minor(this, "No requests to run: ran out of retrycounts on chosen priority");
                            }
                            break block71;
                        }
                        chosenTracker = null;
                        SortedVectorByNumber trackerParent = null;
                        if (permRetryCount == transRetryCount) {
                            int transTrackerSize;
                            SectoredRandomGrabArrayWithInt permRetryTracker = (SectoredRandomGrabArrayWithInt)perm.getByIndex(permRetryIndex);
                            if (this.persistent() && permRetryTracker != null) {
                                container.activate((Object)permRetryTracker, 1);
                            }
                            SectoredRandomGrabArrayWithInt transRetryTracker = (SectoredRandomGrabArrayWithInt)trans.getByIndex(transRetryIndex);
                            int permTrackerSize = permRetryTracker.size();
                            if (permTrackerSize + (transTrackerSize = transRetryTracker.size()) == 0) {
                                ++permRetryIndex;
                                ++transRetryIndex;
                                continue;
                            }
                            if (random.nextInt(permTrackerSize + transTrackerSize) > permTrackerSize) {
                                chosenTracker = permRetryTracker;
                                trackerParent = perm;
                                ++permRetryIndex;
                            } else {
                                chosenTracker = transRetryTracker;
                                trackerParent = trans;
                                ++transRetryIndex;
                            }
                        } else if (permRetryCount < transRetryCount) {
                            chosenTracker = (SectoredRandomGrabArrayWithInt)perm.getByIndex(permRetryIndex);
                            if (this.persistent() && chosenTracker != null) {
                                container.activate((Object)chosenTracker, 1);
                            }
                            trackerParent = perm;
                            ++permRetryIndex;
                        } else {
                            chosenTracker = (SectoredRandomGrabArrayWithInt)trans.getByIndex(transRetryIndex);
                            trackerParent = trans;
                            ++transRetryIndex;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Got retry count tracker " + chosenTracker);
                        }
                        req = (SendableRequest)chosenTracker.removeRandom(starter, container, context);
                        if (chosenTracker.isEmpty()) {
                            trackerParent.remove(chosenTracker.getNumber(), container);
                            if (chosenTracker.persistent()) {
                                chosenTracker.removeFrom(container);
                            }
                            if (trackerParent.isEmpty() && logMINOR) {
                                Logger.minor(this, "Should remove priority");
                            }
                        }
                        if (req == null) {
                            if (!logMINOR) continue;
                            Logger.minor(this, "No requests, adjusted retrycount " + chosenTracker.getNumber() + " (" + chosenTracker + ") of priority " + choosenPriorityClass);
                            continue;
                        }
                        if (chosenTracker.persistent()) {
                            container.activate(req, 1);
                        }
                        if (((SendableRequest)req).persistent() != trackerParent.persistent()) {
                            Logger.error(this, "Request.persistent()=" + ((SendableRequest)req).persistent() + " but is in the queue for persistent=" + trackerParent.persistent() + " for " + req);
                        }
                        if (((SendableRequest)req).getPriorityClass(container) == choosenPriorityClass) break;
                        Logger.normal(this, "In wrong priority class: " + req + " (req.prio=" + ((SendableRequest)req).getPriorityClass(container) + " but chosen=" + choosenPriorityClass + ')');
                        SectoredRandomGrabArrayWithObject clientGrabber = (SectoredRandomGrabArrayWithObject)chosenTracker.getGrabber(((SendableRequest)req).getClient(container));
                        if (clientGrabber != null) {
                            RandomGrabArray baseRGA;
                            if (chosenTracker.persistent()) {
                                container.activate((Object)clientGrabber, 1);
                            }
                            if ((baseRGA = (RandomGrabArray)((Object)clientGrabber.getGrabber(((SendableRequest)req).getClientRequest()))) != null) {
                                baseRGA.remove((RandomGrabArrayItem)req, container);
                            }
                        } else {
                            Logger.error(this, "Could not find client grabber for client " + ((SendableRequest)req).getClient(container) + " from " + chosenTracker);
                        }
                        if (((SendableRequest)req).persistent()) {
                            this.innerRegister((SendableRequest)req, random, container, null);
                            continue;
                        }
                        schedTransient.innerRegister((SendableRequest)req, random, container, null);
                    }
                    if (!((SendableRequest)req).persistent() && !this.isInsertScheduler) {
                        List<BaseSendableGet> recent = schedTransient.recentSuccesses;
                        SendableRequest altReq = null;
                        if (!recent.isEmpty() && random.nextBoolean()) {
                            altReq = recent.remove(recent.size() - 1);
                        }
                        if (altReq != null && (altReq.isCancelled(container) || altReq.isEmpty(container))) {
                            if (logMINOR) {
                                Logger.minor(this, "Ignoring cancelled recently succeeded item " + altReq);
                            }
                            altReq = null;
                        }
                        if (altReq != null && altReq != req) {
                            prio = altReq.getPriorityClass(container);
                            if (prio < choosenPriorityClass || prio == choosenPriorityClass && this.fixRetryCount(altReq.getRetryCount()) <= chosenTracker.getNumber()) {
                                if (logMINOR) {
                                    Logger.minor(this, "Recently succeeded (transient) req " + altReq + " (prio=" + altReq.getPriorityClass(container) + " retry count " + altReq.getRetryCount() + ") is better than " + req + " (prio=" + ((SendableRequest)req).getPriorityClass(container) + " retry " + ((SendableRequest)req).getRetryCount() + "), using that");
                                }
                                req = altReq;
                            } else {
                                if (logMINOR) {
                                    Logger.minor(this, "Chosen req " + req + " is better, reregistering recently succeeded " + altReq);
                                }
                                recent.add((BaseSendableGet)altReq);
                            }
                        }
                    } else if (!this.isInsertScheduler) {
                        RandomGrabArray altRGA = null;
                        Object altReq = this.recentSuccesses;
                        synchronized (altReq) {
                            if (!this.recentSuccesses.isEmpty() && !random.nextBoolean()) {
                                altRGA = this.recentSuccesses.remove(this.recentSuccesses.size() - 1);
                            }
                        }
                        if (altRGA != null) {
                            container.activate(altRGA, 1);
                            if (container.ext().isStored((Object)altRGA) && !altRGA.isEmpty()) {
                                if (logMINOR) {
                                    Logger.minor(this, "Maybe using recently succeeded item from " + altRGA);
                                }
                                if ((altReq = (SendableRequest)altRGA.removeRandom(starter, container, context)) != null) {
                                    container.activate(altReq, 1);
                                    prio = ((SendableRequest)altReq).getPriorityClass(container);
                                    if ((prio < choosenPriorityClass || prio == choosenPriorityClass && this.fixRetryCount(((SendableRequest)altReq).getRetryCount()) <= chosenTracker.getNumber()) && !altReq.isEmpty(container) && altReq != req) {
                                        if (logMINOR) {
                                            Logger.minor(this, "Recently succeeded (persistent) req " + altReq + " (prio=" + ((SendableRequest)altReq).getPriorityClass(container) + " retry count " + ((SendableRequest)altReq).getRetryCount() + ") is better than " + req + " (prio=" + ((SendableRequest)req).getPriorityClass(container) + " retry " + ((SendableRequest)req).getRetryCount() + "), using that");
                                        }
                                        req = altReq;
                                    } else if (altReq != null) {
                                        if (logMINOR) {
                                            Logger.minor(this, "Chosen (persistent) req " + req + " is better, reregistering recently succeeded " + altRGA + " for " + altReq);
                                        }
                                        List<RandomGrabArray> list = this.recentSuccesses;
                                        synchronized (list) {
                                            this.recentSuccesses.add(altRGA);
                                        }
                                    }
                                }
                            } else {
                                container.deactivate((Object)altRGA, 1);
                            }
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "removeFirst() returning " + req + " (" + chosenTracker.getNumber() + ", prio " + ((SendableRequest)req).getPriorityClass(container) + ", retries " + ((SendableRequest)req).getRetryCount() + ", client " + ((SendableRequest)req).getClient(container) + ", client-req " + ((SendableRequest)req).getClientRequest() + ')');
                    }
                    if (logMINOR) {
                        Logger.minor(this, "removeFirst() returning " + req + " of " + ((SendableRequest)req).getClientRequest());
                    }
                    return req;
                }
            }
            ++choosenPriorityClass;
        }
        if (logMINOR) {
            Logger.minor(this, "No requests to run");
        }
        return null;
    }

    boolean persistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToFetching(Key key) {
        HashSet<Key> hashSet = this.keysFetching;
        synchronized (hashSet) {
            boolean retval = this.keysFetching.add(key);
            if (!retval) {
                Logger.normal(this, "Already in keysFetching: " + key);
            } else if (logMINOR) {
                Logger.minor(this, "Added to keysFetching: " + key);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKey(Key key) {
        if (this.keysFetching == null) {
            throw new NullPointerException();
        }
        HashSet<Key> hashSet = this.keysFetching;
        synchronized (hashSet) {
            return this.keysFetching.contains(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFetchingKey(Key key) {
        if (logMINOR) {
            Logger.minor(this, "Removing from keysFetching: " + key);
        }
        if (key != null) {
            HashSet<Key> hashSet = this.keysFetching;
            synchronized (hashSet) {
                this.keysFetching.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rerunRegisterMeRunner(DBJobRunner runner) {
        ClientRequestSchedulerCore clientRequestSchedulerCore = this;
        synchronized (clientRequestSchedulerCore) {
            if (this.registerMeSet != null) {
                return;
            }
        }
        this.startRegisterMeRunner(runner);
    }

    public synchronized long countQueuedRequests(ObjectContainer container, ClientContext context) {
        long ret = super.countQueuedRequests(container, context);
        long cooldown = this.persistentCooldownQueue.size(container);
        System.out.println("Cooldown queue size: " + cooldown);
        return ret + cooldown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTransientInsert(SendableInsert insert, Object token) {
        RunningTransientInsert tmp = new RunningTransientInsert(insert, token);
        HashSet<RunningTransientInsert> hashSet = this.runningTransientInserts;
        synchronized (hashSet) {
            return this.runningTransientInserts.contains(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTransientInsertFetching(SendableInsert insert, Object token) {
        RunningTransientInsert tmp = new RunningTransientInsert(insert, token);
        HashSet<RunningTransientInsert> hashSet = this.runningTransientInserts;
        synchronized (hashSet) {
            boolean retval = this.runningTransientInserts.add(tmp);
            if (!retval) {
                Logger.normal(this, "Already in runningTransientInserts: " + insert + " : " + token);
            } else if (logMINOR) {
                Logger.minor(this, "Added to runningTransientInserts: " + insert + " : " + token);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientInsertFetching(SendableInsert insert, Object token) {
        RunningTransientInsert tmp = new RunningTransientInsert(insert, token);
        if (logMINOR) {
            Logger.minor(this, "Removing from runningTransientInserts: " + insert + " : " + token);
        }
        HashSet<RunningTransientInsert> hashSet = this.runningTransientInserts;
        synchronized (hashSet) {
            this.runningTransientInserts.remove(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void succeeded(BaseSendableGet succeeded, ObjectContainer container) {
        RandomGrabArray array = succeeded.getParentGrabArray();
        container.activate((Object)array, 1);
        if (array == null) {
            return;
        }
        List<RandomGrabArray> list = this.recentSuccesses;
        synchronized (list) {
            if (this.recentSuccesses.contains(array)) {
                return;
            }
            this.recentSuccesses.add(array);
            while (this.recentSuccesses.size() > 8) {
                this.recentSuccesses.remove(0);
            }
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
        tweakedPrioritySelector = new short[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 6};
        prioritySelector = new short[]{0, 1, 2, 3, 4, 5, 6};
    }

    class RegisterMeRunner
    implements DBJob {
        RegisterMeRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean run(ObjectContainer container, ClientContext context) {
            if (ClientRequestSchedulerCore.this.sched.databaseExecutor.getQueueSize(5) > 100 && !ClientRequestSchedulerCore.this.sched.isQueueAlmostEmpty()) {
                try {
                    context.jobRunner.queue(ClientRequestSchedulerCore.this.registerMeRunner, 4, false);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
                return false;
            }
            long deadline = System.currentTimeMillis() + 10000L;
            if (ClientRequestSchedulerCore.this.registerMeSet == null) {
                Logger.error(this, "registerMeSet is null for " + ClientRequestSchedulerCore.this + " ( " + this + " )");
                return false;
            }
            for (int i = 0; i < 1000; ++i) {
                try {
                    if (!ClientRequestSchedulerCore.this.registerMeSet.hasNext()) {
                        break;
                    }
                }
                catch (NullPointerException t) {
                    Logger.error(this, "DB4O thew NPE in hasNext(): " + t, t);
                    try {
                        context.jobRunner.queue(ClientRequestSchedulerCore.this.preRegisterMeRunner, 5, true);
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return true;
                }
                catch (ClassCastException t) {
                    Logger.error(this, "DB4O thew ClassCastException in hasNext(): " + t, t);
                    try {
                        context.jobRunner.queue(ClientRequestSchedulerCore.this.preRegisterMeRunner, 5, true);
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return true;
                }
                long startNext = System.currentTimeMillis();
                RegisterMe reg = (RegisterMe)ClientRequestSchedulerCore.this.registerMeSet.next();
                container.activate((Object)reg, 1);
                if (reg.bootID == context.bootID) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not registering block " + reg + " as was added to the queue");
                    continue;
                }
                if (reg.core != ClientRequestSchedulerCore.this) {
                    if (!container.ext().isStored((Object)reg)) {
                        if (!logMINOR) continue;
                        Logger.minor(this, "Already deleted RegisterMe " + reg + " - skipping");
                        continue;
                    }
                    if (reg.core == null) {
                        Logger.error(this, "Leftover RegisterMe " + reg + " : core already deleted. THIS IS AN ERROR unless you have seen \"Old core not active\" messages before this point.");
                        container.delete((Object)reg);
                        continue;
                    }
                    if (!container.ext().isActive((Object)reg.core)) {
                        Logger.error(this, "Old core not active in RegisterMe " + reg + " - duplicated cores????");
                        container.delete((Object)reg.core);
                        container.delete((Object)reg);
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring RegisterMe " + reg + " as doesn't belong to me: my insert=" + ClientRequestSchedulerCore.this.isInsertScheduler + " my ssk=" + ClientRequestSchedulerCore.this.isSSKScheduler + " his insert=" + reg.core.isInsertScheduler + " his ssk=" + reg.core.isSSKScheduler);
                    }
                    container.deactivate((Object)reg, 1);
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Running RegisterMe " + reg + " for " + reg.nonGetRequest + " : " + reg.addedTime + " : " + reg.priority);
                }
                if (reg.nonGetRequest != null) {
                    container.activate((Object)reg.nonGetRequest, 1);
                    if (reg.nonGetRequest.isCancelled(container)) {
                        Logger.normal(this, "RegisterMe: request cancelled: " + reg.nonGetRequest);
                    } else {
                        if (logMINOR) {
                            Logger.minor(this, "Registering RegisterMe for insert: " + reg.nonGetRequest);
                        }
                        ClientRequestSchedulerCore.this.sched.registerInsert(reg.nonGetRequest, true, false, container);
                    }
                    container.delete((Object)reg);
                    container.deactivate((Object)reg.nonGetRequest, 1);
                }
                container.deactivate((Object)reg, 1);
                if (System.currentTimeMillis() > deadline) break;
            }
            boolean boost = ClientRequestSchedulerCore.this.sched.isQueueAlmostEmpty();
            if (ClientRequestSchedulerCore.this.registerMeSet.hasNext()) {
                try {
                    context.jobRunner.queue(ClientRequestSchedulerCore.this.registerMeRunner, 4 + (boost ? 1 : 0), true);
                }
                catch (DatabaseDisabledException e) {}
            } else {
                if (logMINOR) {
                    Logger.minor(this, "RegisterMeRunner finished");
                }
                ClientRequestSchedulerCore clientRequestSchedulerCore = ClientRequestSchedulerCore.this;
                synchronized (clientRequestSchedulerCore) {
                    ClientRequestSchedulerCore.this.registerMeSet = null;
                }
                ClientRequestSchedulerCore.this.preRegisterMeRunner.run(container, context);
            }
            return true;
        }
    }

    private static class RunningTransientInsert {
        final SendableInsert insert;
        final Object token;

        RunningTransientInsert(SendableInsert i, Object t) {
            this.insert = i;
            this.token = t;
        }

        public int hashCode() {
            return this.insert.hashCode() ^ this.token.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RunningTransientInsert)) {
                return false;
            }
            RunningTransientInsert r = (RunningTransientInsert)o;
            return r.insert == this.insert && (r.token == this.token || r.token.equals(this.token));
        }
    }
}

