/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.crypt.RandomSource;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.BaseSendableGet;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.SectoredRandomGrabArrayWithInt;
import freenet.support.SectoredRandomGrabArrayWithObject;
import freenet.support.SortedVectorByNumber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

abstract class ClientRequestSchedulerBase {
    private static volatile boolean logMINOR;
    private static final int MIN_RETRY_COUNT = 3;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    protected final SortedVectorByNumber[] priorities;
    protected transient ClientRequestScheduler sched;
    protected transient Set<KeyListener> keyListeners;
    private long persistentTruePositives;
    private long persistentFalsePositives;
    private long persistentNegatives;

    abstract boolean persistent();

    protected ClientRequestSchedulerBase(boolean forInserts, boolean forSSKs) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.keyListeners = new HashSet<KeyListener>();
        this.priorities = new SortedVectorByNumber[7];
    }

    void innerRegister(SendableRequest req, RandomSource random, ObjectContainer container, SendableRequest[] maybeActive) {
        if (this.isInsertScheduler && req instanceof BaseSendableGet) {
            throw new IllegalArgumentException("Adding a SendableGet to an insert scheduler!!");
        }
        if (!this.isInsertScheduler && req instanceof SendableInsert) {
            throw new IllegalArgumentException("Adding a SendableInsert to a request scheduler!!");
        }
        if (this.isInsertScheduler != req.isInsert()) {
            throw new IllegalArgumentException("Request isInsert=" + req.isInsert() + " but my isInsertScheduler=" + this.isInsertScheduler + "!!");
        }
        if (req.persistent() != this.persistent()) {
            throw new IllegalArgumentException("innerRegister for persistence=" + req.persistent() + " but our persistence is " + this.persistent());
        }
        if (req.getPriorityClass(container) == 0) {
            Logger.normal(this, "Something wierd...");
            Logger.normal(this, "Priority " + req.getPriorityClass(container));
        }
        int retryCount = req.getRetryCount();
        short prio = req.getPriorityClass(container);
        if (logMINOR) {
            Logger.minor(this, "Still registering " + req + " at prio " + prio + " retry " + retryCount + " for " + req.getClientRequest());
        }
        this.addToRequestsByClientRequest(req.getClientRequest(), req, container);
        this.addToGrabArray(prio, retryCount, this.fixRetryCount(retryCount), req.getClient(container), req.getClientRequest(), req, random, container);
        if (logMINOR) {
            Logger.minor(this, "Registered " + req + " on prioclass=" + prio + ", retrycount=" + retryCount);
        }
        if (this.persistent()) {
            this.sched.maybeAddToStarterQueue(req, container, maybeActive);
        }
    }

    protected void addToRequestsByClientRequest(ClientRequester clientRequest, SendableRequest req, ObjectContainer container) {
        if (clientRequest != null || this.persistent()) {
            boolean deactivate = false;
            if (this.persistent()) {
                boolean bl = deactivate = !container.ext().isActive((Object)clientRequest);
                if (deactivate) {
                    container.activate((Object)clientRequest, 1);
                }
            }
            clientRequest.addToRequests(req, container);
            if (deactivate) {
                container.deactivate((Object)clientRequest, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addToGrabArray(short priorityClass, int retryCount, int rc, RequestClient client, ClientRequester cr, SendableRequest req, RandomSource random, ObjectContainer container) {
        if (priorityClass > 6 || priorityClass < 0) {
            throw new IllegalStateException("Invalid priority: " + priorityClass + " - range is " + 0 + " (most important) to " + 6 + " (least important)");
        }
        SortedVectorByNumber prio = this.priorities[priorityClass];
        if (prio == null) {
            this.priorities[priorityClass] = prio = new SortedVectorByNumber(this.persistent());
            if (this.persistent()) {
                container.store((Object)this);
            }
        }
        SectoredRandomGrabArrayWithInt clientGrabber = (SectoredRandomGrabArrayWithInt)prio.get(rc, container);
        if (this.persistent()) {
            container.activate((Object)clientGrabber, 1);
        }
        if (clientGrabber == null) {
            clientGrabber = new SectoredRandomGrabArrayWithInt(rc, this.persistent(), container, null);
            prio.add(clientGrabber, container);
            if (logMINOR) {
                Logger.minor(this, "Registering retry count " + rc + " with prioclass " + priorityClass + " on " + clientGrabber + " for " + prio);
            }
        }
        SectoredRandomGrabArrayWithInt sectoredRandomGrabArrayWithInt = clientGrabber;
        synchronized (sectoredRandomGrabArrayWithInt) {
            SectoredRandomGrabArrayWithObject requestGrabber = (SectoredRandomGrabArrayWithObject)clientGrabber.getGrabber(client);
            if (this.persistent()) {
                container.activate((Object)requestGrabber, 1);
            }
            if (requestGrabber == null) {
                requestGrabber = new SectoredRandomGrabArrayWithObject(client, this.persistent(), container, clientGrabber);
                if (logMINOR) {
                    Logger.minor(this, "Creating new grabber: " + requestGrabber + " for " + client + " from " + clientGrabber + " : " + prio + " : prio=" + priorityClass + ", rc=" + rc);
                }
                clientGrabber.addGrabber(client, requestGrabber, container);
            }
            requestGrabber.add(cr, req, container);
        }
    }

    protected int fixRetryCount(int retryCount) {
        return Math.max(0, retryCount - 3);
    }

    protected SendableRequest[] getSendableRequests(ClientRequester request, ObjectContainer container) {
        if (request != null || this.persistent()) {
            return request.getSendableRequests(container);
        }
        return null;
    }

    void removeFromAllRequestsByClientRequest(SendableRequest req, ClientRequester cr, boolean dontComplain, ObjectContainer container) {
        if (cr != null || this.persistent()) {
            cr.removeFromRequests(req, container, dontComplain);
        }
    }

    public void reregisterAll(ClientRequester request, RandomSource random, RequestScheduler lock, ObjectContainer container, ClientContext context) {
        if (request.persistent() != this.persistent()) {
            return;
        }
        SendableRequest[] reqs = this.getSendableRequests(request, container);
        if (reqs == null) {
            return;
        }
        for (int i = 0; i < reqs.length; ++i) {
            SendableRequest req = reqs[i];
            if (this.persistent()) {
                container.activate((Object)req, 1);
            }
            if (req.isInsert() != this.isInsertScheduler || req.isSSK() != this.isSSKScheduler) {
                if (!this.persistent()) continue;
                container.deactivate((Object)req, 1);
                continue;
            }
            req.unregister(container, context);
            this.innerRegister(req, random, container, null);
            if (!this.persistent()) continue;
            container.deactivate((Object)req, 1);
        }
    }

    public void succeeded(BaseSendableGet succeeded, ObjectContainer container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingKeys(KeyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            this.keyListeners.add(listener);
        }
        if (logMINOR) {
            Logger.minor(this, "Added pending keys to " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePendingKeys(KeyListener listener) {
        boolean ret;
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            ret = this.keyListeners.remove(listener);
            listener.onRemove();
        }
        if (logMINOR) {
            Logger.minor(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
        return ret;
    }

    public synchronized boolean removePendingKeys(HasKeyListener hasListener) {
        boolean found = false;
        Iterator<KeyListener> i = this.keyListeners.iterator();
        while (i.hasNext()) {
            KeyListener listener = i.next();
            if (listener == null) {
                i.remove();
                Logger.error(this, "Null KeyListener in removePendingKeys()");
                continue;
            }
            if (listener.getHasKeyListener() != hasListener) continue;
            found = true;
            i.remove();
            listener.onRemove();
            Logger.normal(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getKeyPrio(Key key, short priority, ObjectContainer container, ClientContext context) {
        byte[] saltedKey = (key instanceof NodeSSK ? context.getSskFetchScheduler() : context.getChkFetchScheduler()).saltKey(key);
        ArrayList<KeyListener> matches = null;
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                matches.add(listener);
            }
        }
        if (matches == null) {
            return priority;
        }
        for (KeyListener listener : matches) {
            short prio = listener.definitelyWantKey(key, saltedKey, container, this.sched.clientContext);
            if (prio == -1 || prio >= priority) continue;
            priority = prio;
        }
        return priority;
    }

    public synchronized long countWaitingKeys(ObjectContainer container) {
        long count = 0L;
        for (KeyListener listener : this.keyListeners) {
            count += listener.countKeys();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyWantKey(Key key, ObjectContainer container, ClientContext context) {
        byte[] saltedKey = (key instanceof NodeSSK ? context.getSskFetchScheduler() : context.getChkFetchScheduler()).saltKey(key);
        ArrayList<KeyListener> matches = null;
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                matches.add(listener);
            }
        }
        if (matches != null) {
            for (KeyListener listener : matches) {
                if (listener.definitelyWantKey(key, saltedKey, container, this.sched.clientContext) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean anyProbablyWantKey(Key key, ClientContext context) {
        byte[] saltedKey = (key instanceof NodeSSK ? context.getSskFetchScheduler() : context.getChkFetchScheduler()).saltKey(key);
        for (KeyListener listener : this.keyListeners) {
            if (!listener.probablyWantKey(key, saltedKey)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tripPendingKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        ClientRequestSchedulerBase clientRequestSchedulerBase;
        if (key instanceof NodeSSK != this.isSSKScheduler) {
            Logger.error(this, "Key " + key + " on scheduler ssk=" + this.isSSKScheduler, new Exception("debug"));
            return false;
        }
        byte[] saltedKey = this.sched.saltKey(key);
        ArrayList<KeyListener> matches = null;
        ClientRequestSchedulerBase clientRequestSchedulerBase2 = this;
        synchronized (clientRequestSchedulerBase2) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                if (matches.contains(listener)) {
                    Logger.error(this, "In matches twice, presumably in keyListeners twice?: " + listener);
                    continue;
                }
                matches.add(listener);
            }
        }
        boolean ret = false;
        if (matches != null) {
            for (KeyListener listener : matches) {
                if (listener.handleBlock(key, saltedKey, block, container, context)) {
                    ret = true;
                }
                if (!listener.isEmpty()) continue;
                ClientRequestSchedulerBase clientRequestSchedulerBase3 = this;
                synchronized (clientRequestSchedulerBase3) {
                    this.keyListeners.remove(listener);
                }
                listener.onRemove();
            }
        } else {
            return false;
        }
        if (ret) {
            clientRequestSchedulerBase = this;
            synchronized (clientRequestSchedulerBase) {
                ++this.persistentTruePositives;
                this.logFalsePositives("hit");
            }
        }
        clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            ++this.persistentFalsePositives;
            this.logFalsePositives("false");
        }
        return ret;
    }

    synchronized void countNegative() {
        ++this.persistentNegatives;
        if (this.persistentNegatives % 32L == 0L) {
            this.logFalsePositives("neg");
        }
    }

    private synchronized void logFalsePositives(String phase) {
        long totalPositives = this.persistentFalsePositives + this.persistentTruePositives;
        double percent = totalPositives > 0L ? 100.0 * (double)this.persistentFalsePositives / (double)totalPositives : 0.0;
        if (!(percent > 2.0) && !logMINOR) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (this.persistent()) {
            buf.append("Persistent ");
        } else {
            buf.append("Transient ");
        }
        buf.append("false positives ");
        buf.append(phase);
        buf.append(": ");
        if (totalPositives != 0L) {
            buf.append(percent);
            buf.append("% ");
        }
        buf.append("(false=");
        buf.append(this.persistentFalsePositives);
        buf.append(" true=");
        buf.append(this.persistentTruePositives);
        buf.append(" negatives=");
        buf.append(this.persistentNegatives);
        buf.append(')');
        if (percent > 10.0) {
            Logger.error(this, buf.toString());
        } else if (percent > 2.0) {
            Logger.normal(this, buf.toString());
        } else {
            Logger.minor(this, buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendableGet[] requestsForKey(Key key, ObjectContainer container, ClientContext context) {
        ArrayList<SendableGet> list = null;
        byte[] saltedKey = this.sched.saltKey(key);
        ClientRequestSchedulerBase clientRequestSchedulerBase = this;
        synchronized (clientRequestSchedulerBase) {
            for (KeyListener listener : this.keyListeners) {
                SendableGet[] reqs;
                if (!listener.probablyWantKey(key, saltedKey) || (reqs = listener.getRequestsForKey(key, saltedKey, container, context)) == null) continue;
                if (list == null) {
                    list = new ArrayList<SendableGet>();
                }
                for (int i = 0; i < reqs.length; ++i) {
                    list.add(reqs[i]);
                }
            }
        }
        if (list == null) {
            return null;
        }
        return list.toArray(new SendableGet[list.size()]);
    }

    public void onStarted() {
        this.keyListeners = new HashSet<KeyListener>();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(':');
        if (this.isInsertScheduler) {
            sb.append("insert:");
        }
        if (this.isSSKScheduler) {
            sb.append("SSK");
        } else {
            sb.append("CHK");
        }
        return sb.toString();
    }

    public synchronized long countQueuedRequests(ObjectContainer container, ClientContext context) {
        long total = 0L;
        for (int i = 0; i < this.priorities.length; ++i) {
            SortedVectorByNumber prio = this.priorities[i];
            if (prio == null || prio.isEmpty()) {
                System.out.println("Priority " + i + " : empty");
                continue;
            }
            System.out.println("Priority " + i + " : " + prio.count());
            for (int j = 0; j < prio.count(); ++j) {
                int frc = prio.getNumberByIndex(j);
                System.out.println("Fixed retry count: " + frc);
                SectoredRandomGrabArrayWithInt clientGrabber = (SectoredRandomGrabArrayWithInt)prio.get(frc, container);
                container.activate((Object)clientGrabber, 1);
                System.out.println("Clients: " + clientGrabber.size() + " for " + clientGrabber);
                for (int k = 0; k < clientGrabber.size(); ++k) {
                    Object client = clientGrabber.getClient(k);
                    container.activate(client, 1);
                    System.out.println("Client " + k + " : " + client);
                    container.deactivate(client, 1);
                    SectoredRandomGrabArrayWithObject requestGrabber = (SectoredRandomGrabArrayWithObject)clientGrabber.getGrabber(client);
                    container.activate((Object)requestGrabber, 1);
                    System.out.println("SRGA for client: " + requestGrabber);
                    for (int l = 0; l < requestGrabber.size(); ++l) {
                        client = requestGrabber.getClient(l);
                        container.activate(client, 1);
                        System.out.println("Request " + l + " : " + client);
                        container.deactivate(client, 1);
                        RandomGrabArray rga = (RandomGrabArray)((Object)requestGrabber.getGrabber(client));
                        container.activate((Object)rga, 1);
                        System.out.println("Queued SendableRequests: " + rga.size() + " on " + rga);
                        long sendable = 0L;
                        long all = 0L;
                        for (int m = 0; m < rga.size(); ++m) {
                            SendableRequest req = (SendableRequest)rga.get(m, container);
                            if (req == null) continue;
                            container.activate((Object)req, 1);
                            sendable += req.countSendableKeys(container, context);
                            all += req.countAllKeys(container, context);
                            container.deactivate((Object)req, 1);
                        }
                        System.out.println("Sendable keys: " + sendable + " all keys " + all + " diff " + (all - sendable));
                        total += all;
                        container.deactivate((Object)rga, 1);
                    }
                    container.deactivate((Object)requestGrabber, 1);
                }
                container.deactivate((Object)clientGrabber, 1);
            }
        }
        return total;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

