/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import freenet.client.FECQueue;
import freenet.client.async.BlockSet;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestSchedulerCore;
import freenet.client.async.ClientRequestSchedulerNonPersistent;
import freenet.client.async.ClientRequester;
import freenet.client.async.CooldownQueue;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.DatastoreChecker;
import freenet.client.async.DatastoreCheckerItem;
import freenet.client.async.Db4oBugs;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.NoValidBlocksException;
import freenet.client.async.OfferedKeysList;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.RegisterMe;
import freenet.client.async.RequestCooldownQueue;
import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.RequestScheduler;
import freenet.node.RequestStarter;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.PrioritizedSerialExecutor;
import freenet.support.api.StringCallback;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.LinkedList;

public class ClientRequestScheduler
implements RequestScheduler {
    private final ClientRequestSchedulerCore schedCore;
    final ClientRequestSchedulerNonPersistent schedTransient;
    private static volatile boolean logMINOR;
    private final OfferedKeysList[] offeredKeys;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final RandomSource random;
    private final RequestStarter starter;
    private final Node node;
    public final String name;
    private final CooldownQueue transientCooldownQueue;
    private final CooldownQueue persistentCooldownQueue;
    final PrioritizedSerialExecutor databaseExecutor;
    final DatastoreChecker datastoreChecker;
    public final ClientContext clientContext;
    final DBJobRunner jobRunner;
    public static final String PRIORITY_NONE = "NONE";
    public static final String PRIORITY_SOFT = "SOFT";
    public static final String PRIORITY_HARD = "HARD";
    private String choosenPriorityScheduler;
    static final int QUEUE_THRESHOLD = 100;
    private final transient ArrayList<SendableRequest> runningPersistentRequests = new ArrayList();
    static final int MAX_STARTER_QUEUE_SIZE = 512;
    static final int WARNING_STARTER_QUEUE_SIZE = 800;
    private static final long WAIT_AFTER_NOTHING_TO_START = 60000L;
    private transient LinkedList<PersistentChosenRequest> starterQueue = new LinkedList();
    private long nextQueueFillRequestStarterQueue = -1L;
    private DBJob requestStarterQueueFiller = new DBJob(){

        public boolean run(ObjectContainer container, ClientContext context) {
            ClientRequestScheduler.this.fillRequestStarterQueue(container, context, null);
            return false;
        }

        public String toString() {
            return super.toString() + "(fillRequestStarterQueue)";
        }
    };
    static final short TRIP_PENDING_PRIORITY = 6;

    public ClientRequestScheduler(boolean forInserts, boolean forSSKs, RandomSource random, RequestStarter starter, Node node, NodeClientCore core, SubConfig sc, String name, ClientContext context) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.schedCore = ClientRequestSchedulerCore.create(node, forInserts, forSSKs, node.db, 1800000L, core.clientDatabaseExecutor, this, context);
        this.schedTransient = new ClientRequestSchedulerNonPersistent(this, forInserts, forSSKs);
        this.persistentCooldownQueue = this.schedCore.persistentCooldownQueue;
        this.databaseExecutor = core.clientDatabaseExecutor;
        this.datastoreChecker = core.storeChecker;
        this.starter = starter;
        this.random = random;
        this.node = node;
        this.clientContext = context;
        this.name = name;
        sc.register(name + "_priority_policy", PRIORITY_HARD, name.hashCode(), true, false, "RequestStarterGroup.scheduler" + (forSSKs ? "SSK" : "CHK") + (forInserts ? "Inserts" : "Requests"), "RequestStarterGroup.schedulerLong", new PrioritySchedulerCallback(this));
        this.choosenPriorityScheduler = sc.getString(name + "_priority_policy");
        if (!forInserts) {
            this.offeredKeys = new OfferedKeysList[7];
            for (short i = 0; i < 7; i = (short)(i + 1)) {
                this.offeredKeys[i] = new OfferedKeysList(core, random, i, forSSKs);
            }
        } else {
            this.offeredKeys = null;
        }
        this.transientCooldownQueue = !forInserts ? new RequestCooldownQueue(1800000L) : null;
        this.jobRunner = this.clientContext.jobRunner;
    }

    public static void loadKeyListeners(ObjectContainer container, ClientContext context) {
        ObjectSet<HasKeyListener> results = Db4oBugs.query(container, HasKeyListener.class);
        for (HasKeyListener l : results) {
            container.activate((Object)l, 1);
            try {
                if (l.isCancelled(container)) continue;
                KeyListener listener = l.makeKeyListener(container, context);
                if (listener != null) {
                    if (listener.isSSK()) {
                        context.getSskFetchScheduler().addPersistentPendingKeys(listener);
                    } else {
                        context.getChkFetchScheduler().addPersistentPendingKeys(listener);
                    }
                    System.err.println("Loaded request key listener: " + listener + " for " + l);
                }
            }
            catch (KeyListenerConstructionException e) {
                System.err.println("FAILED TO LOAD REQUEST BLOOM FILTERS:");
                e.printStackTrace();
                Logger.error(ClientRequestSchedulerCore.class, "FAILED TO LOAD REQUEST BLOOM FILTERS: " + e, e);
            }
            catch (Throwable t) {
                Logger.error(ClientRequestSchedulerCore.class, "FAILED TO LOAD REQUEST: " + t, t);
                System.err.println("FAILED TO LOAD REQUEST: " + t);
                t.printStackTrace();
            }
            container.deactivate((Object)l, 1);
        }
    }

    public void start(NodeClientCore core) {
        this.schedCore.start(core);
        this.queueFillRequestStarterQueue();
    }

    protected synchronized void setPriorityScheduler(String val) {
        this.choosenPriorityScheduler = val;
    }

    public void registerInsert(final SendableRequest req, boolean persistent, boolean regmeOnly, ObjectContainer container) {
        if (!this.isInsertScheduler) {
            throw new IllegalArgumentException("Adding a SendableInsert to a request scheduler!!");
        }
        if (persistent) {
            if (regmeOnly) {
                boolean queueFull;
                long bootID = 0L;
                boolean bl = queueFull = this.jobRunner.getQueueSize(5) >= 100;
                if (!queueFull) {
                    bootID = this.node.bootID;
                }
                final RegisterMe regme = new RegisterMe(req, req.getPriorityClass(container), this.schedCore, null, bootID);
                container.store((Object)regme);
                if (logMINOR) {
                    Logger.minor(this, "Added insert RegisterMe: " + regme);
                }
                if (!queueFull) {
                    try {
                        this.jobRunner.queue(new DBJob(){

                            public boolean run(ObjectContainer container, ClientContext context) {
                                container.delete((Object)regme);
                                if (req.isCancelled(container)) {
                                    if (logMINOR) {
                                        Logger.minor(this, "Request already cancelled");
                                    }
                                    return false;
                                }
                                if (container.ext().isActive((Object)req)) {
                                    Logger.error(this, "ALREADY ACTIVE: " + req + " in delayed insert register");
                                }
                                container.activate((Object)req, 1);
                                ClientRequestScheduler.this.registerInsert(req, true, false, container);
                                container.deactivate((Object)req, 1);
                                return true;
                            }

                            public String toString() {
                                return super.toString() + "(registerInsert)";
                            }
                        }, 5, false);
                    }
                    catch (DatabaseDisabledException e) {}
                } else {
                    this.schedCore.rerunRegisterMeRunner(this.jobRunner);
                }
                container.deactivate((Object)req, 1);
                return;
            }
            this.schedCore.innerRegister(req, this.random, container, null);
            this.starter.wakeUp();
        } else {
            this.schedTransient.innerRegister(req, this.random, null, null);
            this.starter.wakeUp();
        }
    }

    public void register(HasKeyListener hasListener, SendableGet[] getters, boolean persistent, ObjectContainer container, BlockSet blocks, boolean noCheckStore) throws KeyListenerConstructionException {
        if (logMINOR) {
            Logger.minor(this, "register(" + persistent + "," + hasListener + "," + getters);
        }
        if (this.isInsertScheduler) {
            IllegalStateException e = new IllegalStateException("finishRegister on an insert scheduler");
            throw e;
        }
        if (persistent) {
            this.innerRegister(hasListener, getters, blocks, noCheckStore, container);
        } else {
            KeyListener listener;
            if (hasListener != null) {
                listener = hasListener.makeKeyListener(container, this.clientContext);
                if (listener != null) {
                    this.schedTransient.addPendingKeys(listener);
                } else {
                    Logger.normal(this, "No KeyListener for " + hasListener);
                }
            } else {
                listener = null;
            }
            if (getters != null && !noCheckStore) {
                for (SendableGet getter : getters) {
                    this.datastoreChecker.queueTransientRequest(getter, blocks);
                }
            } else {
                boolean anyValid = false;
                for (int i = 0; i < getters.length; ++i) {
                    if (getters[i].isCancelled(null) || getters[i].isEmpty(null)) continue;
                    anyValid = true;
                }
                this.finishRegister(getters, false, container, anyValid, null);
            }
        }
    }

    private void innerRegister(HasKeyListener hasListener, SendableGet[] getters, BlockSet blocks, boolean noCheckStore, ObjectContainer container) throws KeyListenerConstructionException {
        KeyListener listener;
        if (hasListener != null) {
            listener = hasListener.makeKeyListener(container, this.clientContext);
            this.schedCore.addPendingKeys(listener);
            container.store((Object)hasListener);
        } else {
            listener = null;
        }
        if (getters != null) {
            for (SendableGet getter : getters) {
                container.activate((Object)getter, 1);
                container.store((Object)getter);
            }
        }
        if (this.isInsertScheduler) {
            throw new IllegalStateException("finishRegister on an insert scheduler");
        }
        if (!noCheckStore) {
            for (SendableGet getter : getters) {
                container.activate((Object)getter, 1);
                this.datastoreChecker.queuePersistentRequest(getter, blocks, container);
                container.deactivate((Object)getter, 1);
            }
        } else {
            this.finishRegister(getters, true, container, true, null);
        }
    }

    void finishRegister(SendableGet[] getters, boolean persistent, ObjectContainer container, boolean anyValid, DatastoreCheckerItem reg) {
        if (logMINOR) {
            Logger.minor(this, "finishRegister for " + getters + " anyValid=" + anyValid + " reg=" + reg + " persistent=" + persistent);
        }
        if (this.isInsertScheduler) {
            IllegalStateException e = new IllegalStateException("finishRegister on an insert scheduler");
            for (int i = 0; i < getters.length; ++i) {
                if (persistent) {
                    container.activate((Object)getters[i], 1);
                }
                getters[i].internalError(e, this, container, this.clientContext, persistent);
                if (!persistent) continue;
                container.deactivate((Object)getters[i], 1);
            }
            throw e;
        }
        if (persistent) {
            if (!this.databaseExecutor.onThread()) {
                throw new IllegalStateException("Not on database thread!");
            }
            if (persistent) {
                container.activate((Object)getters, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "finishRegister() for " + getters);
            }
            if (anyValid) {
                boolean wereAnyValid = false;
                for (int i = 0; i < getters.length; ++i) {
                    SendableGet getter = getters[i];
                    container.activate((Object)getter, 1);
                    if (!getter.isCancelled(container) && !getter.isEmpty(container)) {
                        wereAnyValid = true;
                        getter.preRegister(container, this.clientContext, true);
                        this.schedCore.innerRegister(getter, this.random, container, getters);
                        continue;
                    }
                    getter.preRegister(container, this.clientContext, false);
                }
                if (!wereAnyValid) {
                    Logger.normal(this, "No requests valid: " + getters);
                }
            } else {
                Logger.normal(this, "No valid requests passed in: " + getters);
            }
            if (reg != null) {
                container.delete((Object)reg);
            }
            this.maybeFillStarterQueue(container, this.clientContext, getters);
            this.starter.wakeUp();
        } else {
            for (int i = 0; i < getters.length; ++i) {
                if (!anyValid || getters[i].isCancelled(null) || getters[i].isEmpty(null)) {
                    getters[i].preRegister(container, this.clientContext, false);
                    continue;
                }
                getters[i].preRegister(container, this.clientContext, true);
                this.schedTransient.innerRegister(getters[i], this.random, null, getters);
            }
            this.starter.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeFillStarterQueue(ObjectContainer container, ClientContext context, SendableRequest[] mightBeActive) {
        ClientRequestScheduler clientRequestScheduler = this;
        synchronized (clientRequestScheduler) {
            if (this.starterQueue.size() > 256) {
                return;
            }
        }
        this.fillRequestStarterQueue(container, context, mightBeActive);
    }

    public ChosenBlock getBetterNonPersistentRequest(short prio, int retryCount) {
        int fuzz = -1;
        if (PRIORITY_SOFT.equals(this.choosenPriorityScheduler)) {
            fuzz = -1;
        } else if (PRIORITY_HARD.equals(this.choosenPriorityScheduler)) {
            fuzz = 0;
        }
        return this.schedCore.removeFirstTransient(fuzz, this.random, this.offeredKeys, this.starter, this.schedTransient, prio, retryCount, this.clientContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRunningRequest(SendableRequest request) {
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            for (int i = 0; i < this.runningPersistentRequests.size(); ++i) {
                if (this.runningPersistentRequests.get(i) != request) continue;
                this.runningPersistentRequests.remove(i);
                --i;
                if (!logMINOR) continue;
                Logger.minor(this, "Removed running request " + request + " size now " + this.runningPersistentRequests.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunningOrQueuedPersistentRequest(SendableRequest request) {
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            for (int i = 0; i < this.runningPersistentRequests.size(); ++i) {
                if (this.runningPersistentRequests.get(i) != request) continue;
                return true;
            }
            for (PersistentChosenRequest req : this.starterQueue) {
                if (req.request != request) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ChosenBlock grabRequest() {
        while (true) {
            PersistentChosenRequest reqGroup = null;
            LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
            // MONITORENTER : linkedList
            short bestPriority = Short.MAX_VALUE;
            int bestRetryCount = Integer.MAX_VALUE;
            for (PersistentChosenRequest req : this.starterQueue) {
                if (req.prio >= bestPriority && (req.prio != bestPriority || req.retryCount >= bestRetryCount)) continue;
                bestPriority = req.prio;
                bestRetryCount = req.retryCount;
                reqGroup = req;
            }
            // MONITOREXIT : linkedList
            if (reqGroup != null) {
                ChosenBlock better;
                if (logMINOR) {
                    Logger.minor(this, "Persistent request: " + reqGroup + " prio " + reqGroup.prio + " retryCount " + reqGroup.retryCount);
                }
                if ((better = this.getBetterNonPersistentRequest(reqGroup.prio, reqGroup.retryCount)) != null) {
                    if (better.getPriority() <= reqGroup.prio) return better;
                    Logger.error(this, "Selected " + better + " as better than " + reqGroup + " but isn't better!");
                    return better;
                }
            }
            if (reqGroup == null) {
                this.queueFillRequestStarterQueue();
                return this.getBetterNonPersistentRequest((short)Short.MAX_VALUE, Integer.MAX_VALUE);
            }
            int finalLength = 0;
            LinkedList<PersistentChosenRequest> linkedList2 = this.starterQueue;
            // MONITORENTER : linkedList2
            ChosenBlock block = reqGroup.grabNotStarted(this.clientContext.fastWeakRandom, this);
            if (block == null) {
            } else {
                if (!this.runningPersistentRequests.contains(reqGroup.request)) {
                    this.runningPersistentRequests.add(reqGroup.request);
                }
                // MONITOREXIT : linkedList2
                if (finalLength < 512) {
                    this.queueFillRequestStarterQueue();
                }
                if (!logMINOR) return block;
                Logger.minor(this, "grabRequest() returning " + block + " for " + reqGroup);
                return block;
            }
            for (int i = 0; i < this.starterQueue.size(); ++i) {
                if (this.starterQueue.get(i) == reqGroup) {
                    this.starterQueue.remove(i);
                    if (logMINOR) {
                        Logger.minor(this, "Removed " + reqGroup + " from starter queue because is empty");
                    }
                    --i;
                    continue;
                }
                finalLength += this.starterQueue.get(i).sizeNotStarted();
            }
            // MONITOREXIT : linkedList2
        }
    }

    public void queueFillRequestStarterQueue() {
        if (System.currentTimeMillis() < this.nextQueueFillRequestStarterQueue) {
            return;
        }
        if (this.starterQueueLength() > 256) {
            return;
        }
        try {
            this.jobRunner.queue(this.requestStarterQueueFiller, 10, true);
        }
        catch (DatabaseDisabledException e) {
            this.moveKeysFromCooldownQueue(this.transientCooldownQueue, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int starterQueueLength() {
        int length = 0;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            for (PersistentChosenRequest request : this.starterQueue) {
                length += request.sizeNotStarted();
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addToStarterQueue(SendableRequest request, ObjectContainer container) {
        PersistentChosenRequest chosen;
        if (logMINOR) {
            Logger.minor(this, "Adding to starter queue: " + request);
        }
        container.activate((Object)request, 1);
        try {
            chosen = new PersistentChosenRequest(request, request.getPriorityClass(container), request.getRetryCount(), container, this, this.clientContext);
        }
        catch (NoValidBlocksException e) {
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Created PCR: " + chosen);
        }
        container.deactivate((Object)request, 1);
        boolean dumpNew = false;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            for (PersistentChosenRequest req : this.starterQueue) {
                if (req.request != request) continue;
                Logger.error(this, "Already on starter queue: " + req + " for " + request, new Exception("debug"));
                dumpNew = true;
                break;
            }
            if (!dumpNew) {
                this.starterQueue.add(chosen);
                int length = this.starterQueueLength();
                length += chosen.sizeNotStarted();
                this.runningPersistentRequests.add(request);
                if (logMINOR) {
                    Logger.minor(this, "Added to running persistent requests, size now " + this.runningPersistentRequests.size() + " : " + request);
                }
                return length > 512;
            }
        }
        if (dumpNew) {
            chosen.onDumped(this.schedCore, container, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromStarterQueue(SendableRequest req, ObjectContainer container, boolean reqAlreadyActive) {
        PersistentChosenRequest dumped = null;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            for (int i = 0; i < this.starterQueue.size(); ++i) {
                PersistentChosenRequest pcr = this.starterQueue.get(i);
                if (pcr.request != req) continue;
                this.starterQueue.remove(i);
                dumped = pcr;
                break;
            }
        }
        if (dumped != null) {
            dumped.onDumped(this.schedCore, container, reqAlreadyActive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int starterQueueSize() {
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            return this.starterQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillRequestStarterQueue(ObjectContainer container, ClientContext context, SendableRequest[] mightBeActive) {
        boolean full;
        if (logMINOR) {
            Logger.minor(this, "Filling request queue... (SSK=" + this.isSSKScheduler + " insert=" + this.isInsertScheduler);
        }
        long noLaterThan = Long.MAX_VALUE;
        if (!this.isInsertScheduler) {
            noLaterThan = this.moveKeysFromCooldownQueue(this.persistentCooldownQueue, true, container);
            noLaterThan = Math.min(noLaterThan, this.moveKeysFromCooldownQueue(this.transientCooldownQueue, false, container));
        }
        int fuzz = -1;
        if (PRIORITY_SOFT.equals(this.choosenPriorityScheduler)) {
            fuzz = -1;
        } else if (PRIORITY_HARD.equals(this.choosenPriorityScheduler)) {
            fuzz = 0;
        }
        boolean added = false;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            if (logMINOR && !this.isSSKScheduler && !this.isInsertScheduler) {
                Logger.minor(this, "Scheduling CHK fetches...");
                for (SendableRequest req : this.runningPersistentRequests) {
                    boolean wasActive = container.ext().isActive((Object)req);
                    if (!wasActive) {
                        container.activate((Object)req, 1);
                    }
                    Logger.minor(this, "Running persistent request: " + req);
                    if (wasActive) continue;
                    container.deactivate((Object)req, 1);
                }
            }
            int length = 0;
            PersistentChosenRequest old = null;
            for (PersistentChosenRequest req : this.starterQueue) {
                if (old == req) {
                    Logger.error(this, "DUPLICATE CHOSEN REQUESTS ON QUEUE: " + req);
                }
                if (old != null && old.request == req.request) {
                    Logger.error(this, "DUPLICATE REQUEST ON QUEUE: " + old + " vs " + req + " both " + req.request);
                }
                boolean ignoreActive = false;
                if (mightBeActive != null) {
                    for (SendableRequest tmp : mightBeActive) {
                        if (tmp != req.request) continue;
                        ignoreActive = true;
                    }
                }
                if (!ignoreActive) {
                    if (container.ext().isActive((Object)req.request)) {
                        Logger.error(this, "REQUEST ALREADY ACTIVATED: " + req.request + " for " + req + " while checking request queue in filling request queue");
                    } else if (logMINOR) {
                        Logger.minor(this, "Not already activated for " + req + " in while checking request queue in filling request queue");
                    }
                } else if (logMINOR) {
                    Logger.minor(this, "Ignoring active because just registered: " + req.request);
                }
                req.pruneDuplicates(this);
                old = req;
                length += req.sizeNotStarted();
            }
            if (logMINOR) {
                Logger.minor(this, "Queue size: " + length + " SSK=" + this.isSSKScheduler + " insert=" + this.isInsertScheduler);
            }
            if (length > 384) {
                if (length >= 800) {
                    Logger.error(this, "Queue already full: " + length);
                }
                return;
            }
        }
        if (!this.isSSKScheduler && !this.isInsertScheduler) {
            Logger.minor(this, "Scheduling CHK fetches...");
        }
        boolean addedMore = false;
        do {
            SendableRequest request;
            if ((request = this.schedCore.removeFirstInner(fuzz, this.random, this.offeredKeys, this.starter, this.schedTransient, false, true, (short)Short.MAX_VALUE, Integer.MAX_VALUE, context, container)) == null) {
                ClientRequestScheduler old = this;
                synchronized (old) {
                    if (!added) {
                        this.nextQueueFillRequestStarterQueue = System.currentTimeMillis() + 60000L;
                        if (this.nextQueueFillRequestStarterQueue > noLaterThan) {
                            this.nextQueueFillRequestStarterQueue = noLaterThan + 1L;
                        }
                    }
                }
                if (addedMore) {
                    this.starter.wakeUp();
                }
                return;
            }
            full = this.addToStarterQueue(request, container);
            container.deactivate((Object)request, 1);
            if (!added) {
                this.starter.wakeUp();
            } else {
                addedMore = true;
            }
            added = true;
        } while (!full);
        if (addedMore) {
            this.starter.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeAddToStarterQueue(SendableRequest req, ObjectContainer container, SendableRequest[] mightBeActive) {
        short prio = req.getPriorityClass(container);
        int retryCount = req.getRetryCount();
        if (logMINOR) {
            Logger.minor(this, "Maybe adding to starter queue: prio=" + prio + " retry count=" + retryCount);
        }
        boolean logDEBUG = Logger.shouldLog(2, this);
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            boolean betterThanSome = false;
            int size = 0;
            PersistentChosenRequest prev = null;
            for (PersistentChosenRequest old : this.starterQueue) {
                if (old.request == req) {
                    if (logMINOR) {
                        Logger.minor(this, "Already on starter queue: " + old + " for " + req);
                    }
                    return;
                }
                if (prev == old) {
                    Logger.error(this, "ON STARTER QUEUE TWICE: " + prev + " for " + prev.request);
                }
                if (prev != null && prev.request == old.request) {
                    Logger.error(this, "REQUEST ON STARTER QUEUE TWICE: " + prev + " for " + prev.request + " vs " + old + " for " + old.request);
                }
                boolean ignoreActive = false;
                if (mightBeActive != null) {
                    for (SendableRequest tmp : mightBeActive) {
                        if (tmp != old.request) continue;
                        ignoreActive = true;
                    }
                }
                if (!ignoreActive) {
                    if (container.ext().isActive((Object)old.request)) {
                        Logger.error(this, "REQUEST ALREADY ACTIVATED: " + old.request + " for " + old + " while checking request queue in maybeAddToStarterQueue for " + req);
                    } else if (logDEBUG) {
                        Logger.debug(this, "Not already activated for " + old + " in while checking request queue in maybeAddToStarterQueue for " + req);
                    }
                } else if (logMINOR) {
                    Logger.minor(this, "Ignoring active because just registered: " + old.request + " in maybeAddToStarterQueue for " + req);
                }
                size += old.sizeNotStarted();
                if (old.prio > prio || old.prio == prio && old.retryCount > retryCount) {
                    betterThanSome = true;
                }
                if (old.request == req) {
                    return;
                }
                prev = old;
            }
            if (size >= 512 && !betterThanSome) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding to starter queue: over limit and req not better than any queued requests");
                }
                return;
            }
        }
        this.addToStarterQueue(req, container);
        this.trimStarterQueue(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimStarterQueue(ObjectContainer container) {
        ArrayList<PersistentChosenRequest> dumped = null;
        LinkedList<PersistentChosenRequest> linkedList = this.starterQueue;
        synchronized (linkedList) {
            int length = this.starterQueueLength();
            while (length > 512) {
                PersistentChosenRequest worst = null;
                short worstPrio = -1;
                int worstRetryCount = -1;
                int worstIndex = -1;
                int worstLength = -1;
                if (this.starterQueue.isEmpty()) break;
                length = 0;
                for (int i = 0; i < this.starterQueue.size(); ++i) {
                    PersistentChosenRequest req = this.starterQueue.get(i);
                    short prio = req.prio;
                    int retryCount = req.retryCount;
                    int size = req.sizeNotStarted();
                    length += size;
                    if (prio <= worstPrio && (prio != worstPrio || retryCount <= worstRetryCount)) continue;
                    worstPrio = prio;
                    worstRetryCount = retryCount;
                    worst = req;
                    worstIndex = i;
                    worstLength = size;
                }
                int lengthAfter = length - worstLength;
                if (lengthAfter < 512) break;
                if (dumped == null) {
                    dumped = new ArrayList<PersistentChosenRequest>(2);
                }
                dumped.add(worst);
                this.starterQueue.remove(worstIndex);
                if (lengthAfter != 512) continue;
                break;
            }
        }
        if (dumped == null) {
            return;
        }
        for (PersistentChosenRequest req : dumped) {
            req.onDumped(this.schedCore, container, false);
        }
    }

    public void removePendingKeys(KeyListener getter, boolean complain) {
        boolean found = this.schedTransient.removePendingKeys(getter);
        if (complain && !(found |= this.schedCore.removePendingKeys(getter))) {
            Logger.error(this, "Listener not found when removing: " + getter);
        }
    }

    public void removePendingKeys(HasKeyListener getter, boolean complain) {
        boolean found = this.schedTransient.removePendingKeys(getter);
        if (complain && !(found |= this.schedCore.removePendingKeys(getter))) {
            Logger.error(this, "Listener not found when removing: " + getter);
        }
    }

    public void reregisterAll(ClientRequester request, ObjectContainer container) {
        this.schedTransient.reregisterAll(request, this.random, this, null, this.clientContext);
        this.schedCore.reregisterAll(request, this.random, this, container, this.clientContext);
        this.starter.wakeUp();
    }

    public String getChoosenPriorityScheduler() {
        return this.choosenPriorityScheduler;
    }

    public synchronized void succeeded(final BaseSendableGet succeeded, boolean persistent) {
        if (persistent) {
            try {
                this.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)succeeded)) {
                            Logger.error(this, "ALREADY ACTIVE in succeeded(): " + succeeded);
                        }
                        container.activate((Object)succeeded, 1);
                        ClientRequestScheduler.this.schedCore.succeeded(succeeded, container);
                        container.deactivate((Object)succeeded, 1);
                        return false;
                    }

                    public String toString() {
                        return super.toString() + "(succeeded)";
                    }
                }, 6, false);
            }
            catch (DatabaseDisabledException e) {
                Logger.error(this, "succeeded() on a persistent request but database disabled", new Exception("error"));
            }
        } else {
            this.schedTransient.succeeded(succeeded, null);
        }
    }

    public void tripPendingKey(final KeyBlock block) {
        if (logMINOR) {
            Logger.minor(this, "tripPendingKey(" + block.getKey() + ")");
        }
        if (this.offeredKeys != null) {
            for (int i = 0; i < this.offeredKeys.length; ++i) {
                this.offeredKeys[i].remove(block.getKey());
            }
        }
        final Key key = block.getKey();
        this.schedTransient.tripPendingKey(key, block, null, this.clientContext);
        if (this.schedCore.anyProbablyWantKey(key, this.clientContext)) {
            try {
                this.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (logMINOR) {
                            Logger.minor(this, "tripPendingKey for " + key);
                        }
                        ClientRequestScheduler.this.schedCore.tripPendingKey(key, block, container, ClientRequestScheduler.this.clientContext);
                        return false;
                    }

                    public String toString() {
                        return super.toString() + "(tripkey)";
                    }
                }, 6, false);
            }
            catch (DatabaseDisabledException databaseDisabledException) {}
        } else {
            this.schedCore.countNegative();
        }
    }

    public void maybeQueueOfferedKey(final Key key, boolean force) {
        if (logMINOR) {
            Logger.minor(this, "maybeQueueOfferedKey(" + key + "," + force);
        }
        short priority = Short.MAX_VALUE;
        if (force) {
            priority = 4;
        }
        if ((priority = this.schedTransient.getKeyPrio(key, priority, null, this.clientContext)) < Short.MAX_VALUE) {
            this.offeredKeys[priority].queueKey(key);
            this.starter.wakeUp();
        }
        final short oldPrio = priority;
        try {
            this.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    short priority = ClientRequestScheduler.this.schedCore.getKeyPrio(key, oldPrio, container, context);
                    if (priority >= oldPrio) {
                        return false;
                    }
                    ClientRequestScheduler.this.offeredKeys[priority].queueKey(key.cloneKey());
                    ClientRequestScheduler.this.starter.wakeUp();
                    return false;
                }

                public String toString() {
                    return super.toString() + "(maybequeueofferedkey)";
                }
            }, 5, false);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
    }

    public void dequeueOfferedKey(Key key) {
        for (int i = 0; i < this.offeredKeys.length; ++i) {
            this.offeredKeys[i].remove(key);
        }
    }

    public long queueCooldown(ClientKey key, SendableGet getter, ObjectContainer container) {
        if (getter.persistent()) {
            return this.persistentCooldownQueue.add(key.getNodeKey(), getter, container);
        }
        return this.transientCooldownQueue.add(key.getNodeKey(), getter, null);
    }

    private long moveKeysFromCooldownQueue(CooldownQueue queue, boolean persistent, ObjectContainer container) {
        if (queue == null) {
            return Long.MAX_VALUE;
        }
        long now = System.currentTimeMillis();
        int MAX_KEYS = 20;
        Object ret = queue.removeKeyBefore(now, 60000L, container, 20);
        if (ret == null) {
            return Long.MAX_VALUE;
        }
        if (ret instanceof Long) {
            return (Long)ret;
        }
        Key[] keys = (Key[])ret;
        for (int j = 0; j < keys.length; ++j) {
            int i;
            Key key = keys[j];
            if (persistent) {
                container.activate((Object)key, 5);
            }
            if (logMINOR) {
                Logger.minor(this, "Restoring key: " + key);
            }
            SendableGet[] reqs = container == null ? null : this.schedCore.requestsForKey(key, container, this.clientContext);
            SendableGet[] transientReqs = this.schedTransient.requestsForKey(key, container, this.clientContext);
            if (reqs == null && transientReqs == null && logMINOR) {
                Logger.minor(this, "Restoring key but no keys queued?? for " + key);
            }
            if (reqs != null) {
                for (i = 0; i < reqs.length; ++i) {
                    container.activate((Object)reqs[i], 1);
                    reqs[i].requeueAfterCooldown(key, now, container, this.clientContext);
                    container.deactivate((Object)reqs[i], 1);
                }
            }
            if (transientReqs != null) {
                for (i = 0; i < transientReqs.length; ++i) {
                    transientReqs[i].requeueAfterCooldown(key, now, container, this.clientContext);
                }
            }
            if (!persistent) continue;
            container.deactivate((Object)key, 5);
        }
        return Long.MAX_VALUE;
    }

    public long countTransientQueuedRequests() {
        return this.schedTransient.countQueuedRequests(null, this.clientContext);
    }

    public KeysFetchingLocally fetchingKeys() {
        return this.schedCore;
    }

    public void removeFetchingKey(Key key) {
        this.schedCore.removeFetchingKey(key);
    }

    public void removeTransientInsertFetching(SendableInsert insert, Object token) {
        this.schedCore.removeTransientInsertFetching(insert, token);
    }

    public void callFailure(final SendableGet get, final LowLevelGetException e, int prio, boolean persistent) {
        if (!persistent) {
            get.onFailure(e, null, null, this.clientContext);
        } else {
            try {
                this.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)get)) {
                            Logger.error(this, "ALREADY ACTIVE: " + get + " in callFailure(request)");
                        }
                        container.activate((Object)get, 1);
                        get.onFailure(e, null, container, ClientRequestScheduler.this.clientContext);
                        container.deactivate((Object)get, 1);
                        return false;
                    }

                    public String toString() {
                        return super.toString() + "(callfailureget)";
                    }
                }, prio, false);
            }
            catch (DatabaseDisabledException e1) {
                Logger.error(this, "callFailure() on a persistent request but database disabled", new Exception("error"));
            }
        }
    }

    public void callFailure(final SendableInsert insert, final LowLevelPutException e, int prio, boolean persistent) {
        if (!persistent) {
            insert.onFailure(e, null, null, this.clientContext);
        } else {
            try {
                this.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        if (container.ext().isActive((Object)insert)) {
                            Logger.error(this, "ALREADY ACTIVE: " + insert + " in callFailure(insert)");
                        }
                        container.activate((Object)insert, 1);
                        insert.onFailure(e, null, container, context);
                        container.deactivate((Object)insert, 1);
                        return false;
                    }

                    public String toString() {
                        return super.toString() + "(callfailureput)";
                    }
                }, prio, false);
            }
            catch (DatabaseDisabledException e1) {
                Logger.error(this, "callFailure() on a persistent request but database disabled", new Exception("error"));
            }
        }
    }

    public FECQueue getFECQueue() {
        return this.clientContext.fecQueue;
    }

    public ClientContext getContext() {
        return this.clientContext;
    }

    public boolean addToFetching(Key key) {
        return this.schedCore.addToFetching(key);
    }

    public boolean addTransientInsertFetching(SendableInsert insert, Object token) {
        return this.schedCore.addTransientInsertFetching(insert, token);
    }

    public boolean hasFetchingKey(Key key) {
        return this.schedCore.hasKey(key);
    }

    public long countPersistentWaitingKeys(ObjectContainer container) {
        return this.schedCore.countWaitingKeys(container);
    }

    public long countPersistentQueuedRequests(ObjectContainer container) {
        return this.schedCore.countQueuedRequests(container, this.clientContext);
    }

    public boolean isQueueAlmostEmpty() {
        return this.starterQueueSize() < 128;
    }

    public boolean isInsertScheduler() {
        return this.isInsertScheduler;
    }

    public void removeFromAllRequestsByClientRequest(ClientRequester clientRequest, SendableRequest get, boolean dontComplain, ObjectContainer container) {
        if (get.persistent()) {
            this.schedCore.removeFromAllRequestsByClientRequest(get, clientRequest, dontComplain, container);
        } else {
            this.schedTransient.removeFromAllRequestsByClientRequest(get, clientRequest, dontComplain, null);
        }
    }

    public byte[] saltKey(Key key) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key.getRoutingKey());
        md.update(this.schedCore.globalSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    void addPersistentPendingKeys(KeyListener listener) {
        this.schedCore.addPendingKeys(listener);
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing ClientRequestScheduler in database", new Exception("error"));
        return false;
    }

    public void wakeStarter() {
        this.starter.wakeUp();
    }

    public boolean cacheInserts() {
        return this.node.clientCore.cacheInserts();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    public static class PrioritySchedulerCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        final ClientRequestScheduler cs;
        private final String[] possibleValues = new String[]{"HARD", "SOFT"};

        PrioritySchedulerCallback(ClientRequestScheduler cs) {
            this.cs = cs;
        }

        public String get() {
            if (this.cs != null) {
                return this.cs.getChoosenPriorityScheduler();
            }
            return ClientRequestScheduler.PRIORITY_HARD;
        }

        public void set(String val) throws InvalidConfigValueException {
            String value;
            if (val == null || val.equalsIgnoreCase(this.get())) {
                return;
            }
            if (val.equalsIgnoreCase(ClientRequestScheduler.PRIORITY_HARD)) {
                value = ClientRequestScheduler.PRIORITY_HARD;
            } else if (val.equalsIgnoreCase(ClientRequestScheduler.PRIORITY_SOFT)) {
                value = ClientRequestScheduler.PRIORITY_SOFT;
            } else {
                throw new InvalidConfigValueException("Invalid priority scheme");
            }
            this.cs.setPriorityScheduler(value);
        }

        public String[] getPossibleValues() {
            return this.possibleValues;
        }
    }
}

