/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.BinaryBlobFormatException;
import freenet.client.async.BinaryBlobInserter;
import freenet.client.async.ClientCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import java.io.IOException;

public class ClientPutter
extends BaseClientPutter
implements PutCompletionCallback {
    final ClientPutCallback client;
    final Bucket data;
    final FreenetURI targetURI;
    final ClientMetadata cm;
    final InsertContext ctx;
    final String targetFilename;
    private ClientPutState currentState;
    private boolean finished;
    private final boolean getCHKOnly;
    private final boolean isMetadata;
    private boolean startedStarting;
    private final boolean binaryBlob;
    private FreenetURI uri;
    private SimpleFieldSet oldProgress;

    @Deprecated
    public ClientPutter(ClientCallback client, Bucket data, FreenetURI targetURI, ClientMetadata cm, InsertContext ctx, short priorityClass, boolean getCHKOnly, boolean isMetadata, RequestClient clientContext, SimpleFieldSet stored, String targetFilename, boolean binaryBlob) {
        this((ClientPutCallback)client, data, targetURI, cm, ctx, priorityClass, getCHKOnly, isMetadata, clientContext, stored, targetFilename, binaryBlob);
    }

    public ClientPutter(ClientPutCallback client, Bucket data, FreenetURI targetURI, ClientMetadata cm, InsertContext ctx, short priorityClass, boolean getCHKOnly, boolean isMetadata, RequestClient clientContext, SimpleFieldSet stored, String targetFilename, boolean binaryBlob) {
        super(priorityClass, clientContext);
        this.cm = cm;
        this.isMetadata = isMetadata;
        this.getCHKOnly = getCHKOnly;
        this.client = client;
        this.data = data;
        this.targetURI = targetURI;
        this.ctx = ctx;
        this.finished = false;
        this.cancelled = false;
        this.oldProgress = stored;
        this.targetFilename = targetFilename;
        this.binaryBlob = binaryBlob;
    }

    public void start(boolean earlyEncode, ObjectContainer container, ClientContext context) throws InsertException {
        this.start(earlyEncode, false, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean earlyEncode, boolean restart, ObjectContainer container, ClientContext context) throws InsertException {
        block47: {
            if (this.persistent()) {
                container.activate((Object)this.client, 1);
            }
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Starting " + this);
            }
            try {
                this.targetURI.checkInsertURI();
                if (this.data == null) {
                    throw new InsertException(2, "No data to insert", null);
                }
                boolean cancel = false;
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    if (restart) {
                        if (this.currentState != null && !this.finished) {
                            return false;
                        }
                        this.finished = false;
                    }
                    if (this.startedStarting) {
                        return false;
                    }
                    this.startedStarting = true;
                    if (this.currentState != null) {
                        return false;
                    }
                    cancel = this.cancelled;
                    if (!cancel) {
                        if (!this.binaryBlob) {
                            ClientMetadata meta = this.cm;
                            if (meta != null) {
                                meta = this.persistent() ? meta.clone() : meta;
                            }
                            this.currentState = new SingleFileInserter(this, this, new InsertBlock(this.data, meta, this.persistent() ? this.targetURI.clone() : this.targetURI), this.isMetadata, this.ctx, false, this.getCHKOnly, false, null, null, false, this.targetFilename, earlyEncode);
                        } else {
                            this.currentState = new BinaryBlobInserter(this.data, this, null, false, this.priorityClass, this.ctx, context, container);
                        }
                    }
                }
                if (cancel) {
                    this.onFailure(new InsertException(10), null, container, context);
                    this.oldProgress = null;
                    return false;
                }
                clientPutter = this;
                synchronized (clientPutter) {
                    cancel = this.cancelled;
                }
                if (cancel) {
                    this.onFailure(new InsertException(10), null, container, context);
                    this.oldProgress = null;
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                    return false;
                }
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "Starting insert: " + this.currentState);
                }
                if (this.currentState instanceof SingleFileInserter) {
                    ((SingleFileInserter)this.currentState).start(this.oldProgress, container, context);
                } else {
                    this.currentState.schedule(container, context);
                }
                clientPutter = this;
                synchronized (clientPutter) {
                    this.oldProgress = null;
                    cancel = this.cancelled;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                    container.deactivate((Object)this.currentState, 1);
                }
                if (cancel) {
                    this.onFailure(new InsertException(10), null, container, context);
                    return false;
                }
            }
            catch (InsertException e) {
                Logger.error(this, "Failed to start insert: " + e, e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.oldProgress = null;
                    this.currentState = null;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                if (this.client != null) {
                    this.client.onFailure(e, this, container);
                }
            }
            catch (IOException e) {
                Logger.error(this, "Failed to start insert: " + e, e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.oldProgress = null;
                    this.currentState = null;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                if (this.client != null) {
                    this.client.onFailure(new InsertException(2, e, null), this, container);
                }
            }
            catch (BinaryBlobFormatException e) {
                Logger.error(this, "Failed to start insert: " + e, e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.oldProgress = null;
                    this.currentState = null;
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                if (this.client == null) break block47;
                this.client.onFailure(new InsertException(12, e, null), this, container);
            }
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Started " + this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        ClientPutState oldState;
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.finished = true;
            oldState = this.currentState;
            this.currentState = null;
            this.oldProgress = null;
        }
        if (oldState != null && this.persistent()) {
            container.activate((Object)oldState, 1);
            oldState.removeFrom(container, context);
        }
        if (state != null && state != oldState && this.persistent()) {
            state.removeFrom(container, context);
        }
        if (this.failedBlocks > 0 || this.fatallyFailedBlocks > 0 || this.successfulBlocks < this.totalBlocks) {
            Logger.error(this, "Failed blocks: " + this.failedBlocks + ", Fatally failed blocks: " + this.fatallyFailedBlocks + ", Successful blocks: " + this.successfulBlocks + ", Total blocks: " + this.totalBlocks + " but success?! on " + this + " from " + state, new Exception("debug"));
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.client.onSuccess(this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        ClientPutState oldState;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "onFailure() for " + this + " : " + state + " : " + e, (Throwable)e);
        }
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.finished = true;
            oldState = this.currentState;
            this.currentState = null;
            this.oldProgress = null;
        }
        if (oldState != null && this.persistent()) {
            container.activate((Object)oldState, 1);
            oldState.removeFrom(container, context);
        }
        if (state != null && state != oldState && this.persistent()) {
            state.removeFrom(container, context);
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.client.onFailure(e, this, container);
    }

    public void onMajorProgress(ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        this.client.onMajorProgress(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.uri != null) {
                Logger.error(this, "onEncode() called twice? Already have a uri: " + this.uri + " for " + this);
                if (this.persistent()) {
                    this.uri.removeFrom(container);
                }
            }
            this.uri = key.getURI();
            if (this.targetFilename != null) {
                this.uri = this.uri.pushMetaString(this.targetFilename);
            }
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.client.onGeneratedURI(this.uri, this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
        }
        ClientPutState oldState = null;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.cancelled) {
                return;
            }
            if (this.finished) {
                return;
            }
            super.cancel();
            oldState = this.currentState;
        }
        if (this.persistent()) {
            container.store((Object)this);
            if (oldState != null) {
                container.activate((Object)oldState, 1);
            }
        }
        if (oldState != null) {
            oldState.cancel(container, context);
        }
        this.onFailure(new InsertException(10), null, container, context);
    }

    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    public FreenetURI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        if (newState == null) {
            throw new NullPointerException();
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.currentState == oldState) {
                this.currentState = newState;
                if (this.persistent()) {
                    container.store((Object)this);
                }
                return;
            }
        }
        Logger.error(this, "onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState);
    }

    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
        Logger.error(this, "Got metadata on " + this + " from " + state + " (this means the metadata won't be inserted)");
    }

    public void notifyClients(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 2);
        }
        this.ctx.eventProducer.produceEvent(new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.minSuccessBlocks, this.blockSetFinalized), container, context);
    }

    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SendingToNetworkEvent(), container, context);
    }

    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Set finished", (Throwable)new Exception("debug"));
        }
        this.blockSetFinalized(container, context);
    }

    public void onFetchable(ClientPutState state, ObjectContainer container) {
        if (this.persistent()) {
            container.activate((Object)this.client, 1);
        }
        this.client.onFetchable(this, container);
    }

    public boolean canRestart() {
        if (this.currentState != null && !this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.uri);
            return false;
        }
        return this.data != null;
    }

    public boolean restart(boolean earlyEncode, ObjectContainer container, ClientContext context) throws InsertException {
        return this.start(earlyEncode, true, container, context);
    }

    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.cm, 2);
        this.cm.removeFrom(container);
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        if (this.uri != null) {
            container.activate((Object)this.uri, 5);
            this.uri.removeFrom(container);
        }
        super.removeFrom(container, context);
    }
}

