/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.BaseClientGetter;
import freenet.client.async.BinaryBlob;
import freenet.client.async.ClientCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetState;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SingleFileFetcher;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.ClientKeyBlock;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;

public class ClientGetter
extends BaseClientGetter {
    private static volatile boolean logMINOR;
    final ClientGetCallback clientCallback;
    FreenetURI uri;
    final FetchContext ctx;
    final ArchiveContext actx;
    private ClientGetState currentState;
    private boolean finished;
    private int archiveRestarts;
    final Bucket returnBucket;
    final Bucket binaryBlobBucket;
    final HashSet<Key> binaryBlobKeysAddedAlready;
    private DataOutputStream binaryBlobStream;
    private String expectedMIME;
    private long expectedSize;
    private boolean finalizedMetadata;

    @Deprecated
    public ClientGetter(ClientCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext, Bucket returnBucket, Bucket binaryBlobBucket) {
        this((ClientGetCallback)client, uri, ctx, priorityClass, clientContext, returnBucket, binaryBlobBucket);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext, Bucket returnBucket, Bucket binaryBlobBucket) {
        super(priorityClass, clientContext);
        this.clientCallback = client;
        this.returnBucket = returnBucket;
        this.uri = uri;
        this.ctx = ctx;
        this.finished = false;
        this.actx = new ArchiveContext(ctx.maxTempLength, ctx.maxArchiveLevels);
        this.binaryBlobBucket = binaryBlobBucket;
        this.binaryBlobKeysAddedAlready = binaryBlobBucket != null ? new HashSet() : null;
        this.archiveRestarts = 0;
    }

    public void start(ObjectContainer container, ClientContext context) throws FetchException {
        this.start(false, null, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean restart, FreenetURI overrideURI, ObjectContainer container, ClientContext context) throws FetchException {
        if (this.persistent()) {
            container.activate((Object)this.uri, 5);
        }
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " persistent=" + this.persistent());
        }
        try {
            ClientGetter clientGetter = this;
            synchronized (clientGetter) {
                if (overrideURI != null) {
                    this.uri = overrideURI;
                }
                if (this.finished) {
                    if (!restart) {
                        return false;
                    }
                    this.currentState = null;
                    this.cancelled = false;
                    this.finished = false;
                }
                this.currentState = SingleFileFetcher.create(this, this, this.uri, this.ctx, this.actx, this.ctx.maxNonSplitfileRetries, 0, false, -1L, true, this.returnBucket, true, container, context);
            }
            if (this.cancelled) {
                this.cancel();
            }
            if (this.persistent()) {
                container.store((Object)this.currentState);
                container.store((Object)this);
            }
            if (this.currentState != null && !this.finished) {
                if (this.binaryBlobBucket != null) {
                    try {
                        this.binaryBlobStream = new DataOutputStream(new BufferedOutputStream(this.binaryBlobBucket.getOutputStream()));
                        BinaryBlob.writeBinaryBlobHeader(this.binaryBlobStream);
                    }
                    catch (IOException e) {
                        throw new FetchException(12, "Failed to open binary blob bucket", e);
                    }
                }
                this.currentState.schedule(container, context);
            }
            if (this.cancelled) {
                this.cancel();
            }
        }
        catch (MalformedURLException e) {
            throw new FetchException(20, (Throwable)e);
        }
        catch (KeyListenerConstructionException e) {
            this.onFailure(e.getFetchException(), this.currentState, container, context);
        }
        if (this.persistent()) {
            container.store((Object)this);
            container.deactivate((Object)this.currentState, 1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(FetchResult result, ClientGetState state, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Succeeded from " + state + " on " + this);
        }
        if (this.persistent()) {
            container.activate((Object)this.uri, 5);
        }
        if (!this.closeBinaryBlobStream(container, context)) {
            return;
        }
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            this.finished = true;
            this.currentState = null;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (this.returnBucket != null && result.asBucket() != this.returnBucket) {
            Bucket from = result.asBucket();
            Bucket to = this.returnBucket;
            try {
                if (logMINOR) {
                    Logger.minor(this, "Copying - returnBucket not respected by client.async");
                }
                if (this.persistent()) {
                    container.activate((Object)from, 5);
                    container.activate((Object)this.returnBucket, 5);
                }
                BucketTools.copy(from, to);
                from.free();
                if (this.persistent()) {
                    from.removeFrom(container);
                }
            }
            catch (IOException e) {
                Logger.error(this, "Error copying from " + from + " to " + to + " : " + e.toString(), e);
                this.onFailure(new FetchException(12, e.toString()), state, container, context);
                return;
            }
            result = new FetchResult(result, to);
        } else if (this.returnBucket != null && logMINOR) {
            Logger.minor(this, "client.async returned data in returnBucket");
        }
        if (this.persistent()) {
            container.activate((Object)state, 1);
            state.removeFrom(container, context);
            container.activate((Object)this.clientCallback, 1);
        }
        FetchResult res = result;
        this.clientCallback.onSuccess(res, this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Failed from " + state + " : " + e + " on " + this, (Throwable)e);
        }
        this.closeBinaryBlobStream(container, context);
        if (this.persistent()) {
            container.activate((Object)this.uri, 5);
        }
        ClientGetState oldState = null;
        while (e.mode == 26) {
            int ar;
            ClientGetter clientGetter = this;
            synchronized (clientGetter) {
                ar = ++this.archiveRestarts;
            }
            if (logMINOR) {
                Logger.minor(this, "Archive restart on " + this + " ar=" + ar);
            }
            if (ar > this.ctx.maxArchiveRestarts) {
                e = new FetchException(8);
                break;
            }
            try {
                this.start(container, context);
            }
            catch (FetchException e1) {
                e = e1;
                continue;
            }
            return;
        }
        ClientGetter ar = this;
        synchronized (ar) {
            this.finished = true;
            oldState = this.currentState;
            this.currentState = null;
        }
        if (e.errorCodes != null && e.errorCodes.isOneCodeOnly()) {
            e = new FetchException(e.errorCodes.getFirstCode(), (Throwable)e);
        }
        if (e.mode == 13 && this.successfulBlocks > 0) {
            e = new FetchException(e, 28);
        }
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + e + ", " + state + ") on " + this + " for " + this.uri, (Throwable)e);
        }
        FetchException e1 = e;
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (this.persistent()) {
            container.activate((Object)this.clientCallback, 1);
        }
        this.clientCallback.onFailure(e1, this, container);
        if (this.persistent()) {
            if (state != null) {
                container.activate((Object)state, 1);
                state.removeFrom(container, context);
            }
            if (oldState != state && oldState != null) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        ClientGetState state;
        ClientGetState s;
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
        }
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (super.cancel()) {
                if (logMINOR) {
                    Logger.minor(this, "Already cancelled " + this);
                }
                return;
            }
            s = this.currentState;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (s != null) {
            if (this.persistent()) {
                container.activate((Object)s, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + s + " for " + this + " instance " + super.toString());
            }
            s.cancel(container, context);
            if (this.persistent()) {
                container.deactivate((Object)s, 1);
            }
        } else if (logMINOR) {
            Logger.minor(this, "Nothing to cancel");
        }
        ClientGetter clientGetter2 = this;
        synchronized (clientGetter2) {
            state = this.currentState;
        }
        if (state == null) {
            return;
        }
        Logger.error(this, "Cancelling " + this.currentState + " did not call onFailure(), so did not removeFrom() or call callback");
        this.onFailure(new FetchException(25), state, container, context);
    }

    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    public FreenetURI getURI() {
        return this.uri;
    }

    public void notifyClients(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.minSuccessBlocks, this.blockSetFinalized), container, context);
    }

    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SendingToNetworkEvent(), container, context);
    }

    public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Set finished", (Throwable)new Exception("debug"));
        }
        this.blockSetFinalized(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (this.currentState == oldState) {
                this.currentState = newState;
                if (logMINOR) {
                    Logger.minor(this, "Transition: " + oldState + " -> " + newState + " on " + this + " persistent = " + this.persistent() + " instance = " + super.toString(), (Throwable)new Exception("debug"));
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring transition: " + oldState + " -> " + newState + " because current = " + this.currentState + " on " + this + " persistent = " + this.persistent(), (Throwable)new Exception("debug"));
                }
                return;
            }
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public boolean canRestart() {
        if (this.currentState != null && !this.finished) {
            if (logMINOR) {
                Logger.minor(this, "Cannot restart because not finished for " + this.uri);
            }
            return false;
        }
        return true;
    }

    public boolean restart(FreenetURI redirect, ObjectContainer container, ClientContext context) throws FetchException {
        return this.start(true, redirect, container, context);
    }

    public String toString() {
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addKeyToBinaryBlob(ClientKeyBlock block, ObjectContainer container, ClientContext context) {
        if (this.binaryBlobKeysAddedAlready == null) {
            return;
        }
        if (this.persistent()) {
            container.activate((Object)this.binaryBlobStream, 1);
            container.activate(this.binaryBlobKeysAddedAlready, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Adding key " + block.getClientKey().getURI() + " to " + this, (Throwable)new Exception("debug"));
        }
        Key key = block.getKey();
        HashSet<Key> hashSet = this.binaryBlobKeysAddedAlready;
        synchronized (hashSet) {
            if (this.binaryBlobStream == null) {
                return;
            }
            if (this.binaryBlobKeysAddedAlready.contains(key)) {
                return;
            }
            this.binaryBlobKeysAddedAlready.add(key);
            try {
                BinaryBlob.writeKey(this.binaryBlobStream, block, key);
            }
            catch (IOException e) {
                Logger.error(this, "Failed to write key to binary blob stream: " + e, e);
                this.onFailure(new FetchException(12, "Failed to write key to binary blob stream: " + e), null, container, context);
                this.binaryBlobStream = null;
                this.binaryBlobKeysAddedAlready.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean closeBinaryBlobStream(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.binaryBlobStream, 1);
            container.activate(this.binaryBlobKeysAddedAlready, 1);
        }
        if (this.binaryBlobKeysAddedAlready == null) {
            return true;
        }
        HashSet<Key> hashSet = this.binaryBlobKeysAddedAlready;
        synchronized (hashSet) {
            if (this.binaryBlobStream == null) {
                return true;
            }
            boolean triedClose = false;
            try {
                try {
                    BinaryBlob.writeEndBlob(this.binaryBlobStream);
                    this.binaryBlobStream.flush();
                    triedClose = true;
                    this.binaryBlobStream.close();
                    boolean bl = true;
                    Object var8_7 = null;
                    this.binaryBlobStream = null;
                    this.binaryBlobKeysAddedAlready.clear();
                    return bl;
                }
                catch (IOException e) {
                    Logger.error(this, "Failed to close binary blob stream: " + e, e);
                    this.onFailure(new FetchException(12, "Failed to close binary blob stream: " + e), null, container, context);
                    if (!triedClose) {
                        try {
                            this.binaryBlobStream.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    boolean bl2 = false;
                    Object var8_8 = null;
                    this.binaryBlobStream = null;
                    this.binaryBlobKeysAddedAlready.clear();
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.binaryBlobStream = null;
                this.binaryBlobKeysAddedAlready.clear();
                throw throwable;
            }
        }
    }

    boolean collectingBinaryBlob() {
        return this.binaryBlobBucket != null;
    }

    public void onExpectedMIME(String mime, ObjectContainer container, ClientContext context) {
        if (this.finalizedMetadata) {
            return;
        }
        this.expectedMIME = mime;
        if (this.persistent()) {
            container.store((Object)this);
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new ExpectedMIMEEvent(mime), container, context);
    }

    public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
        if (this.finalizedMetadata) {
            return;
        }
        this.expectedSize = size;
        if (this.persistent()) {
            container.store((Object)this);
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new ExpectedFileSizeEvent(size), container, context);
    }

    public void onFinalizedMetadata(ObjectContainer container) {
        this.finalizedMetadata = true;
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public boolean finalizedMetadata() {
        return this.finalizedMetadata;
    }

    public String expectedMIME() {
        return this.expectedMIME;
    }

    public long expectedSize() {
        return this.expectedSize;
    }

    public ClientGetCallback getClientCallback() {
        return this.clientCallback;
    }

    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        container.activate((Object)this.ctx, 1);
        this.ctx.removeFrom(container);
        container.activate((Object)this.actx, 5);
        this.actx.removeFrom(container);
        if (this.returnBucket != null) {
            container.activate((Object)this.returnBucket, 1);
            this.returnBucket.removeFrom(container);
        }
        super.removeFrom(container, context);
    }

    static {
        Logger.registerClass(ClientGetter.class);
    }
}

