/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.FECQueue;
import freenet.client.FetchException;
import freenet.client.InsertException;
import freenet.client.async.BackgroundBlockEncoder;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutter;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.HealingQueue;
import freenet.client.async.SimpleManifestPutter;
import freenet.client.async.USKManager;
import freenet.crypt.RandomSource;
import freenet.node.NodeClientCore;
import freenet.node.RequestScheduler;
import freenet.node.RequestStarterGroup;
import freenet.node.Ticker;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.api.BucketFactory;
import freenet.support.compress.RealCompressor;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentTempBucketFactory;
import java.util.Random;

public class ClientContext {
    public final transient FECQueue fecQueue;
    private transient ClientRequestScheduler sskFetchScheduler;
    private transient ClientRequestScheduler chkFetchScheduler;
    private transient ClientRequestScheduler sskInsertScheduler;
    private transient ClientRequestScheduler chkInsertScheduler;
    public final transient DBJobRunner jobRunner;
    public final transient Executor mainExecutor;
    public final transient long nodeDBHandle;
    public final transient BackgroundBlockEncoder backgroundBlockEncoder;
    public final transient RandomSource random;
    public final transient ArchiveManager archiveManager;
    public final transient PersistentTempBucketFactory persistentBucketFactory;
    public final transient BucketFactory tempBucketFactory;
    public final transient HealingQueue healingQueue;
    public final transient USKManager uskManager;
    public final transient Random fastWeakRandom;
    public final transient long bootID;
    public final transient Ticker ticker;
    public final transient FilenameGenerator fg;
    public final transient FilenameGenerator persistentFG;
    public final transient RealCompressor rc;

    public ClientContext(NodeClientCore core, FECQueue fecQueue, Executor mainExecutor, BackgroundBlockEncoder blockEncoder, ArchiveManager archiveManager, PersistentTempBucketFactory ptbf, BucketFactory tbf, HealingQueue hq, USKManager uskManager, RandomSource strongRandom, Random fastWeakRandom, Ticker ticker, FilenameGenerator fg, FilenameGenerator persistentFG, RealCompressor rc) {
        this.bootID = core.node.bootID;
        this.fecQueue = fecQueue;
        this.jobRunner = core;
        this.mainExecutor = mainExecutor;
        this.nodeDBHandle = core.node.nodeDBHandle;
        this.backgroundBlockEncoder = blockEncoder;
        this.random = strongRandom;
        this.archiveManager = archiveManager;
        this.persistentBucketFactory = ptbf;
        this.tempBucketFactory = tbf;
        if (this.tempBucketFactory == null) {
            throw new NullPointerException();
        }
        this.healingQueue = hq;
        this.uskManager = uskManager;
        this.fastWeakRandom = fastWeakRandom;
        this.ticker = ticker;
        this.fg = fg;
        this.persistentFG = persistentFG;
        this.rc = rc;
    }

    public void init(RequestStarterGroup starters) {
        this.sskFetchScheduler = starters.sskFetchScheduler;
        this.chkFetchScheduler = starters.chkFetchScheduler;
        this.sskInsertScheduler = starters.sskPutScheduler;
        this.chkInsertScheduler = starters.chkPutScheduler;
    }

    public ClientRequestScheduler getSskFetchScheduler() {
        return this.sskFetchScheduler;
    }

    public ClientRequestScheduler getChkFetchScheduler() {
        return this.chkFetchScheduler;
    }

    public ClientRequestScheduler getSskInsertScheduler() {
        return this.sskInsertScheduler;
    }

    public ClientRequestScheduler getChkInsertScheduler() {
        return this.chkInsertScheduler;
    }

    public void start(final ClientPutter inserter, final boolean earlyEncode) throws InsertException, DatabaseDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)inserter, 1);
                    try {
                        inserter.start(earlyEncode, false, container, context);
                    }
                    catch (InsertException e) {
                        inserter.client.onFailure(e, inserter, container);
                    }
                    container.deactivate((Object)inserter, 1);
                    return true;
                }
            }, 5, false);
        } else {
            inserter.start(earlyEncode, false, null, this);
        }
    }

    public void start(final ClientGetter getter) throws FetchException, DatabaseDisabledException {
        if (getter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)getter, 1);
                    try {
                        getter.start(container, context);
                    }
                    catch (FetchException e) {
                        getter.clientCallback.onFailure(e, getter, container);
                    }
                    container.deactivate((Object)getter, 1);
                    return true;
                }
            }, 5, false);
        } else {
            getter.start(null, this);
        }
    }

    public void start(final SimpleManifestPutter inserter) throws InsertException, DatabaseDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)inserter, 1);
                    try {
                        inserter.start(container, context);
                    }
                    catch (InsertException e) {
                        inserter.cb.onFailure(e, inserter, container);
                    }
                    container.deactivate((Object)inserter, 1);
                    return true;
                }
            }, 5, false);
        } else {
            inserter.start(null, this);
        }
    }

    public void start(final BaseManifestPutter inserter) throws InsertException, DatabaseDisabledException {
        if (inserter.persistent()) {
            this.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)inserter, 1);
                    try {
                        inserter.start(container, context);
                    }
                    catch (InsertException e) {
                        inserter.cb.onFailure(e, inserter, container);
                    }
                    container.deactivate((Object)inserter, 1);
                    return true;
                }
            }, 5, false);
        } else {
            inserter.start(null, this);
        }
    }

    public BucketFactory getBucketFactory(boolean persistent) {
        if (persistent) {
            return this.persistentBucketFactory;
        }
        return this.tempBucketFactory;
    }

    public RequestScheduler getFetchScheduler(boolean ssk) {
        if (ssk) {
            return this.sskFetchScheduler;
        }
        return this.chkFetchScheduler;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing ClientContext in database", new Exception("error"));
        return false;
    }
}

