/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;

public abstract class ChosenBlock {
    public final transient SendableRequestItem token;
    public final transient Key key;
    public final transient ClientKey ckey;
    public final transient boolean localRequestOnly;
    public final transient boolean cacheLocalRequests;
    public final transient boolean ignoreStore;

    public ChosenBlock(SendableRequestItem token, Key key, ClientKey ckey, boolean localRequestOnly, boolean cacheLocalRequests, boolean ignoreStore, RequestScheduler sched) {
        this.token = token;
        if (token == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.ckey = ckey;
        this.localRequestOnly = localRequestOnly;
        this.cacheLocalRequests = cacheLocalRequests;
        this.ignoreStore = ignoreStore;
    }

    public abstract boolean isPersistent();

    public abstract boolean isCancelled();

    public abstract void onFailure(LowLevelPutException var1, ClientContext var2);

    public abstract void onInsertSuccess(ClientContext var1);

    public abstract void onFailure(LowLevelGetException var1, ClientContext var2);

    public abstract void onFetchSuccess(ClientContext var1);

    public abstract short getPriority();

    public boolean send(NodeClientCore core, RequestScheduler sched) {
        ClientContext context = sched.getContext();
        return this.getSender(context).send(core, sched, context, this);
    }

    public abstract SendableRequestSender getSender(ClientContext var1);

    public void onDumped() {
        this.token.dump();
    }
}

