/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.client.async.SingleKeyListener;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import freenet.node.KeysFetchingLocally;
import freenet.node.NullSendableRequestItem;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSingleFileFetcher
extends SendableGet
implements HasKeyListener {
    final ClientKey key;
    protected boolean cancelled;
    protected boolean finished;
    final int maxRetries;
    private int retryCount;
    final FetchContext ctx;
    protected boolean deleteFetchContext;
    static final SendableRequestItem[] keys = new SendableRequestItem[]{NullSendableRequestItem.nullItem};
    long cooldownWakeupTime;

    protected BaseSingleFileFetcher(ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent, boolean deleteFetchContext) {
        super(parent);
        this.deleteFetchContext = deleteFetchContext;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Creating BaseSingleFileFetcher for " + key);
        }
        this.retryCount = 0;
        this.maxRetries = maxRetries;
        this.key = key;
        this.ctx = ctx;
        if (ctx == null) {
            throw new NullPointerException();
        }
        if (key == null) {
            throw new NullPointerException();
        }
        this.cooldownWakeupTime = -1L;
    }

    @Override
    public long countAllKeys(ObjectContainer container, ClientContext context) {
        return 1L;
    }

    @Override
    public long countSendableKeys(ObjectContainer container, ClientContext context) {
        return 1L;
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally fetching, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        if (fetching.hasKey(this.key.getNodeKey())) {
            return null;
        }
        return keys[0];
    }

    @Override
    public boolean hasValidKeys(KeysFetchingLocally fetching, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        return !fetching.hasKey(this.key.getNodeKey());
    }

    @Override
    public ClientKey getKey(Object token, ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        return this.key;
    }

    @Override
    public FetchContext getContext() {
        return this.ctx;
    }

    @Override
    public boolean isSSK() {
        return this.key instanceof ClientSSK;
    }

    protected boolean retry(ObjectContainer container, ClientContext context) {
        ++this.retryCount;
        if (this.finished) {
            return false;
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Attempting to retry... (max " + this.maxRetries + ", current " + this.retryCount + ") on " + this + " finished=" + this.finished + " cancelled=" + this.cancelled);
        }
        if (this.retryCount <= this.maxRetries || this.maxRetries == -1) {
            if (this.persistent) {
                container.store((Object)this);
            }
            if (this.retryCount % 3 == 0) {
                long now = System.currentTimeMillis();
                if (this.cooldownWakeupTime > now) {
                    Logger.error(this, "Already on the cooldown queue for " + this + " until " + TimeUtil.formatTime(this.cooldownWakeupTime - now), new Exception("error"));
                    this.unregister(container, context);
                } else {
                    if (Logger.shouldLog(4, this)) {
                        Logger.minor(this, "Adding to cooldown queue " + this);
                    }
                    if (this.persistent) {
                        container.activate((Object)this.key, 5);
                    }
                    RequestScheduler sched = context.getFetchScheduler(this.key instanceof ClientSSK);
                    this.cooldownWakeupTime = sched.queueCooldown(this.key, this, container);
                    if (this.persistent) {
                        container.deactivate((Object)this.key, 5);
                    }
                    this.unregister(container, context);
                }
            } else {
                this.unregister(container, context);
                this.reschedule(container, context);
            }
            return true;
        }
        this.unregister(container, context);
        return false;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent;
    }

    @Override
    public short getPriorityClass(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        short retval = this.parent.getPriorityClass();
        return retval;
    }

    @Override
    public boolean ignoreStore() {
        return this.ctx.ignoreStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ObjectContainer container, ClientContext context) {
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            this.cancelled = true;
        }
        if (this.persistent) {
            container.store((Object)this);
            container.activate((Object)this.key, 5);
        }
        this.unregisterAll(container, context);
    }

    public void unregisterAll(ObjectContainer container, ClientContext context) {
        this.getScheduler(context).removePendingKeys(this, false);
        super.unregister(container, context);
    }

    @Override
    public synchronized boolean isCancelled(ObjectContainer container) {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isEmpty(ObjectContainer container) {
        return this.cancelled || this.finished;
    }

    @Override
    public RequestClient getClient(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.parent, 1);
        }
        return this.parent.getClient();
    }

    @Override
    public boolean dontCache(ObjectContainer container) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
        }
        return !this.ctx.cacheLocalRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGotKey(Key key, KeyBlock block, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this, 1);
            container.activate((Object)key, 5);
            container.activate((Object)this.key, 5);
        }
        BaseSingleFileFetcher baseSingleFileFetcher = this;
        synchronized (baseSingleFileFetcher) {
            if (this.finished) {
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "onGotKey() called twice on " + this, (Throwable)new Exception("debug"));
                }
                return;
            }
            this.finished = true;
            if (this.persistent) {
                container.store((Object)this);
            }
            if (this.isCancelled(container)) {
                return;
            }
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.key == null) {
                throw new NullPointerException("Key is null on " + this);
            }
            if (!key.equals(this.key.getNodeKey())) {
                Logger.normal(this, "Got sent key " + key + " but want " + this.key + " for " + this);
                return;
            }
        }
        this.unregister(container, context);
        try {
            this.onSuccess(Key.createKeyBlock(this.key, block), false, null, container, context);
        }
        catch (KeyVerifyException e) {
            Logger.error(this, "onGotKey(" + key + "," + block + ") got " + e + " for " + this, e);
        }
        if (this.persistent) {
            container.deactivate((Object)this, 1);
            container.deactivate((Object)this.key, 1);
        }
    }

    public abstract void onSuccess(ClientKeyBlock var1, boolean var2, Object var3, ObjectContainer var4, ClientContext var5);

    @Override
    public long getCooldownWakeup(Object token, ObjectContainer container) {
        return this.cooldownWakeupTime;
    }

    @Override
    public long getCooldownWakeupByKey(Key key, ObjectContainer container) {
        return this.cooldownWakeupTime;
    }

    @Override
    public synchronized void resetCooldownTimes(ObjectContainer container) {
        this.cooldownWakeupTime = -1L;
        if (this.persistent) {
            container.store((Object)this);
        }
    }

    @Override
    public void requeueAfterCooldown(Key key, long time, ObjectContainer container, ClientContext context) {
        if (this.cooldownWakeupTime > time) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Not requeueing as deadline has not passed yet");
            }
            return;
        }
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        if (!key.equals(this.key.getNodeKey())) {
            Logger.error(this, "Got requeueAfterCooldown for wrong key: " + key + " but mine is " + this.key.getNodeKey() + " for " + this.key);
            return;
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Requeueing after cooldown " + key + " for " + this);
        }
        this.reschedule(container, context);
        if (this.persistent) {
            container.deactivate((Object)this.key, 5);
        }
    }

    public void schedule(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
            if (this.ctx.blocks != null) {
                container.activate((Object)this.ctx.blocks, 5);
            }
        }
        try {
            this.getScheduler(context).register(this, new SendableGet[]{this}, this.persistent, container, this.ctx.blocks, false);
        }
        catch (KeyListenerConstructionException e) {
            Logger.error(this, "Impossible: " + e + " on " + this, e);
        }
    }

    public void reschedule(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.ctx, 1);
            if (this.ctx.blocks != null) {
                container.activate((Object)this.ctx.blocks, 5);
            }
        }
        try {
            this.getScheduler(context).register(null, new SendableGet[]{this}, this.persistent, container, this.ctx.blocks, true);
        }
        catch (KeyListenerConstructionException e) {
            Logger.error(this, "Impossible: " + e + " on " + this, e);
        }
    }

    public SendableGet getRequest(Key key, ObjectContainer container) {
        return this;
    }

    @Override
    public Key[] listKeys(ObjectContainer container) {
        if (this.cancelled || this.finished) {
            return new Key[0];
        }
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        return new Key[]{this.key.getNodeKey()};
    }

    @Override
    public List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest request, RequestScheduler sched, ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.key, 5);
        }
        ClientKey ckey = this.key.cloneKey();
        PersistentChosenBlock block = new PersistentChosenBlock(false, request, keys[0], ckey.getNodeKey(), ckey, sched);
        return Collections.singletonList(block);
    }

    @Override
    public KeyListener makeKeyListener(ObjectContainer container, ClientContext context) {
        if (this.persistent) {
            container.activate((Object)this.key, 5);
            container.activate((Object)this.parent, 1);
            container.activate((Object)this.ctx, 1);
        }
        if (this.finished) {
            return null;
        }
        if (this.cancelled) {
            return null;
        }
        Key newKey = this.key.getNodeKey().cloneKey();
        short prio = this.parent.getPriorityClass();
        boolean dontCache = !this.ctx.cacheLocalRequests;
        SingleKeyListener ret = new SingleKeyListener(newKey, this, dontCache, prio, this.persistent);
        if (this.persistent) {
            container.deactivate((Object)this.key, 5);
            container.deactivate((Object)this.parent, 1);
            container.deactivate((Object)this.ctx, 1);
        }
        return ret;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        super.removeFrom(container, context);
        if (this.deleteFetchContext) {
            container.activate((Object)this.ctx, 1);
            this.ctx.removeFrom(container);
        }
        container.activate((Object)this.key, 5);
        this.key.removeFrom(container);
    }

    @Override
    public void preRegister(ObjectContainer container, ClientContext context, boolean toNetwork) {
        if (!toNetwork) {
            return;
        }
        boolean deactivate = false;
        if (this.persistent) {
            deactivate = !container.ext().isActive((Object)this.parent);
            container.activate((Object)this.parent, 1);
        }
        this.parent.toNetwork(container, context);
        if (deactivate) {
            container.deactivate((Object)this.parent, 1);
        }
    }
}

