/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutState;
import freenet.client.async.ContainerInserter;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.ManifestElement;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseManifestPutter
extends BaseClientPutter
implements PutCompletionCallback {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private boolean containerMode = false;
    private ContainerBuilder rootContainer;
    private PutHandler rootContainerPutHandler;
    private HashSet<PutHandler> containerPutHandlers;
    private HashMap<PutHandler, HashSet<PutHandler>> perContainerPutHandlersWaitingForMetadata;
    private HashMap<PutHandler, HashSet<PutHandler>> perContainerPutHandlersWaitingForFetchable;
    private HashMap<PutHandler, HashMap<String, Object>> putHandlersTransformMap;
    private HashMap<PutHandler, Vector<PutHandler>> putHandlersArchiveTransformMap;
    private HashMap<String, Object> putHandlersByName;
    private HashSet<PutHandler> runningPutHandlers;
    private HashSet<PutHandler> putHandlersWaitingForMetadata;
    private HashSet<PutHandler> waitingForBlockSets;
    private HashSet<PutHandler> putHandlersWaitingForFetchable;
    private FreenetURI finalURI;
    private final FreenetURI targetURI;
    private boolean finished;
    private final InsertContext ctx;
    final ClientPutCallback cb;
    private final boolean getCHKOnly;
    private boolean insertedAllFiles;
    private boolean insertedManifest;
    private final HashMap<Metadata, ClientPutState> metadataPuttersByMetadata;
    private final HashMap<Metadata, ClientPutState> metadataPuttersUnfetchable;
    private final String defaultName;
    private int numberOfFiles;
    private long totalSize;
    private boolean metadataBlockSetFinalized;
    private Metadata baseMetadata;
    private boolean hasResolvedBase;
    private static final String[] defaultDefaultNames;
    private boolean fetchable;
    private final boolean earlyEncode;
    private final DBJob runGotAllMetadata = new DBJob(){

        public boolean run(ObjectContainer container, ClientContext context) {
            try {
                context.jobRunner.removeRestartJob(this, 5, container);
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
            container.activate((Object)BaseManifestPutter.this, 1);
            BaseManifestPutter.this.innerGotAllMetadata(container, context);
            container.deactivate((Object)BaseManifestPutter.this, 1);
            return true;
        }
    };

    public BaseManifestPutter(ClientPutCallback cb, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly2, RequestClient clientContext, boolean earlyEncode) {
        super(prioClass, clientContext);
        this.defaultName = defaultName;
        this.targetURI = this.client.persistent() ? target.clone() : target;
        this.cb = cb;
        this.ctx = ctx;
        this.getCHKOnly = getCHKOnly2;
        this.earlyEncode = earlyEncode;
        this.putHandlersByName = new HashMap();
        this.runningPutHandlers = new HashSet();
        this.putHandlersWaitingForMetadata = new HashSet();
        this.putHandlersWaitingForFetchable = new HashSet();
        this.waitingForBlockSets = new HashSet();
        this.metadataPuttersByMetadata = new HashMap();
        this.metadataPuttersUnfetchable = new HashMap();
        this.containerPutHandlers = new HashSet();
        this.perContainerPutHandlersWaitingForMetadata = new HashMap();
        this.perContainerPutHandlersWaitingForFetchable = new HashMap();
        this.putHandlersTransformMap = new HashMap();
        this.putHandlersArchiveTransformMap = new HashMap();
        this.makePutHandlers(manifestElements, this.putHandlersByName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        PutHandler[] containers;
        PutHandler[] running;
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " persistence=" + this.persistent() + " containermode=" + this.containerMode);
        }
        if (this.persistent()) {
            container.activate(this.runningPutHandlers, 2);
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
            containers = this.containerMode ? this.getContainersToStart() : null;
        }
        try {
            int i;
            boolean persistent = this.persistent();
            for (i = 0; i < running.length; ++i) {
                running[i].start(container, context);
                if (persistent && !container.ext().isActive((Object)this)) {
                    container.activate((Object)this, 1);
                }
                if (logMINOR) {
                    Logger.minor(this, "Started " + i + " of " + running.length);
                }
                if (!this.isFinished()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Already finished, killing start() on " + this);
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + running.length + " PutHandler's for " + this);
            }
            if (this.containerMode) {
                for (i = 0; i < containers.length; ++i) {
                    containers[i].start(container, context);
                    if (persistent && !container.ext().isActive((Object)this)) {
                        container.activate((Object)this, 1);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Started " + i + " of " + containers.length);
                    }
                    if (!this.isFinished()) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Already finished, killing start() on " + this);
                    }
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Started " + containers.length + " PutHandler's (containers) for " + this);
                }
            }
            if (!this.containerMode && running.length == 0) {
                this.insertedAllFiles = true;
                if (this.persistent()) {
                    container.store((Object)this);
                }
                this.gotAllMetadata(container, context);
            }
        }
        catch (InsertException e) {
            BaseManifestPutter baseManifestPutter2 = this;
            synchronized (baseManifestPutter2) {
                this.finished = true;
            }
            this.cancelAndFinish(container, context);
            throw e;
        }
    }

    private PutHandler[] getContainersToStart() {
        PutHandler[] maybeStartPH = this.containerPutHandlers.toArray(new PutHandler[this.containerPutHandlers.size()]);
        ArrayList<PutHandler> phToStart = new ArrayList<PutHandler>();
        for (PutHandler ph : maybeStartPH) {
            if (!this.perContainerPutHandlersWaitingForMetadata.get(ph).isEmpty() || !this.perContainerPutHandlersWaitingForFetchable.get(ph).isEmpty()) continue;
            phToStart.add(ph);
        }
        if (maybeStartPH.length == 0) {
            phToStart.add(this.rootContainer.selfHandle);
        }
        return phToStart.toArray(new PutHandler[phToStart.size()]);
    }

    protected abstract void makePutHandlers(HashMap<String, Object> var1, HashMap<String, Object> var2);

    @Override
    public FreenetURI getURI() {
        return this.finalURI;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    private void gotAllMetadata(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.runGotAllMetadata, 1);
            try {
                context.jobRunner.queueRestartJob(this.runGotAllMetadata, 5, container, false);
                context.jobRunner.queue(this.runGotAllMetadata, 5, false);
            }
            catch (DatabaseDisabledException databaseDisabledException) {}
        } else {
            this.innerGotAllMetadata(null, context);
        }
    }

    private void innerGotAllMetadata(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Got all metadata");
        }
        HashMap<String, Object> namesToByteArrays = new HashMap<String, Object>();
        if (this.persistent()) {
            container.activate(this.putHandlersByName, Integer.MAX_VALUE);
        }
        this.namesToByteArrays(this.putHandlersByName, namesToByteArrays, container);
        if (this.defaultName != null) {
            Metadata meta = (Metadata)namesToByteArrays.get(this.defaultName);
            if (meta == null) {
                this.fail(new InsertException(1, "Default name " + this.defaultName + " does not exist", null), container, context);
                return;
            }
            namesToByteArrays.put("", meta);
        } else {
            for (int j = 0; j < defaultDefaultNames.length; ++j) {
                String name = defaultDefaultNames[j];
                Metadata meta = (Metadata)namesToByteArrays.get(name);
                if (meta == null) continue;
                namesToByteArrays.put("", meta);
                break;
            }
        }
        this.baseMetadata = Metadata.mkRedirectionManifestWithMetadata(namesToByteArrays);
        if (this.persistent()) {
            container.store((Object)this.baseMetadata);
            container.store((Object)this);
        }
        this.resolveAndStartBase(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAndStartBase(ObjectContainer container, ClientContext context) {
        SingleFileInserter metadataInserter;
        Bucket bucket = null;
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.hasResolvedBase) {
                return;
            }
        }
        try {
            if (this.persistent()) {
                container.activate((Object)this.baseMetadata, Integer.MAX_VALUE);
            }
            bucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent()), this.baseMetadata.writeToByteArray());
            if (logMINOR) {
                Logger.minor(this, "Metadata bucket is " + bucket.size() + " bytes long");
            }
        }
        catch (IOException e) {
            this.fail(new InsertException(2, e, null), container, context);
            return;
        }
        catch (MetadataUnresolvedException e) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Main metadata needs resolving: " + e);
                }
                this.resolve(e, container, context);
                if (this.persistent()) {
                    container.deactivate((Object)this.baseMetadata, 1);
                }
                return;
            }
            catch (IOException e1) {
                if (this.persistent()) {
                    container.deactivate((Object)this.baseMetadata, 1);
                }
                this.fail(new InsertException(2, e, null), container, context);
                return;
            }
            catch (InsertException e2) {
                if (this.persistent()) {
                    container.deactivate((Object)this.baseMetadata, 1);
                }
                this.fail(e2, container, context);
                return;
            }
        }
        if (bucket == null) {
            return;
        }
        BaseManifestPutter e = this;
        synchronized (e) {
            if (this.hasResolvedBase) {
                return;
            }
            this.hasResolvedBase = true;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        boolean isMetadata = true;
        ArchiveManager.ARCHIVE_TYPE archiveType = null;
        InsertBlock block = new InsertBlock(bucket, null, this.persistent() ? this.targetURI.clone() : this.targetURI);
        try {
            metadataInserter = new SingleFileInserter(this, this, block, isMetadata, this.ctx, archiveType == ArchiveManager.ARCHIVE_TYPE.ZIP, this.getCHKOnly, false, this.baseMetadata, archiveType, true, null, this.earlyEncode);
            if (logMINOR) {
                Logger.minor(this, "Inserting main metadata: " + metadataInserter + " for " + this.baseMetadata);
            }
            if (this.persistent()) {
                container.activate(this.metadataPuttersByMetadata, 2);
                container.activate(this.metadataPuttersUnfetchable, 2);
            }
            this.metadataPuttersByMetadata.put(this.baseMetadata, metadataInserter);
            this.metadataPuttersUnfetchable.put(this.baseMetadata, metadataInserter);
            if (this.persistent()) {
                container.ext().store(this.metadataPuttersByMetadata, 2);
                container.ext().store(this.metadataPuttersUnfetchable, 2);
                container.deactivate(this.metadataPuttersByMetadata, 1);
                container.deactivate(this.metadataPuttersUnfetchable, 1);
                container.deactivate((Object)this.baseMetadata, 1);
            }
            metadataInserter.start(null, container, context);
        }
        catch (InsertException e2) {
            this.fail(e2, container, context);
            return;
        }
        if (this.persistent()) {
            container.deactivate((Object)metadataInserter, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(MetadataUnresolvedException e, ObjectContainer container, ClientContext context) throws InsertException, IOException {
        Metadata[] metas = e.mustResolve;
        if (this.persistent()) {
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        for (int i = 0; i < metas.length; ++i) {
            Metadata m = metas[i];
            if (this.persistent()) {
                container.activate((Object)m, 100);
            }
            if (logMINOR) {
                Logger.minor(this, "Resolving " + m);
            }
            BaseManifestPutter baseManifestPutter = this;
            synchronized (baseManifestPutter) {
                if (this.metadataPuttersByMetadata.containsKey(m)) {
                    if (logMINOR) {
                        Logger.minor(this, "Already started insert for " + m + " in resolve() for " + metas.length + " Metadata's");
                    }
                    continue;
                }
            }
            if (m.isResolved()) {
                Logger.error(this, "Already resolved: " + m + " in resolve() - race condition???");
                if (!this.persistent()) continue;
                container.deactivate((Object)m, 1);
                continue;
            }
            try {
                Bucket b = m.toBucket(context.getBucketFactory(this.persistent()));
                InsertBlock ib = new InsertBlock(b, null, this.persistent() ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI);
                SingleFileInserter metadataInserter = new SingleFileInserter(this, this, ib, true, this.ctx, false, this.getCHKOnly, false, m, null, true, null, this.earlyEncode);
                if (logMINOR) {
                    Logger.minor(this, "Inserting subsidiary metadata: " + metadataInserter + " for " + m);
                }
                BaseManifestPutter baseManifestPutter2 = this;
                synchronized (baseManifestPutter2) {
                    this.metadataPuttersByMetadata.put(m, metadataInserter);
                }
                metadataInserter.start(null, container, context);
                if (!this.persistent()) continue;
                container.deactivate((Object)metadataInserter, 1);
                container.deactivate((Object)m, 1);
                continue;
            }
            catch (MetadataUnresolvedException e1) {
                this.resolve(e1, container, context);
                container.deactivate((Object)m, 1);
            }
        }
        if (this.persistent()) {
            container.ext().store(this.metadataPuttersByMetadata, 2);
            container.deactivate(this.metadataPuttersByMetadata, 1);
        }
    }

    private void namesToByteArrays(HashMap<String, Object> putHandlersByName, HashMap<String, Object> namesToByteArrays, ObjectContainer container) {
        for (Map.Entry<String, Object> me : putHandlersByName.entrySet()) {
            String name = me.getKey();
            Object o = me.getValue();
            if (o instanceof PutHandler) {
                PutHandler ph = (PutHandler)o;
                if (this.persistent()) {
                    container.activate((Object)ph, 1);
                }
                Metadata meta = ph.metadata;
                if (ph.metadata == null) {
                    Logger.error(this, "Metadata for " + name + " : " + ph + " is null");
                    continue;
                }
                ph.clearMetadata(container);
                if (this.persistent()) {
                    container.activate((Object)meta, 100);
                }
                Logger.minor(this, "Putting " + name);
                namesToByteArrays.put(name, meta);
                if (!logMINOR) continue;
                Logger.minor(this, "Putting PutHandler into base metadata: " + ph + " name " + name);
                continue;
            }
            if (o instanceof HashMap) {
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                namesToByteArrays.put(name, subMap);
                if (logMINOR) {
                    Logger.minor(this, "Putting hashmap into base metadata: " + name + " size " + ((HashMap)o).size() + " active = " + (container == null ? "null" : Boolean.toString(container.ext().isActive(o))));
                    Logger.minor(this, "Putting directory: " + name);
                }
                this.namesToByteArrays((HashMap)o, subMap, container);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertedAllFiles(ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Inserted all files");
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            this.insertedAllFiles = true;
            if (this.finished || this.cancelled) {
                if (logMINOR) {
                    Logger.minor(this, "Already " + (this.finished ? "finished" : "cancelled"));
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                return;
            }
            if (!this.insertedManifest) {
                if (logMINOR) {
                    Logger.minor(this, "Haven't inserted manifest");
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                return;
            }
            this.finished = true;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.complete(container, context);
    }

    private void complete(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            this.removePutHandlers(container, context);
        }
        boolean deactivateCB = false;
        if (this.persistent()) {
            deactivateCB = !container.ext().isActive((Object)this.cb);
            container.activate((Object)this.cb, 1);
        }
        this.cb.onSuccess(this, container);
        if (deactivateCB) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        this.cancelAndFinish(container, context);
        if (this.persistent()) {
            this.removePutHandlers(container, context);
        }
        if (this.persistent()) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container);
    }

    private void removePutHandlers(ObjectContainer container, ClientContext context) {
        PutHandler[] handlers;
        container.activate(this.putHandlersByName, 2);
        container.activate(this.runningPutHandlers, 2);
        container.activate(this.putHandlersWaitingForMetadata, 2);
        container.activate(this.waitingForBlockSets, 2);
        container.activate(this.putHandlersWaitingForFetchable, 2);
        this.removePutHandlersByName(container, context, this.putHandlersByName);
        this.putHandlersByName = null;
        if (!this.runningPutHandlers.isEmpty()) {
            Logger.error(this, "Running put handlers not part of putHandlersByName: " + this.runningPutHandlers.size() + " in removePutHandlers() on " + this, new Exception("error"));
            for (PutHandler handler : handlers = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still running, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.runningPutHandlers.clear();
        }
        if (!this.putHandlersWaitingForMetadata.isEmpty()) {
            Logger.error(this, "Put handlers waiting for metadata, not part of putHandlersByName: " + this.putHandlersWaitingForMetadata.size() + " in removePutHandlers() on " + this, new Exception("error"));
            for (PutHandler handler : handlers = this.putHandlersWaitingForMetadata.toArray(new PutHandler[this.putHandlersWaitingForMetadata.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for metadata, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.putHandlersWaitingForMetadata.clear();
        }
        if (!this.waitingForBlockSets.isEmpty()) {
            Logger.error(this, "Put handlers waiting for block sets, not part of putHandlersByName: " + this.waitingForBlockSets.size() + " in removePutHandlers() on " + this, new Exception("error"));
            for (PutHandler handler : handlers = this.waitingForBlockSets.toArray(new PutHandler[this.waitingForBlockSets.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for block set, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.waitingForBlockSets.clear();
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            Logger.error(this, "Put handlers waiting for fetchable, not part of putHandlersByName: " + this.putHandlersWaitingForFetchable.size() + " in removePutHandlers() on " + this, new Exception("error"));
            for (PutHandler handler : handlers = this.putHandlersWaitingForFetchable.toArray(new PutHandler[this.putHandlersWaitingForFetchable.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for fetchable, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.putHandlersWaitingForFetchable.clear();
        }
        container.delete(this.runningPutHandlers);
        container.delete(this.putHandlersWaitingForMetadata);
        container.delete(this.waitingForBlockSets);
        container.delete(this.putHandlersWaitingForFetchable);
        this.runningPutHandlers = null;
        this.putHandlersWaitingForMetadata = null;
        this.waitingForBlockSets = null;
        this.putHandlersWaitingForFetchable = null;
        container.store((Object)this);
    }

    private void removePutHandlersByName(ObjectContainer container, ClientContext context, HashMap<String, Object> putHandlersByName) {
        if (logMINOR) {
            Logger.minor(this, "removePutHandlersByName on " + this + " : map size = " + putHandlersByName.size());
        }
        for (Map.Entry<String, Object> entry : putHandlersByName.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof PutHandler) {
                PutHandler handler = (PutHandler)value;
                container.activate((Object)handler, 1);
                if (this.runningPutHandlers.remove(handler)) {
                    container.ext().store(this.runningPutHandlers, 2);
                }
                if (this.putHandlersWaitingForMetadata.remove(handler)) {
                    container.ext().store(this.putHandlersWaitingForMetadata, 2);
                }
                if (this.waitingForBlockSets.remove(handler)) {
                    container.ext().store(this.waitingForBlockSets, 2);
                }
                if (this.putHandlersWaitingForFetchable.remove(handler)) {
                    container.ext().store(this.putHandlersWaitingForFetchable, 2);
                }
                handler.removeFrom(container, context);
            } else {
                HashMap subMap = (HashMap)value;
                container.activate((Object)subMap, 2);
                this.removePutHandlersByName(container, context, subMap);
            }
            container.delete((Object)key);
        }
        putHandlersByName.clear();
        container.delete(putHandlersByName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAndFinish(ObjectContainer container, ClientContext context) {
        ClientPutState[] runningMeta;
        PutHandler[] running;
        boolean persistent = this.persistent();
        if (persistent) {
            container.activate(this.runningPutHandlers, 2);
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
        }
        if (logMINOR) {
            Logger.minor(this, "PutHandler's to cancel: " + running.length);
        }
        for (PutHandler putter : running) {
            boolean active = true;
            if (persistent && !(active = container.ext().isActive((Object)putter))) {
                container.activate((Object)putter, 1);
            }
            putter.cancel(container, context);
            if (!active) {
                container.deactivate((Object)putter, 1);
            }
            if (!persistent) continue;
            container.activate((Object)this, 1);
        }
        if (this.persistent()) {
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        BaseManifestPutter len$ = this;
        synchronized (len$) {
            runningMeta = this.metadataPuttersByMetadata.values().toArray(new ClientPutState[this.metadataPuttersByMetadata.size()]);
        }
        if (logMINOR) {
            Logger.minor(this, "Metadata putters to cancel: " + runningMeta.length);
        }
        for (ClientPutState putter : runningMeta) {
            boolean active = true;
            if (persistent && !(active = container.ext().isActive((Object)putter))) {
                container.activate((Object)putter, 1);
            }
            putter.cancel(container, context);
            if (!active) {
                container.deactivate((Object)putter, 1);
            }
            if (!persistent) continue;
            container.activate((Object)this, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished) {
                return;
            }
            if (super.cancel()) {
                return;
            }
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.fail(new InsertException(10), container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        boolean fin = false;
        ClientPutState oldState = null;
        Metadata token = (Metadata)state.getToken();
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            boolean present;
            if (this.persistent()) {
                container.activate((Object)token, 1);
            }
            if (present = this.metadataPuttersByMetadata.containsKey(token)) {
                oldState = this.metadataPuttersByMetadata.remove(token);
                if (this.persistent()) {
                    container.activate(this.metadataPuttersUnfetchable, 2);
                }
                if (this.metadataPuttersUnfetchable.containsKey(token)) {
                    this.metadataPuttersUnfetchable.remove(token);
                    if (this.persistent()) {
                        container.ext().store(this.metadataPuttersUnfetchable, 2);
                    }
                }
            }
            if (!this.metadataPuttersByMetadata.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Still running metadata putters: " + this.metadataPuttersByMetadata.size());
                }
            } else {
                Logger.minor(this, "Inserted manifest successfully on " + this + " : " + state);
                this.insertedManifest = true;
                if (this.finished) {
                    if (logMINOR) {
                        Logger.minor(this, "Already finished");
                    }
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                } else if (!this.insertedAllFiles) {
                    if (logMINOR) {
                        Logger.minor(this, "Not inserted all files");
                    }
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                } else {
                    this.finished = true;
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                    fin = true;
                }
            }
        }
        if (this.persistent()) {
            if (token != this.baseMetadata) {
                token.removeFrom(container);
            }
            container.ext().store(this.metadataPuttersByMetadata, 2);
            container.deactivate(this.metadataPuttersByMetadata, 1);
            state.removeFrom(container, context);
            if (oldState != state && oldState != null) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            }
        }
        if (fin) {
            this.complete(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        ClientPutState oldState = null;
        Metadata token = (Metadata)state.getToken();
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            boolean present;
            if (this.persistent()) {
                container.activate((Object)token, 1);
            }
            if (present = this.metadataPuttersByMetadata.containsKey(token)) {
                oldState = this.metadataPuttersByMetadata.remove(token);
                if (this.persistent()) {
                    container.activate(this.metadataPuttersUnfetchable, 2);
                }
                if (this.metadataPuttersUnfetchable.containsKey(token)) {
                    this.metadataPuttersUnfetchable.remove(token);
                    if (this.persistent()) {
                        container.ext().store(this.metadataPuttersUnfetchable);
                    }
                }
            }
        }
        if (this.persistent()) {
            if (token != this.baseMetadata) {
                token.removeFrom(container);
            }
            container.ext().store(this.metadataPuttersByMetadata, 2);
            container.deactivate(this.metadataPuttersByMetadata, 1);
            state.removeFrom(container, context);
            if (oldState != state && oldState != null) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            }
        }
        this.fail(e, container, context);
    }

    @Override
    public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
        if (state.getToken() == this.baseMetadata) {
            this.finalURI = key.getURI();
            if (logMINOR) {
                Logger.minor(this, "Got metadata key: " + this.finalURI);
            }
            if (this.persistent()) {
                container.activate((Object)this.cb, 1);
            }
            this.cb.onGeneratedURI(this.persistent() ? this.finalURI.clone() : this.finalURI, this, container);
            if (this.persistent()) {
                container.deactivate((Object)this.cb, 1);
            }
            if (this.persistent()) {
                container.store((Object)this);
            }
        } else {
            Metadata m = (Metadata)state.getToken();
            if (this.persistent()) {
                container.activate((Object)m, 2);
            }
            m.resolve(key.getURI());
            if (this.persistent()) {
                container.store((Object)m);
            }
            if (logMINOR) {
                Logger.minor(this, "Resolved " + m + " : " + key.getURI());
            }
            this.resolveAndStartBase(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
        Metadata m = (Metadata)oldState.getToken();
        if (this.persistent()) {
            container.activate((Object)m, 100);
            container.activate(this.metadataPuttersUnfetchable, 2);
            container.activate(this.metadataPuttersByMetadata, 2);
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.metadataPuttersByMetadata.containsKey(m)) {
                ClientPutState prevState = this.metadataPuttersByMetadata.get(m);
                if (prevState != oldState) {
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring transition in " + this + " for metadata putter: " + oldState + " -> " + newState + " because current for " + m + " is " + prevState);
                    }
                    container.deactivate(this.metadataPuttersUnfetchable, 1);
                    container.deactivate(this.metadataPuttersByMetadata, 1);
                    return;
                }
                if (this.persistent()) {
                    container.store((Object)newState);
                }
                this.metadataPuttersByMetadata.put(m, newState);
                if (this.persistent()) {
                    container.ext().store(this.metadataPuttersByMetadata, 2);
                }
                if (logMINOR) {
                    Logger.minor(this, "Metadata putter transition: " + oldState + " -> " + newState);
                }
                if (this.metadataPuttersUnfetchable.containsKey(m)) {
                    this.metadataPuttersUnfetchable.put(m, newState);
                    if (this.persistent()) {
                        container.ext().store(this.metadataPuttersUnfetchable, 2);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Unfetchable metadata putter transition: " + oldState + " -> " + newState);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Transition: " + oldState + " -> " + newState);
                }
            } else {
                Logger.error(this, "onTransition() but metadataPuttersByMetadata does not contain metadata tag " + m + " for " + oldState + " should -> " + newState);
            }
        }
        if (this.persistent()) {
            container.deactivate((Object)m, 100);
            container.deactivate(this.metadataPuttersUnfetchable, 2);
            container.deactivate(this.metadataPuttersByMetadata, 2);
        }
    }

    @Override
    public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
    }

    @Override
    public void notifyClients(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.minSuccessBlocks, this.blockSetFinalized), container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            this.metadataBlockSetFinalized = true;
            if (this.persistent()) {
                container.activate(this.waitingForBlockSets, 2);
            }
            if (!this.waitingForBlockSets.isEmpty()) {
                if (this.persistent()) {
                    container.store((Object)this);
                    container.deactivate(this.waitingForBlockSets, 1);
                }
                return;
            }
        }
        this.blockSetFinalized(container, context);
        if (this.persistent()) {
            container.store((Object)this);
            container.deactivate(this.waitingForBlockSets, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockSetFinalized(ObjectContainer container, ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (!this.metadataBlockSetFinalized) {
                return;
            }
            if (this.persistent()) {
                container.activate(this.waitingForBlockSets, 2);
            }
            if (this.waitingForBlockSets.isEmpty()) {
                if (this.persistent()) {
                    container.deactivate(this.waitingForBlockSets, 1);
                }
                return;
            }
        }
        if (this.persistent()) {
            container.deactivate(this.waitingForBlockSets, 1);
        }
        super.blockSetFinalized(container, context);
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public int countFiles() {
        return this.numberOfFiles;
    }

    public long totalSize() {
        return this.totalSize;
    }

    @Override
    public void onMajorProgress(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent()) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.cb);
            if (deactivate) {
                container.activate((Object)this.cb, 1);
            }
        }
        this.cb.onMajorProgress(container);
        if (deactivate) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    protected void onFetchable(PutHandler handler, ObjectContainer container) {
        if (this.persistent()) {
            container.activate(this.putHandlersWaitingForFetchable, 2);
            container.activate(this.metadataPuttersUnfetchable, 2);
        }
        if (this.checkFetchable(handler)) {
            if (this.persistent()) {
                container.ext().store(this.putHandlersWaitingForMetadata, 2);
                container.store((Object)this);
                container.deactivate(this.putHandlersWaitingForFetchable, 1);
                container.deactivate(this.metadataPuttersUnfetchable, 1);
                container.activate((Object)this.cb, 1);
            }
            this.cb.onFetchable(this, container);
            if (this.persistent()) {
                container.deactivate((Object)this.cb, 1);
            }
        } else if (this.persistent()) {
            container.deactivate(this.putHandlersWaitingForFetchable, 1);
            container.deactivate(this.metadataPuttersUnfetchable, 1);
        }
    }

    private synchronized boolean checkFetchable(PutHandler handler) {
        this.putHandlersWaitingForFetchable.remove(handler);
        if (this.fetchable) {
            return false;
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            return false;
        }
        if (!this.hasResolvedBase) {
            return false;
        }
        if (!this.metadataPuttersUnfetchable.isEmpty()) {
            return false;
        }
        this.fetchable = true;
        return true;
    }

    @Override
    public void onFetchable(ClientPutState state, ObjectContainer container) {
        Metadata m = (Metadata)state.getToken();
        if (this.persistent()) {
            container.activate((Object)m, 100);
            container.activate(this.metadataPuttersUnfetchable, 2);
            container.activate(this.putHandlersWaitingForFetchable, 2);
        }
        if (this.checkFetchable(m)) {
            if (this.persistent()) {
                container.ext().store(this.metadataPuttersUnfetchable, 2);
                container.store((Object)this);
                container.activate((Object)this.cb, 1);
            }
            this.cb.onFetchable(this, container);
            if (this.persistent()) {
                container.deactivate((Object)this.cb, 1);
            }
        }
        if (this.persistent()) {
            container.deactivate(this.metadataPuttersUnfetchable, 1);
            container.deactivate(this.putHandlersWaitingForFetchable, 1);
        }
    }

    private synchronized boolean checkFetchable(Metadata m) {
        this.metadataPuttersUnfetchable.remove(m);
        if (!this.metadataPuttersUnfetchable.isEmpty()) {
            return false;
        }
        if (this.fetchable) {
            return false;
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            return false;
        }
        this.fetchable = true;
        return true;
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    @Override
    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        ClientPutState sfi;
        Metadata meta;
        if (this.putHandlersByName != null) {
            Logger.error(this, "Put handlers list still present in removeFrom() on " + this);
            this.removePutHandlers(container, context);
        }
        if (this.finalURI != null) {
            container.activate((Object)this.finalURI, 5);
            this.finalURI.removeFrom(container);
        }
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.activate(this.metadataPuttersByMetadata, 2);
        container.activate(this.metadataPuttersUnfetchable, 2);
        ArrayList<Metadata> metas = null;
        if (!this.metadataPuttersByMetadata.isEmpty()) {
            Logger.error(this, "Metadata putters by metadata not empty in removeFrom() on " + this);
            for (Map.Entry entry : this.metadataPuttersByMetadata.entrySet()) {
                meta = (Metadata)entry.getKey();
                container.activate((Object)meta, 1);
                sfi = (ClientPutState)entry.getValue();
                container.activate((Object)sfi, 1);
                this.metadataPuttersUnfetchable.remove(meta);
                Logger.error(this, "Metadata putters not empty: " + sfi + " for " + this);
                sfi.cancel(container, context);
                sfi.removeFrom(container, context);
                if (metas == null) {
                    metas = new ArrayList<Metadata>();
                }
                metas.add(meta);
            }
        }
        if (!this.metadataPuttersUnfetchable.isEmpty()) {
            Logger.error(this, "Metadata putters unfetchable by metadata not empty in removeFrom() on " + this);
            for (Map.Entry entry : this.metadataPuttersByMetadata.entrySet()) {
                meta = (Metadata)entry.getKey();
                container.activate((Object)meta, 1);
                sfi = (ClientPutState)entry.getValue();
                container.activate((Object)sfi, 1);
                this.metadataPuttersUnfetchable.remove(meta);
                Logger.error(this, "Metadata putters unfetchable not empty: " + sfi + " for " + this);
                sfi.cancel(container, context);
                sfi.removeFrom(container, context);
            }
        }
        if (metas != null) {
            for (Metadata metadata : metas) {
                if (metadata == this.baseMetadata) continue;
                container.activate((Object)metadata, 1);
                metadata.removeFrom(container);
            }
        }
        this.metadataPuttersByMetadata.clear();
        this.metadataPuttersUnfetchable.clear();
        container.delete(this.metadataPuttersByMetadata);
        container.delete(this.metadataPuttersUnfetchable);
        if (this.baseMetadata != null) {
            container.activate((Object)this.baseMetadata, 1);
            this.baseMetadata.removeFrom(container);
        }
        container.activate((Object)this.runGotAllMetadata, 1);
        container.delete((Object)this.runGotAllMetadata);
        super.removeFrom(container, context);
    }

    public void objectOnUpdate(ObjectContainer container) {
        if (logDEBUG) {
            Logger.debug(this, "Updating " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), new Exception("debug"));
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "Storing " + this + " when already finished!", new Exception("error"));
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), new Exception("debug"));
        }
        return true;
    }

    private void maybeStartParentContainer(PutHandler containerHandle2, ObjectContainer container, ClientContext context) throws InsertException {
        if (this.perContainerPutHandlersWaitingForMetadata.get(containerHandle2).isEmpty() && this.perContainerPutHandlersWaitingForFetchable.get(containerHandle2).isEmpty()) {
            containerHandle2.start(container, context);
        }
    }

    protected final ClientMetadata guessMime(String name, ManifestElement me) {
        return this.guessMime(name, me.mimeOverride);
    }

    protected final ClientMetadata guessMime(String name, String mimetype) {
        String mimeType = mimetype;
        if (mimeType == null) {
            mimeType = DefaultMIMETypes.guessMIMEType(name, true);
        }
        ClientMetadata cm = mimeType == null || mimeType.equals("application/octet-stream") ? null : new ClientMetadata(mimeType);
        return cm;
    }

    protected final void addRedirectNoMime(String name, ManifestElement me, HashMap<String, Object> putHandlersByName2) {
        this.addRedirect(name, me, null, putHandlersByName2);
    }

    protected final void addRedirect(String name, ManifestElement me, HashMap<String, Object> putHandlersByName2) {
        this.addRedirect(name, me, this.guessMime(name, me), putHandlersByName2);
    }

    protected final void addRedirect(String name, ManifestElement me, ClientMetadata cm, HashMap<String, Object> putHandlersByName2) {
        PutHandler ph;
        if (this.containerMode) {
            throw new IllegalStateException("You can not add freeform elements in container mode!");
        }
        Bucket data = me.data;
        if (me.targetURI != null) {
            ph = new PutHandler(this, name, me.targetURI, cm);
        } else {
            ph = new PutHandler(this, name, data, cm, this.getCHKOnly);
            this.runningPutHandlers.add(ph);
            this.putHandlersWaitingForMetadata.add(ph);
            this.putHandlersWaitingForFetchable.add(ph);
            if (logMINOR) {
                Logger.minor(this, "Inserting separately as PutHandler: " + name + " : " + ph + " persistent=" + ph.persistent() + ":" + ph.persistent + " " + this.persistent());
            }
            ++this.numberOfFiles;
            this.totalSize += data.size();
        }
        putHandlersByName2.put(name, ph);
    }

    public ContainerBuilder makeArchive() {
        return new ContainerBuilder(false, null, null, true);
    }

    protected ContainerBuilder getRootContainer() {
        if (!this.containerMode) {
            this.containerMode = true;
            this.rootContainer = new ContainerBuilder(true);
            this.putHandlersByName = null;
        }
        return this.rootContainer;
    }

    static {
        Logger.registerClass(BaseManifestPutter.class);
        defaultDefaultNames = new String[]{"index.html", "index.htm", "default.html", "default.htm"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ContainerBuilder {
        private final HashMap<String, Object> rootDir;
        private HashMap<String, Object> currentDir;
        private final PutHandler selfHandle;
        private final Stack<HashMap<String, Object>> dirStack;

        private ContainerBuilder(boolean isRoot) {
            this(isRoot, null, null, false);
        }

        private ContainerBuilder(PutHandler parent, String name) {
            this(false, parent, name, false);
        }

        private ContainerBuilder(boolean isRoot, PutHandler parent, String name, boolean isArchive) {
            if (BaseManifestPutter.this.putHandlersByName != null && BaseManifestPutter.this.putHandlersByName.size() > 0) {
                throw new IllegalStateException("You can not add containers in free form mode!");
            }
            this.dirStack = new Stack();
            this.rootDir = new HashMap();
            this.selfHandle = new PutHandler(BaseManifestPutter.this, parent, name, this.rootDir, isRoot ? BaseManifestPutter.this.targetURI : FreenetURI.EMPTY_CHK_URI, null, BaseManifestPutter.this.getCHKOnly, isArchive);
            this.currentDir = this.rootDir;
            if (isRoot) {
                BaseManifestPutter.this.rootContainerPutHandler = this.selfHandle;
            } else {
                BaseManifestPutter.this.containerPutHandlers.add(this.selfHandle);
            }
            BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.put(this.selfHandle, new HashSet());
            BaseManifestPutter.this.perContainerPutHandlersWaitingForFetchable.put(this.selfHandle, new HashSet());
            if (isArchive) {
                BaseManifestPutter.this.putHandlersArchiveTransformMap.put(this.selfHandle, new Vector());
            }
        }

        public ContainerBuilder makeSubContainer(String name) {
            ContainerBuilder subCon = new ContainerBuilder(this.selfHandle, name);
            this.currentDir.put(name, subCon.selfHandle);
            BaseManifestPutter.this.putHandlersTransformMap.put(subCon.selfHandle, this.currentDir);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForFetchable.get(this.selfHandle)).add(subCon.selfHandle);
            return subCon;
        }

        public void makeSubDirCD(String name) {
            this.currentDir = this.makeSubDir(this.currentDir, name);
        }

        private HashMap<String, Object> makeSubDir(HashMap<String, Object> parentDir, String name) {
            HashMap<String, Object> newDir = new HashMap<String, Object>();
            parentDir.put(name, newDir);
            return newDir;
        }

        public void addItem(String name, String nameInArchive, String mimeOverride, Bucket data) {
            this.addItem(name, nameInArchive, mimeOverride, data, false);
        }

        public void addItem(String name, String nameInArchive, String mimeOverride, Bucket data, boolean isDefaultDoc) {
            ManifestElement element = new ManifestElement(name, nameInArchive, data, mimeOverride, data.size());
            this.addElement(name, element, isDefaultDoc);
        }

        public void addRedirect(String name, String mimeOverride, FreenetURI targetURI2) {
            this.addRedirect(name, mimeOverride, targetURI2, false);
        }

        public void addRedirect(String name, String mimeOverride, FreenetURI targetURI2, boolean isDefaultDoc) {
            ManifestElement element = new ManifestElement(name, targetURI2, mimeOverride);
            this.addElement(name, element, isDefaultDoc);
        }

        public void addExternal(String name, String mimeOverride, Bucket data) {
            this.addExternal(name, mimeOverride, data, false);
        }

        public void addExternal(String name, String mimeOverride, Bucket data, boolean isDefaultDoc) {
            PutHandler ph = new PutHandler(BaseManifestPutter.this, this.selfHandle, name, data, BaseManifestPutter.this.guessMime(name, mimeOverride), BaseManifestPutter.this.getCHKOnly);
            BaseManifestPutter.this.runningPutHandlers.add(ph);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.selfHandle)).add(ph);
            BaseManifestPutter.this.putHandlersTransformMap.put(ph, this.currentDir);
        }

        private void addElement(String name, ManifestElement element, boolean isDefaultDoc) {
            this.currentDir.put(name, element);
            if (isDefaultDoc) {
                this.currentDir.put("", element);
            }
        }

        public void addArchiveItem(ContainerBuilder archive, String name, String nameInArchive, String mimeTypeOverride, Bucket data) {
            this.addArchiveItem(archive, name, nameInArchive, mimeTypeOverride, data, false);
        }

        public void addArchiveItem(ContainerBuilder archive, String name, String nameInArchive, String mimeTypeOverride, Bucket data, boolean isDefaultDoc) {
            archive.addItem(name, nameInArchive, mimeTypeOverride, data, isDefaultDoc);
            PutHandler ph = new PutHandler(BaseManifestPutter.this, this.selfHandle, name, nameInArchive, FreenetURI.EMPTY_CHK_URI, BaseManifestPutter.this.guessMime(name, mimeTypeOverride));
            BaseManifestPutter.this.putHandlersTransformMap.put(ph, this.currentDir);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForFetchable.get(this.selfHandle)).add(archive.selfHandle);
            ((Vector)BaseManifestPutter.this.putHandlersArchiveTransformMap.get(archive.selfHandle)).add(ph);
        }

        public void pushCurrentDir() {
            this.dirStack.push(this.currentDir);
        }

        public void popCurrentDir() {
            this.currentDir = this.dirStack.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PutHandler
    extends BaseClientPutter
    implements PutCompletionCallback {
        private ClientPutState origSFI;
        private ClientPutState currentState;
        private ClientMetadata cm;
        private Metadata metadata;
        private String targetInArchive;
        private final String name;
        private final boolean persistent;
        private final PutHandler parentPutHandler;
        private final boolean isContainer;
        private final boolean isArchive;

        protected PutHandler(BaseManifestPutter smp, String name, Bucket data, ClientMetadata cm, boolean getCHKOnly) {
            this(smp, null, name, data, cm, getCHKOnly);
        }

        protected PutHandler(BaseManifestPutter smp, PutHandler parent, String name, Bucket data, ClientMetadata cm, boolean getCHKOnly) {
            super(smp.priorityClass, smp.client);
            this.persistent = BaseManifestPutter.this.persistent();
            this.cm = cm;
            this.name = name;
            InsertBlock block = new InsertBlock(data, cm, this.persistent() ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI);
            this.origSFI = new SingleFileInserter(this, this, block, false, BaseManifestPutter.this.ctx, false, getCHKOnly, true, null, null, false, null, BaseManifestPutter.this.earlyEncode);
            this.metadata = null;
            this.parentPutHandler = parent;
            this.isContainer = false;
            this.isArchive = false;
        }

        protected PutHandler(BaseManifestPutter smp, PutHandler parent, String name, HashMap<String, Object> data, FreenetURI insertURI, ClientMetadata cm, boolean getCHKOnly, boolean isArchive2) {
            super(smp.priorityClass, smp.client);
            this.persistent = BaseManifestPutter.this.persistent();
            this.cm = cm;
            this.name = name;
            this.origSFI = new ContainerInserter(this, this, data, this.persistent ? insertURI.clone() : insertURI, BaseManifestPutter.this.ctx, false, getCHKOnly, false, null, ArchiveManager.ARCHIVE_TYPE.TAR, false, BaseManifestPutter.this.earlyEncode);
            this.metadata = null;
            this.parentPutHandler = parent;
            this.isContainer = true;
            this.isArchive = isArchive2;
        }

        protected PutHandler(BaseManifestPutter smp, String name, FreenetURI target, ClientMetadata cm) {
            this(smp, null, name, name, target, cm);
        }

        protected PutHandler(BaseManifestPutter smp, PutHandler parent, String name, String targetInArchive2, FreenetURI target, ClientMetadata cm) {
            Metadata m;
            super(smp.getPriorityClass(), smp.client);
            this.persistent = BaseManifestPutter.this.persistent();
            this.cm = cm;
            this.name = name;
            this.metadata = m = new Metadata(0, null, null, target, cm);
            if (logMINOR) {
                Logger.minor(this, "Simple redirect metadata: " + m);
            }
            this.origSFI = null;
            this.parentPutHandler = parent;
            this.isContainer = false;
            this.isArchive = false;
            this.targetInArchive = targetInArchive2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ObjectContainer container, ClientContext context) throws InsertException {
            ClientPutState sfi;
            if (logDEBUG) {
                Logger.debug(this, "Starting a PutHandler for '" + this.name + "' (isRootContainer=" + (this == BaseManifestPutter.this.rootContainerPutHandler) + ", isArchive=" + this.isArchive + ") " + this);
            }
            if (this.origSFI == null) {
                Logger.error(this, "origSFI is null on start(), should be impossible", new Exception("debug"));
                return;
            }
            if (this.metadata != null) {
                Logger.error(this, "metdata=" + this.metadata + " on start(), should be impossible", new Exception("debug"));
                return;
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.currentState = sfi = this.origSFI;
                this.origSFI = null;
            }
            if (this.persistent) {
                container.activate((Object)sfi, 1);
                container.store((Object)this);
            }
            sfi.schedule(container, context);
            if (this.persistent) {
                container.deactivate((Object)sfi, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
            }
            ClientPutState oldState = null;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.cancelled) {
                    return;
                }
                super.cancel();
                oldState = this.currentState;
            }
            if (this.persistent()) {
                container.store((Object)this);
                if (oldState != null) {
                    container.activate((Object)oldState, 1);
                }
            }
            if (oldState != null) {
                oldState.cancel(container, context);
            }
            this.onFailure(new InsertException(10), null, container, context);
        }

        @Override
        public FreenetURI getURI() {
            return null;
        }

        @Override
        public boolean isFinished() {
            if (logMINOR) {
                Logger.minor(this, "Finished " + this, (Throwable)new Exception("debug"));
            }
            return BaseManifestPutter.this.finished || this.cancelled || BaseManifestPutter.this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            if (logMINOR) {
                Logger.minor(this, "Completed '" + this.name + "' " + this);
            }
            if (this.isArchive) {
                Vector phv = (Vector)BaseManifestPutter.this.putHandlersArchiveTransformMap.get(this);
                for (PutHandler ph : phv) {
                    ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForFetchable.get(ph.parentPutHandler)).remove(this);
                    try {
                        BaseManifestPutter.this.maybeStartParentContainer(ph.parentPutHandler, container, context);
                    }
                    catch (InsertException e) {
                        BaseManifestPutter.this.fail(new InsertException(3, e, null), container, context);
                        return;
                    }
                }
                return;
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
                container.activate((Object)BaseManifestPutter.this.runningPutHandlers, 2);
            }
            BaseManifestPutter.this.onFetchable(this, container);
            boolean insertedAllFiles = true;
            BaseClientPutter baseClientPutter = this;
            synchronized (baseClientPutter) {
                oldState = this.currentState;
                this.currentState = null;
            }
            baseClientPutter = BaseManifestPutter.this;
            synchronized (baseClientPutter) {
                if (this.persistent) {
                    container.store((Object)this);
                }
                BaseManifestPutter.this.runningPutHandlers.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)BaseManifestPutter.this.runningPutHandlers, 2);
                    container.activate((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 2);
                }
                if (BaseManifestPutter.this.putHandlersWaitingForMetadata.contains(this)) {
                    BaseManifestPutter.this.putHandlersWaitingForMetadata.remove(this);
                    container.ext().store((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 2);
                    Logger.error(this, "PutHandler '" + this.name + "' was in waitingForMetadata in onSuccess() on " + this + " for " + BaseManifestPutter.this);
                }
                if (this.persistent) {
                    container.deactivate((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 1);
                    container.activate((Object)BaseManifestPutter.this.waitingForBlockSets, 2);
                }
                if (BaseManifestPutter.this.waitingForBlockSets.contains(this)) {
                    BaseManifestPutter.this.waitingForBlockSets.remove(this);
                    container.store((Object)BaseManifestPutter.this.waitingForBlockSets);
                    Logger.error(this, "PutHandler was in waitingForBlockSets in onSuccess() on " + this + " for " + BaseManifestPutter.this);
                }
                if (this.persistent) {
                    container.deactivate((Object)BaseManifestPutter.this.waitingForBlockSets, 1);
                    container.deactivate((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 1);
                    container.activate((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 2);
                }
                if (BaseManifestPutter.this.putHandlersWaitingForFetchable.contains(this)) {
                    BaseManifestPutter.this.putHandlersWaitingForFetchable.remove(this);
                    container.ext().store((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 2);
                    if (logMINOR) {
                        Logger.minor(this, "PutHandler was in waitingForFetchable in onSuccess() on " + this + " for " + BaseManifestPutter.this);
                    }
                }
                if (this.persistent) {
                    container.deactivate((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 1);
                }
                if (!BaseManifestPutter.this.runningPutHandlers.isEmpty()) {
                    if (logMINOR) {
                        Logger.minor(this, "Running put handlers: " + BaseManifestPutter.this.runningPutHandlers.size());
                        for (PutHandler o : BaseManifestPutter.this.runningPutHandlers) {
                            boolean activated = true;
                            if (this.persistent && !(activated = container.ext().isActive((Object)o))) {
                                container.activate((Object)o, 1);
                            }
                            Logger.minor(this, "Still running: " + o);
                            if (activated) continue;
                            container.deactivate((Object)o, 1);
                        }
                    }
                    insertedAllFiles = false;
                }
            }
            if (this.persistent) {
                if (oldState != null && oldState != state) {
                    container.activate((Object)oldState, 1);
                    oldState.removeFrom(container, context);
                } else if (state != null) {
                    state.removeFrom(container, context);
                }
            }
            if (insertedAllFiles) {
                BaseManifestPutter.this.insertedAllFiles(container, context);
            }
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this.runningPutHandlers, 1);
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                oldState = this.currentState;
                this.currentState = null;
            }
            if (oldState != null && oldState != state && this.persistent) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            } else if (state != null && this.persistent) {
                state.removeFrom(container, context);
            }
            if (logMINOR) {
                Logger.minor(this, "Failed: " + this + " - " + e, (Throwable)e);
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.fail(e, container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key + ") for " + this);
            }
            System.out.println("Got a URI: " + key.getURI().toString(false, false) + " for " + this);
            if (this.isArchive) {
                FreenetURI archiveURI = key.getURI();
                Vector phv = (Vector)BaseManifestPutter.this.putHandlersArchiveTransformMap.get(this);
                for (PutHandler ph : phv) {
                    HashMap hm = (HashMap)BaseManifestPutter.this.putHandlersTransformMap.get(ph);
                    ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForFetchable.get(ph.parentPutHandler)).remove(this);
                    if (ph.targetInArchive == null) {
                        throw new NullPointerException();
                    }
                    Metadata m = new Metadata(0, null, null, archiveURI.setMetaString(new String[]{ph.targetInArchive}), this.cm);
                    hm.put(ph.name, m);
                    BaseManifestPutter.this.putHandlersTransformMap.remove(ph);
                }
                return;
            }
            if (this.metadata == null) {
                if (this.persistent) {
                    container.activate((Object)key, 5);
                    container.activate((Object)BaseManifestPutter.this, 1);
                }
                Metadata m = new Metadata(0, null, null, key.getURI(), this.cm);
                this.onMetadata(m, null, container, context);
                if (this.persistent) {
                    container.deactivate((Object)BaseManifestPutter.this, 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
            if (newState == null) {
                throw new NullPointerException();
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.currentState == oldState) {
                    this.currentState = newState;
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
                    }
                    return;
                }
                Logger.error(this, "Ignoring onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Assigning metadata: " + m + " for '" + this.name + "' " + this + " from " + state + " persistent=" + this.persistent);
            }
            if (this.metadata != null) {
                Logger.error(this, "Reassigning metadata", new Exception("debug"));
                return;
            }
            this.metadata = m;
            if (this.isContainer) {
                throw new IllegalStateException();
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
                container.activate((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 2);
            }
            boolean allMetadatas = false;
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                BaseManifestPutter.this.putHandlersWaitingForMetadata.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 2);
                    container.store((Object)this);
                }
                if (!(allMetadatas = BaseManifestPutter.this.putHandlersWaitingForMetadata.isEmpty()) && logMINOR) {
                    Logger.minor(this, "Still waiting for metadata: " + BaseManifestPutter.this.putHandlersWaitingForMetadata.size());
                }
            }
            if (allMetadatas) {
                BaseManifestPutter.this.gotAllMetadata(container, context);
            } else {
                try {
                    byte[] buf = m.writeToByteArray();
                    if (buf.length > Short.MAX_VALUE) {
                        throw new MetadataUnresolvedException(new Metadata[]{m}, "Too big");
                    }
                }
                catch (MetadataUnresolvedException e) {
                    try {
                        BaseManifestPutter.this.resolve(e, container, context);
                    }
                    catch (IOException e1) {
                        BaseManifestPutter.this.fail(new InsertException(2, e1, null), container, context);
                        return;
                    }
                    catch (InsertException e1) {
                        BaseManifestPutter.this.fail(e1, container, context);
                    }
                }
            }
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 1);
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void addBlock(ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.addBlock(container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void addBlocks(int num, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.addBlocks(num, container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void completedBlock(boolean dontNotify, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.completedBlock(dontNotify, container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void failedBlock(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.failedBlock(container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void fatallyFailedBlock(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.fatallyFailedBlock(container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void addMustSucceedBlocks(int blocks, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.addMustSucceedBlocks(blocks, container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void notifyClients(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.notifyClients(container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
                container.activate((Object)BaseManifestPutter.this.waitingForBlockSets, 2);
            }
            boolean allBlockSets = false;
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                BaseManifestPutter.this.waitingForBlockSets.remove(this);
                if (this.persistent) {
                    container.store((Object)BaseManifestPutter.this.waitingForBlockSets);
                }
                allBlockSets = BaseManifestPutter.this.waitingForBlockSets.isEmpty();
            }
            if (allBlockSets) {
                BaseManifestPutter.this.blockSetFinalized(container, context);
            }
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this.waitingForBlockSets, 1);
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onMajorProgress(ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.onMajorProgress(container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onFetchable(ClientPutState state, ObjectContainer container) {
            if (logMINOR) {
                Logger.minor(this, "onFetchable " + this, (Throwable)new Exception("debug"));
            }
            if (this.isArchive) {
                return;
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.onFetchable(this, container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        }

        public void clearMetadata(ObjectContainer container) {
            this.metadata = null;
            if (this.persistent) {
                container.store((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFrom(ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            ClientPutState oldSFI;
            if (logMINOR) {
                Logger.minor(this, "Removing " + this);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                oldSFI = this.origSFI;
                oldState = this.currentState;
                this.origSFI = null;
                this.currentState = null;
            }
            if (oldSFI != null) {
                Logger.error(this, "origSFI is set in removeFrom() on " + this + " for " + BaseManifestPutter.this, new Exception("debug"));
                container.activate((Object)oldSFI, 1);
                oldSFI.cancel(container, context);
                oldSFI.removeFrom(container, context);
                if (oldState == oldSFI) {
                    oldState = null;
                }
            }
            if (oldState != null) {
                Logger.error(this, "currentState is set in removeFrom() on " + this + " for " + BaseManifestPutter.this, new Exception("debug"));
                container.activate((Object)oldState, 1);
                oldState.cancel(container, context);
                oldState.removeFrom(container, context);
            }
            if (this.cm != null) {
                container.activate((Object)this.cm, 5);
                this.cm.removeFrom(container);
            }
            if (this.metadata != null) {
                Logger.normal(this, "Metadata is set in removeFrom() on " + this + " for " + BaseManifestPutter.this);
                container.activate((Object)this.metadata, 1);
                this.metadata.removeFrom(container);
            }
            super.removeFrom(container, context);
        }

        public boolean objectCanNew(ObjectContainer container) {
            if (this.cancelled) {
                Logger.error(this, "Storing " + this + " when already cancelled!", new Exception("error"));
                return false;
            }
            if (logMINOR) {
                Logger.minor(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
            }
            return true;
        }

        public String toString() {
            if (logDEBUG) {
                return super.toString() + "{Name=" + this.name + ", isRootContainer=" + (this == BaseManifestPutter.this.rootContainerPutHandler) + ", isContainer=" + this.isContainer + ", isArchive=" + this.isArchive + '}';
            }
            return super.toString();
        }

        @Override
        protected void innerToNetwork(ObjectContainer container, ClientContext context) {
        }
    }
}

