/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.async.BackgroundBlockEncoderTag;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.Encodeable;
import freenet.client.async.SingleBlockInserter;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public class BackgroundBlockEncoder
implements PrioRunnable {
    private final ArrayList<SoftReference<Encodeable>> queue;
    private ClientContext context;
    static final int JOBS_PER_SLOT = 1;
    private DBJob runner = new DBJob(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean run(ObjectContainer container, ClientContext context) {
            Query query = container.query();
            query.constrain(BackgroundBlockEncoderTag.class);
            query.descend("nodeDBHandle").constrain((Object)context.nodeDBHandle);
            query.descend("priority").orderAscending();
            query.descend("addedTime").orderAscending();
            ObjectSet results = query.execute();
            for (int x = 0; x < 1 && results.hasNext(); ++x) {
                BackgroundBlockEncoderTag tag = (BackgroundBlockEncoderTag)results.next();
                try {
                    Encodeable sbi = tag.inserter;
                    if (sbi == null) continue;
                    container.activate((Object)sbi, 1);
                    sbi.tryEncode(container, context);
                    container.deactivate((Object)sbi, 1);
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                    continue;
                }
                finally {
                    container.delete((Object)tag);
                }
            }
            if (results.hasNext()) {
                BackgroundBlockEncoder.this.runPersistentQueue(context);
            }
            return true;
        }
    };

    public BackgroundBlockEncoder() {
        this.queue = new ArrayList();
    }

    public void setContext(ClientContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Encodeable sbi, ObjectContainer container, ClientContext context) {
        if (sbi.persistent()) {
            this.queuePersistent(sbi, container, context);
            this.runPersistentQueue(context);
        } else {
            SoftReference<Encodeable> ref = new SoftReference<Encodeable>(sbi);
            BackgroundBlockEncoder backgroundBlockEncoder = this;
            synchronized (backgroundBlockEncoder) {
                this.queue.add(ref);
                Logger.minor(this, "Queueing encode of " + sbi);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(SingleBlockInserter[] sbis, ObjectContainer container, ClientContext context) {
        SingleBlockInserter inserter;
        int i;
        BackgroundBlockEncoder backgroundBlockEncoder = this;
        synchronized (backgroundBlockEncoder) {
            for (i = 0; i < sbis.length; ++i) {
                inserter = sbis[i];
                if (inserter == null || inserter.isCancelled(container) || inserter.resultingURI != null || inserter.persistent()) continue;
                Logger.minor(this, "Queueing encode of " + inserter);
                SoftReference<SingleBlockInserter> ref = new SoftReference<SingleBlockInserter>(inserter);
                this.queue.add(ref);
            }
            this.notifyAll();
        }
        boolean anyPersistent = false;
        for (i = 0; i < sbis.length; ++i) {
            inserter = sbis[i];
            if (inserter == null || inserter.isCancelled(container) || inserter.resultingURI != null || !inserter.persistent()) continue;
            anyPersistent = true;
            this.queuePersistent(inserter, container, context);
        }
        if (anyPersistent) {
            this.runPersistentQueue(context);
        }
    }

    public void runPersistentQueue(ClientContext context) {
        try {
            context.jobRunner.queue(this.runner, 3, true);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    private void queuePersistent(Encodeable sbi, ObjectContainer container, ClientContext context) {
        BackgroundBlockEncoderTag tag = new BackgroundBlockEncoderTag(sbi, sbi.getPriorityClass(container), context);
        container.store((Object)tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            Encodeable sbi = null;
            BackgroundBlockEncoder backgroundBlockEncoder = this;
            synchronized (backgroundBlockEncoder) {
                SoftReference<Encodeable> ref;
                while (this.queue.isEmpty()) {
                    try {
                        this.wait(100000L);
                    }
                    catch (InterruptedException e) {}
                }
                while (!this.queue.isEmpty() && (sbi = (ref = this.queue.remove(this.queue.size() - 1)).get()) == null) {
                }
            }
            Logger.minor(this, "Encoding " + sbi);
            sbi.tryEncode(null, this.context);
        }
    }

    public int getPriority() {
        return 1;
    }
}

