/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.onionnetworks.fec.Native8Code;
import com.onionnetworks.fec.PureCode;
import freenet.client.FECCodec;
import freenet.support.LRUHashtable;
import freenet.support.Logger;

public class StandardOnionFECCodec
extends FECCodec {
    private static int MAX_CACHED_CODECS = 8;
    static boolean noNative;
    private static final LRUHashtable recentlyUsedCodecs;

    public static synchronized FECCodec getInstance(int dataBlocks, int checkBlocks) {
        MyKey key = new MyKey(dataBlocks, checkBlocks + dataBlocks);
        StandardOnionFECCodec codec = (StandardOnionFECCodec)recentlyUsedCodecs.get(key);
        if (codec != null) {
            recentlyUsedCodecs.push(key, codec);
            return codec;
        }
        codec = new StandardOnionFECCodec(dataBlocks, checkBlocks + dataBlocks);
        recentlyUsedCodecs.push(key, codec);
        while (recentlyUsedCodecs.size() > MAX_CACHED_CODECS) {
            recentlyUsedCodecs.popKey();
        }
        return codec;
    }

    public StandardOnionFECCodec(int k, int n) {
        super(k, n);
        this.loadFEC();
        logMINOR = Logger.shouldLog(4, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFEC() {
        Native8Code fec2;
        block15: {
            StandardOnionFECCodec standardOnionFECCodec = this;
            synchronized (standardOnionFECCodec) {
                if (this.fec != null) {
                    return;
                }
            }
            fec2 = null;
            if (!noNative) {
                try {
                    fec2 = new Native8Code(this.k, this.n);
                }
                catch (Throwable t) {
                    if (!noNative) {
                        System.err.println("Failed to load native FEC: " + t);
                        t.printStackTrace();
                    }
                    Logger.error(this, "Failed to load native FEC: " + t + " (k=" + this.k + " n=" + this.n + ')', t);
                    if (!(t instanceof UnsatisfiedLinkError)) break block15;
                    noNative = true;
                }
            }
        }
        if (fec2 != null) {
            StandardOnionFECCodec standardOnionFECCodec = this;
            synchronized (standardOnionFECCodec) {
                this.fec = fec2;
            }
        }
        fec2 = new PureCode(this.k, this.n);
        StandardOnionFECCodec standardOnionFECCodec = this;
        synchronized (standardOnionFECCodec) {
            this.fec = fec2;
        }
    }

    public int countCheckBlocks() {
        return this.n - this.k;
    }

    public String toString() {
        return super.toString() + ":n=" + this.n + ",k=" + this.k;
    }

    public short getAlgorithm() {
        return 1;
    }

    static {
        recentlyUsedCodecs = new LRUHashtable();
    }

    private static class MyKey {
        int k;
        int n;

        public MyKey(int n, int k) {
            this.n = n;
            this.k = k;
        }

        public boolean equals(Object o) {
            if (o instanceof MyKey) {
                MyKey key = (MyKey)o;
                return key.n == this.n && key.k == this.k;
            }
            return false;
        }

        public int hashCode() {
            return (this.n << 16) + this.k;
        }
    }
}

