/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveKey;
import freenet.client.ArchiveStoreContext;
import freenet.client.ArchiveStoreItem;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.MultiReaderBucket;

class RealArchiveStoreItem
extends ArchiveStoreItem {
    private final MultiReaderBucket mb;
    private final Bucket bucket;
    private final long spaceUsed;

    RealArchiveStoreItem(ArchiveStoreContext ctx, FreenetURI key2, String realName, Bucket bucket) {
        super(new ArchiveKey(key2, realName), ctx);
        this.mb = new MultiReaderBucket(bucket);
        this.bucket = this.mb.getReaderBucket();
        bucket.setReadOnly();
        this.spaceUsed = bucket.size();
    }

    Bucket dataAsBucket() {
        return this.bucket;
    }

    long dataSize() {
        return this.bucket.size();
    }

    long spaceUsed() {
        return this.spaceUsed;
    }

    void innerClose() {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "innerClose(): " + this);
        }
        this.bucket.free();
    }

    Bucket getDataOrThrow() throws ArchiveFailureException {
        return this.dataAsBucket();
    }

    Bucket getReaderBucket() throws ArchiveFailureException {
        return this.mb.getReaderBucket();
    }
}

