/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientPutCallback;
import freenet.keys.FreenetURI;
import freenet.support.Logger;

public class PutWaiter
implements ClientPutCallback {
    private boolean finished;
    private boolean succeeded;
    private FreenetURI uri;
    private InsertException error;

    public synchronized void onSuccess(BaseClientPutter state, ObjectContainer container) {
        this.succeeded = true;
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void onFailure(InsertException e, BaseClientPutter state, ObjectContainer container) {
        this.error = e;
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void onGeneratedURI(FreenetURI uri, BaseClientPutter state, ObjectContainer container) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "URI: " + uri);
        }
        if (this.uri == null) {
            this.uri = uri;
        }
        if (uri.equals(this.uri)) {
            return;
        }
        Logger.error(this, "URI already set: " + this.uri + " but new URI: " + uri, new Exception("error"));
    }

    public synchronized FreenetURI waitForCompletion() throws InsertException {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.error != null) {
            this.error.uri = this.uri;
            throw this.error;
        }
        if (this.succeeded) {
            return this.uri;
        }
        Logger.error(this, "Did not succeed but no error");
        throw new InsertException(3, "Did not succeed but no error", this.uri);
    }

    public void onMajorProgress(ObjectContainer container) {
    }

    public void onFetchable(BaseClientPutter state, ObjectContainer container) {
    }
}

