/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.MetadataParseException;
import freenet.client.MetadataUnresolvedException;
import freenet.keys.BaseClientKey;
import freenet.keys.ClientCHK;
import freenet.keys.FreenetURI;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata
implements Cloneable {
    private static volatile boolean logMINOR;
    static final long FREENET_METADATA_MAGIC = -1129362800769939413L;
    static final int MAX_SPLITFILE_PARAMS_LENGTH = 32768;
    static final int MAX_SPLITFILE_BLOCKS = 1000000;
    FreenetURI resolvedURI;
    String resolvedName;
    byte documentType;
    public static final byte SIMPLE_REDIRECT = 0;
    static final byte MULTI_LEVEL_METADATA = 1;
    static final byte SIMPLE_MANIFEST = 2;
    public static final byte ARCHIVE_MANIFEST = 3;
    public static final byte ARCHIVE_INTERNAL_REDIRECT = 4;
    public static final byte ARCHIVE_METADATA_REDIRECT = 5;
    boolean splitfile;
    boolean dbr;
    boolean noMIME = true;
    boolean compressedMIME;
    boolean extraMetadata;
    boolean fullKeys;
    static final short FLAGS_SPLITFILE = 1;
    static final short FLAGS_DBR = 2;
    static final short FLAGS_NO_MIME = 4;
    static final short FLAGS_COMPRESSED_MIME = 8;
    static final short FLAGS_EXTRA_METADATA = 16;
    static final short FLAGS_FULL_KEYS = 32;
    static final short FLAGS_COMPRESSED = 128;
    ArchiveManager.ARCHIVE_TYPE archiveType;
    Compressor.COMPRESSOR_TYPE compressionCodec;
    long dataLength;
    long decompressedLength;
    String mimeType;
    short compressedMIMEValue;
    boolean hasCompressedMIMEParams;
    short compressedMIMEParams;
    FreenetURI simpleRedirectKey;
    private final int hashCode = super.hashCode();
    short splitfileAlgorithm;
    public static final short SPLITFILE_NONREDUNDANT = 0;
    public static final short SPLITFILE_ONION_STANDARD = 1;
    public static final int MAX_SIZE_IN_MANIFEST = Short.MAX_VALUE;
    byte[] splitfileParams;
    int splitfileBlocks;
    int splitfileCheckBlocks;
    ClientCHK[] splitfileDataKeys;
    ClientCHK[] splitfileCheckKeys;
    HashMap<String, Metadata> manifestEntries;
    String nameInArchive;
    ClientMetadata clientMetadata;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Yes it is!");
        }
    }

    public static Metadata construct(byte[] data) throws MetadataParseException {
        try {
            return new Metadata(data);
        }
        catch (IOException e) {
            MetadataParseException e1 = new MetadataParseException("Caught " + e);
            e1.initCause(e);
            throw e1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata construct(Bucket data) throws MetadataParseException, IOException {
        Metadata m;
        InputStream is = data.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is, 4096);
        try {
            DataInputStream dis = new DataInputStream(bis);
            m = new Metadata(dis, data.size());
        }
        finally {
            is.close();
        }
        return m;
    }

    private Metadata(byte[] data) throws IOException, MetadataParseException {
        this(new DataInputStream(new ByteArrayInputStream(data)), data.length);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Metadata(DataInputStream dis, long length) throws IOException, MetadataParseException {
        int i;
        long magic = dis.readLong();
        if (magic != -1129362800769939413L) {
            throw new MetadataParseException("Invalid magic " + magic);
        }
        short version = dis.readShort();
        if (version != 0) {
            throw new MetadataParseException("Unsupported version " + version);
        }
        this.documentType = dis.readByte();
        if (this.documentType < 0 || this.documentType > 5) {
            throw new MetadataParseException("Unsupported document type: " + this.documentType);
        }
        if (logMINOR) {
            Logger.minor(this, "Document type: " + this.documentType);
        }
        boolean compressed = false;
        if (this.haveFlags()) {
            short flags = dis.readShort();
            this.splitfile = (flags & 1) == 1;
            this.dbr = (flags & 2) == 2;
            this.noMIME = (flags & 4) == 4;
            this.compressedMIME = (flags & 8) == 8;
            this.extraMetadata = (flags & 0x10) == 16;
            this.fullKeys = (flags & 0x20) == 32;
            boolean bl = compressed = (flags & 0x80) == 128;
        }
        if (this.documentType == 3) {
            if (logMINOR) {
                Logger.minor(this, "Archive manifest");
            }
            this.archiveType = ArchiveManager.ARCHIVE_TYPE.getArchiveType(dis.readShort());
            if (this.archiveType == null) {
                throw new MetadataParseException("Unrecognized archive type " + (Object)((Object)this.archiveType));
            }
        }
        if (this.splitfile) {
            if (logMINOR) {
                Logger.minor(this, "Splitfile");
            }
            this.dataLength = dis.readLong();
            if (this.dataLength < -1L) {
                throw new MetadataParseException("Invalid real content length " + this.dataLength);
            }
            if (this.dataLength == -1L && this.splitfile) {
                throw new MetadataParseException("Splitfile must have a real-length");
            }
        }
        if (compressed) {
            this.compressionCodec = Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID(dis.readShort());
            if (this.compressionCodec == null) {
                throw new MetadataParseException("Unrecognized splitfile compression codec " + this.compressionCodec);
            }
            this.decompressedLength = dis.readLong();
        }
        if (this.noMIME) {
            this.mimeType = null;
            if (logMINOR) {
                Logger.minor(this, "noMIME enabled");
            }
        } else {
            if (this.compressedMIME) {
                if (logMINOR) {
                    Logger.minor(this, "Compressed MIME");
                }
                short x = dis.readShort();
                this.compressedMIMEValue = (short)(x & Short.MAX_VALUE);
                boolean bl = this.hasCompressedMIMEParams = (this.compressedMIMEValue & 0x8000) == 32768;
                if (this.hasCompressedMIMEParams) {
                    this.compressedMIMEParams = dis.readShort();
                    if (this.compressedMIMEParams != 0) {
                        throw new MetadataParseException("Unrecognized MIME params ID (not yet implemented)");
                    }
                }
                this.mimeType = DefaultMIMETypes.byNumber(x);
            } else {
                byte l = dis.readByte();
                int len = l & 0xFF;
                byte[] toRead = new byte[len];
                dis.readFully(toRead);
                this.mimeType = new String(toRead, "UTF-8");
                if (logMINOR) {
                    Logger.minor(this, "Raw MIME");
                }
            }
            if (logMINOR) {
                Logger.minor(this, "MIME = " + this.mimeType);
            }
        }
        if (this.dbr) {
            throw new MetadataParseException("Do not support DBRs pending decision on putting them in the key!");
        }
        if (this.extraMetadata) {
            int numberOfExtraFields = dis.readShort() & 0xFFFF;
            for (i = 0; i < numberOfExtraFields; ++i) {
                short type = dis.readShort();
                int len = dis.readByte() & 0xFF;
                byte[] buf = new byte[len];
                dis.readFully(buf);
                Logger.normal(this, "Ignoring type " + type + " extra-client-metadata field of " + len + " bytes");
            }
            this.extraMetadata = false;
        }
        this.clientMetadata = new ClientMetadata(this.mimeType);
        if (!(this.splitfile || this.documentType != 0 && this.documentType != 3)) {
            this.simpleRedirectKey = this.readKey(dis);
        } else if (this.splitfile) {
            this.splitfileAlgorithm = dis.readShort();
            if (this.splitfileAlgorithm != 0 && this.splitfileAlgorithm != 1) {
                throw new MetadataParseException("Unknown splitfile algorithm " + this.splitfileAlgorithm);
            }
            if (this.splitfileAlgorithm == 0) {
                throw new MetadataParseException("Non-redundant splitfile invalid");
            }
            int paramsLength = dis.readInt();
            if (paramsLength > 32768) {
                throw new MetadataParseException("Too many bytes of splitfile parameters: " + paramsLength);
            }
            if (paramsLength > 0) {
                this.splitfileParams = new byte[paramsLength];
                dis.readFully(this.splitfileParams);
            } else if (paramsLength < 0) {
                throw new MetadataParseException("Invalid splitfile params length: " + paramsLength);
            }
            this.splitfileBlocks = dis.readInt();
            if (this.splitfileBlocks < 0) {
                throw new MetadataParseException("Invalid number of blocks: " + this.splitfileBlocks);
            }
            if (this.splitfileBlocks > 1000000) {
                throw new MetadataParseException("Too many splitfile blocks (soft limit to prevent memory DoS): " + this.splitfileBlocks);
            }
            this.splitfileCheckBlocks = dis.readInt();
            if (this.splitfileCheckBlocks < 0) {
                throw new MetadataParseException("Invalid number of check blocks: " + this.splitfileCheckBlocks);
            }
            if (this.splitfileCheckBlocks > 1000000) {
                throw new MetadataParseException("Too many splitfile check-blocks (soft limit to prevent memory DoS): " + this.splitfileCheckBlocks);
            }
            this.splitfileDataKeys = new ClientCHK[this.splitfileBlocks];
            this.splitfileCheckKeys = new ClientCHK[this.splitfileCheckBlocks];
            for (i = 0; i < this.splitfileDataKeys.length; ++i) {
                this.splitfileDataKeys[i] = this.readCHK(dis);
                if (this.splitfileDataKeys[i] != null) continue;
                throw new MetadataParseException("Null data key " + i);
            }
            for (i = 0; i < this.splitfileCheckKeys.length; ++i) {
                this.splitfileCheckKeys[i] = this.readCHK(dis);
                if (this.splitfileCheckKeys[i] != null) continue;
                throw new MetadataParseException("Null check key: " + i);
            }
        }
        if (this.documentType == 2) {
            int manifestEntryCount = dis.readInt();
            if (manifestEntryCount < 0) {
                throw new MetadataParseException("Invalid manifest entry count: " + manifestEntryCount);
            }
            this.manifestEntries = new HashMap();
            if (logMINOR) {
                Logger.minor(this, "Simple manifest, " + manifestEntryCount + " entries");
            }
            for (i = 0; i < manifestEntryCount; ++i) {
                short len;
                short nameLength = dis.readShort();
                byte[] buf = new byte[nameLength];
                dis.readFully(buf);
                String name = new String(buf, "UTF-8").intern();
                if (logMINOR) {
                    Logger.minor(this, "Entry " + i + " name " + name);
                }
                if ((len = dis.readShort()) < 0) {
                    throw new MetadataParseException("Invalid manifest entry size: " + len);
                }
                if ((long)len > length) {
                    throw new MetadataParseException("Impossibly long manifest entry: " + len + " - metadata size " + length);
                }
                byte[] data = new byte[len];
                dis.readFully(data);
                try {
                    Metadata m = Metadata.construct(data);
                    this.manifestEntries.put(name, m);
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(this, "Could not parse sub-manifest: " + t, t);
                }
            }
            if (logMINOR) {
                Logger.minor(this, "End of manifest");
            }
        }
        if (this.documentType == 4 || this.documentType == 5) {
            short len = dis.readShort();
            if (logMINOR) {
                Logger.minor(this, "Reading archive internal redirect length " + len);
            }
            byte[] buf = new byte[len];
            dis.readFully(buf);
            this.nameInArchive = new String(buf, "UTF-8");
            if (logMINOR) {
                Logger.minor(this, "Archive internal redirect: " + this.nameInArchive + " (" + len + ')');
            }
        }
    }

    private Metadata() {
    }

    private void addRedirectionManifest(HashMap<String, Object> dir) throws MalformedURLException {
        this.documentType = (byte)2;
        this.noMIME = true;
        this.manifestEntries = new HashMap();
        int count = 0;
        for (Map.Entry<String, Object> entry : dir.entrySet()) {
            Metadata target;
            String key = entry.getKey().intern();
            ++count;
            Object o = entry.getValue();
            if (o instanceof String) {
                FreenetURI uri = new FreenetURI((String)o);
                target = new Metadata(0, null, null, uri, null);
            } else if (o instanceof HashMap) {
                target = new Metadata();
                target.addRedirectionManifest((HashMap)o);
            } else {
                throw new IllegalArgumentException("Not String nor HashMap: " + o);
            }
            this.manifestEntries.put(key, target);
        }
    }

    public static Metadata mkRedirectionManifest(HashMap<String, Object> dir) throws MalformedURLException {
        Metadata ret = new Metadata();
        ret.addRedirectionManifest(dir);
        return ret;
    }

    public static Metadata mkRedirectionManifestWithMetadata(HashMap<String, Object> dir) {
        Metadata ret = new Metadata();
        ret.addRedirectionManifestWithMetadata(dir);
        return ret;
    }

    private void addRedirectionManifestWithMetadata(HashMap<String, Object> dir) {
        this.documentType = (byte)2;
        this.noMIME = true;
        this.manifestEntries = new HashMap();
        int count = 0;
        Iterator<String> i = dir.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().intern();
            if (key.indexOf(47) != -1) {
                throw new IllegalArgumentException("Slashes in simple redirect manifest filenames! (slashes denote sub-manifests): " + key);
            }
            ++count;
            Object o = dir.get(key);
            if (o instanceof Metadata) {
                Metadata data = (Metadata)dir.get(key);
                if (data == null) {
                    throw new NullPointerException();
                }
                if (Logger.shouldLog(2, this)) {
                    Logger.debug(this, "Putting metadata for " + key);
                }
                this.manifestEntries.put(key, data);
                continue;
            }
            if (!(o instanceof HashMap)) continue;
            HashMap hm = (HashMap)o;
            if (Logger.shouldLog(2, this)) {
                Logger.debug(this, "Making metadata map for " + key);
            }
            Metadata subMap = Metadata.mkRedirectionManifestWithMetadata(hm);
            this.manifestEntries.put(key, subMap);
            if (!Logger.shouldLog(2, this)) continue;
            Logger.debug(this, "Putting metadata map for " + key);
        }
    }

    Metadata(HashMap<String, Object> dir, String prefix) {
        this.documentType = (byte)2;
        this.noMIME = true;
        this.mimeType = null;
        this.clientMetadata = new ClientMetadata();
        this.manifestEntries = new HashMap();
        int count = 0;
        Iterator<String> i = dir.keySet().iterator();
        while (i.hasNext()) {
            Metadata target;
            String key = i.next().intern();
            ++count;
            Object o = dir.get(key);
            if (o instanceof String) {
                target = new Metadata(4, null, null, prefix + key, new ClientMetadata(DefaultMIMETypes.guessMIMEType(key, false)));
            } else if (o instanceof HashMap) {
                target = new Metadata((HashMap)o, prefix + key + "/");
            } else {
                throw new IllegalArgumentException("Not String nor HashMap: " + o);
            }
            this.manifestEntries.put(key, target);
        }
    }

    public Metadata(byte docType, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE compressionCodec, String arg, ClientMetadata cm) {
        if (docType == 4) {
            this.documentType = docType;
            this.archiveType = archiveType;
            this.clientMetadata = cm;
            this.compressionCodec = compressionCodec;
            if (cm != null) {
                this.setMIMEType(cm.getMIMEType());
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.nameInArchive = arg;
    }

    private Metadata(byte docType, String name) {
        this.noMIME = true;
        if (docType != 5) {
            throw new IllegalArgumentException();
        }
        this.documentType = docType;
        this.nameInArchive = name;
    }

    public Metadata(byte docType, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE compressionCodec, FreenetURI uri, ClientMetadata cm) {
        if (docType == 0 || docType == 3) {
            this.documentType = docType;
            this.archiveType = archiveType;
            this.compressionCodec = compressionCodec;
            this.clientMetadata = cm;
            if (cm != null && !cm.isTrivial()) {
                this.setMIMEType(cm.getMIMEType());
            } else {
                this.setMIMEType("application/octet-stream");
                this.noMIME = true;
            }
            if (uri == null) {
                throw new NullPointerException();
            }
            this.simpleRedirectKey = uri;
            if (!uri.getKeyType().equals("CHK") || uri.hasMetaStrings()) {
                this.fullKeys = true;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Metadata(short algo, ClientCHK[] dataURIs, ClientCHK[] checkURIs, int segmentSize, int checkSegmentSize, ClientMetadata cm, long dataLength, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE compressionCodec, long decompressedLength, boolean isMetadata) {
        if (isMetadata) {
            this.documentType = 1;
        } else if (archiveType != null) {
            this.documentType = (byte)3;
            this.archiveType = archiveType;
        } else {
            this.documentType = 0;
        }
        this.splitfile = true;
        this.splitfileAlgorithm = algo;
        this.dataLength = dataLength;
        this.compressionCodec = compressionCodec;
        this.splitfileBlocks = dataURIs.length;
        this.splitfileCheckBlocks = checkURIs.length;
        this.splitfileDataKeys = dataURIs;
        assert (this.keysValid(this.splitfileDataKeys));
        this.splitfileCheckKeys = checkURIs;
        assert (this.keysValid(this.splitfileCheckKeys));
        this.clientMetadata = cm;
        this.compressionCodec = compressionCodec;
        this.decompressedLength = decompressedLength;
        if (cm != null) {
            this.setMIMEType(cm.getMIMEType());
        } else {
            this.setMIMEType("application/octet-stream");
        }
        this.splitfileParams = Fields.intsToBytes(new int[]{segmentSize, checkSegmentSize});
    }

    private boolean keysValid(ClientCHK[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].getNodeCHK().getRoutingKey() != null) continue;
            return false;
        }
        return true;
    }

    private void setMIMEType(String type) {
        this.noMIME = false;
        short s = DefaultMIMETypes.byName(type);
        if (s >= 0) {
            this.compressedMIME = true;
            this.compressedMIMEValue = s;
        } else {
            this.compressedMIME = false;
        }
        this.mimeType = type;
    }

    public byte[] writeToByteArray() throws MetadataUnresolvedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.writeTo(dos);
        }
        catch (IOException e) {
            throw new Error("Could not write to byte array: " + e, e);
        }
        return baos.toByteArray();
    }

    private ClientCHK readCHK(DataInputStream dis) throws IOException, MetadataParseException {
        if (this.fullKeys) {
            throw new MetadataParseException("fullKeys not supported on a splitfile");
        }
        return ClientCHK.readRawBinaryKey(dis);
    }

    private FreenetURI readKey(DataInputStream dis) throws IOException {
        if (this.fullKeys) {
            return FreenetURI.readFullBinaryKeyWithLength(dis);
        }
        return ClientCHK.readRawBinaryKey(dis).getURI();
    }

    private void writeKey(DataOutputStream dos, FreenetURI freenetURI) throws IOException {
        if (this.fullKeys) {
            freenetURI.writeFullBinaryKeyWithLength(dos);
        } else {
            String[] meta = freenetURI.getAllMetaStrings();
            if (meta != null && meta.length > 0) {
                throw new MalformedURLException("Not a plain CHK");
            }
            BaseClientKey key = BaseClientKey.getBaseKey(freenetURI);
            if (key instanceof ClientCHK) {
                ((ClientCHK)key).writeRawBinaryKey(dos);
            } else {
                throw new IllegalArgumentException("Full keys must be enabled to write non-CHKs");
            }
        }
    }

    private void writeCHK(DataOutputStream dos, ClientCHK chk) throws IOException {
        if (this.fullKeys) {
            throw new UnsupportedOperationException("Full keys not supported on splitfiles");
        }
        chk.writeRawBinaryKey(dos);
    }

    public boolean isSimpleManifest() {
        return this.documentType == 2;
    }

    public Metadata getDocument(String name) {
        return this.manifestEntries.get(name);
    }

    public Metadata grabDocument(String name) {
        return this.manifestEntries.remove(name);
    }

    public Metadata getDefaultDocument() throws MetadataParseException {
        return this.getDocument("");
    }

    public Metadata grabDefaultDocument() {
        return this.grabDocument("");
    }

    public HashMap<String, Metadata> getDocuments() {
        HashMap<String, Metadata> docs = new HashMap<String, Metadata>();
        Set<String> s = this.manifestEntries.keySet();
        for (String st : s) {
            if (st.length() <= 1) continue;
            docs.put(st, this.manifestEntries.get(st));
        }
        return docs;
    }

    public boolean isSingleFileRedirect() {
        return !this.splitfile && this.documentType == 0 || this.documentType == 1 || this.documentType == 3;
    }

    public FreenetURI getSingleTarget() {
        return this.simpleRedirectKey;
    }

    public boolean isArchiveManifest() {
        return this.documentType == 3;
    }

    public boolean isArchiveMetadataRedirect() {
        return this.documentType == 5;
    }

    public boolean isArchiveInternalRedirect() {
        return this.documentType == 4;
    }

    public String getArchiveInternalName() {
        return this.nameInArchive;
    }

    public ClientMetadata getClientMetadata() {
        return this.clientMetadata;
    }

    public boolean isSplitfile() {
        return this.splitfile;
    }

    public boolean isSimpleSplitfile() {
        return this.splitfile && this.documentType == 0;
    }

    public boolean isMultiLevelMetadata() {
        return this.documentType == 1;
    }

    public ArchiveManager.ARCHIVE_TYPE getArchiveType() {
        return this.archiveType;
    }

    public void setSimpleRedirect() {
        this.documentType = 0;
    }

    public boolean isSimpleRedirect() {
        return this.documentType == 0;
    }

    public boolean isNoMimeEnabled() {
        return this.noMIME;
    }

    public String getResolvedName() {
        return this.resolvedName;
    }

    public void writeTo(DataOutputStream dos) throws IOException, MetadataUnresolvedException {
        dos.writeLong(-1129362800769939413L);
        dos.writeShort(0);
        dos.writeByte(this.documentType);
        if (this.haveFlags()) {
            short flags = 0;
            if (this.splitfile) {
                flags = (short)(flags | 1);
            }
            if (this.dbr) {
                flags = (short)(flags | 2);
            }
            if (this.noMIME) {
                flags = (short)(flags | 4);
            }
            if (this.compressedMIME) {
                flags = (short)(flags | 8);
            }
            if (this.extraMetadata) {
                flags = (short)(flags | 0x10);
            }
            if (this.fullKeys) {
                flags = (short)(flags | 0x20);
            }
            if (this.compressionCodec != null) {
                flags = (short)(flags | 0x80);
            }
            dos.writeShort(flags);
        }
        if (this.documentType == 3) {
            short code = this.archiveType.metadataID;
            dos.writeShort(code);
        }
        if (this.splitfile) {
            dos.writeLong(this.dataLength);
        }
        if (this.compressionCodec != null) {
            dos.writeShort(this.compressionCodec.metadataID);
            dos.writeLong(this.decompressedLength);
        }
        if (!this.noMIME) {
            if (this.compressedMIME) {
                int x = this.compressedMIMEValue;
                if (this.hasCompressedMIMEParams) {
                    x |= 0x8000;
                }
                dos.writeShort((short)x);
                if (this.hasCompressedMIMEParams) {
                    dos.writeShort(this.compressedMIMEParams);
                }
            } else {
                byte[] data = this.mimeType.getBytes("UTF-8");
                if (data.length > 255) {
                    throw new Error("MIME type too long: " + data.length + " bytes: " + this.mimeType);
                }
                dos.writeByte((byte)data.length);
                dos.write(data);
            }
        }
        if (this.dbr) {
            throw new UnsupportedOperationException("No DBR support yet");
        }
        if (this.extraMetadata) {
            throw new UnsupportedOperationException("No extra metadata support yet");
        }
        if (!(this.splitfile || this.documentType != 0 && this.documentType != 3)) {
            this.writeKey(dos, this.simpleRedirectKey);
        } else if (this.splitfile) {
            int i;
            dos.writeShort(this.splitfileAlgorithm);
            if (this.splitfileParams != null) {
                dos.writeInt(this.splitfileParams.length);
                dos.write(this.splitfileParams);
            } else {
                dos.writeInt(0);
            }
            dos.writeInt(this.splitfileBlocks);
            dos.writeInt(this.splitfileCheckBlocks);
            for (i = 0; i < this.splitfileBlocks; ++i) {
                this.writeCHK(dos, this.splitfileDataKeys[i]);
            }
            for (i = 0; i < this.splitfileCheckBlocks; ++i) {
                this.writeCHK(dos, this.splitfileCheckKeys[i]);
            }
        }
        if (this.documentType == 2) {
            dos.writeInt(this.manifestEntries.size());
            boolean kill = false;
            LinkedList<Metadata> unresolvedMetadata = null;
            for (String name : this.manifestEntries.keySet()) {
                byte[] nameData = name.getBytes("UTF-8");
                if (nameData.length > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("Manifest name too long");
                }
                dos.writeShort(nameData.length);
                dos.write(nameData);
                Metadata meta = this.manifestEntries.get(name);
                try {
                    byte[] data = meta.writeToByteArray();
                    if (data.length > Short.MAX_VALUE) {
                        FreenetURI uri = meta.resolvedURI;
                        String n = meta.resolvedName;
                        if (uri != null) {
                            meta = new Metadata(0, null, null, uri, null);
                            data = meta.writeToByteArray();
                        } else if (n != null) {
                            meta = new Metadata(5, n);
                            data = meta.writeToByteArray();
                        } else {
                            kill = true;
                            if (unresolvedMetadata == null) {
                                unresolvedMetadata = new LinkedList();
                            }
                            unresolvedMetadata.addLast(meta);
                        }
                    }
                    dos.writeShort(data.length);
                    dos.write(data);
                }
                catch (MetadataUnresolvedException e) {
                    Metadata[] m = e.mustResolve;
                    if (unresolvedMetadata == null) {
                        unresolvedMetadata = new LinkedList<Metadata>();
                    }
                    for (int j = 0; j < m.length; ++j) {
                        unresolvedMetadata.addFirst(m[j]);
                    }
                    kill = true;
                }
            }
            if (kill) {
                Metadata[] meta = unresolvedMetadata.toArray(new Metadata[unresolvedMetadata.size()]);
                throw new MetadataUnresolvedException(meta, "Manifest data too long and not resolved");
            }
        }
        if (this.documentType == 4 || this.documentType == 5) {
            byte[] data = this.nameInArchive.getBytes("UTF-8");
            if (data.length > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Archive internal redirect name too long");
            }
            dos.writeShort(data.length);
            dos.write(data);
        }
    }

    public boolean haveFlags() {
        return this.documentType == 0 || this.documentType == 1 || this.documentType == 3 || this.documentType == 4 || this.documentType == 5;
    }

    public short getSplitfileType() {
        return this.splitfileAlgorithm;
    }

    public ClientCHK[] getSplitfileDataKeys() {
        return this.splitfileDataKeys;
    }

    public ClientCHK[] getSplitfileCheckKeys() {
        return this.splitfileCheckKeys;
    }

    public boolean isCompressed() {
        return this.compressionCodec != null;
    }

    public Compressor.COMPRESSOR_TYPE getCompressionCodec() {
        return this.compressionCodec;
    }

    public long dataLength() {
        return this.dataLength;
    }

    public byte[] splitfileParams() {
        return this.splitfileParams;
    }

    public long uncompressedDataLength() {
        return this.decompressedLength;
    }

    public FreenetURI getResolvedURI() {
        return this.resolvedURI;
    }

    public void resolve(FreenetURI uri) {
        this.resolvedURI = uri;
    }

    public void resolve(String name) {
        this.resolvedName = name;
    }

    public Bucket toBucket(BucketFactory bf) throws MetadataUnresolvedException, IOException {
        byte[] buf = this.writeToByteArray();
        return BucketTools.makeImmutableBucket(bf, buf);
    }

    public boolean isResolved() {
        return this.resolvedURI != null || this.resolvedName != null;
    }

    public void setArchiveManifest() {
        ArchiveManager.ARCHIVE_TYPE type;
        this.archiveType = type = ArchiveManager.ARCHIVE_TYPE.getArchiveType(this.clientMetadata.getMIMEType());
        this.compressionCodec = null;
        this.clientMetadata.clear();
        this.documentType = (byte)3;
    }

    public String getMIMEType() {
        if (this.clientMetadata == null) {
            return null;
        }
        return this.clientMetadata.getMIMEType();
    }

    public void removeFrom(ObjectContainer container) {
        if (this.resolvedURI != null) {
            container.activate((Object)this.resolvedURI, 5);
            this.resolvedURI.removeFrom(container);
        }
        if (this.simpleRedirectKey != null) {
            container.activate((Object)this.simpleRedirectKey, 5);
            this.simpleRedirectKey.removeFrom(container);
        }
        if (this.splitfileDataKeys != null) {
            for (ClientCHK key : this.splitfileDataKeys) {
                if (key == null) continue;
                container.activate((Object)key, 5);
                key.removeFrom(container);
            }
        }
        if (this.splitfileCheckKeys != null) {
            for (ClientCHK key : this.splitfileCheckKeys) {
                if (key == null) continue;
                container.activate((Object)key, 5);
                key.removeFrom(container);
            }
        }
        if (this.manifestEntries != null) {
            container.activate(this.manifestEntries, 2);
            Iterator<Metadata> i$ = this.manifestEntries.values().iterator();
            while (i$.hasNext()) {
                Metadata m;
                Metadata meta = m = i$.next();
                container.activate((Object)meta, 1);
                meta.removeFrom(container);
            }
            container.delete(this.manifestEntries);
        }
        if (this.clientMetadata != null) {
            container.activate((Object)this.clientMetadata, 1);
            this.clientMetadata.removeFrom(container);
        }
        container.delete((Object)this);
    }

    public void clearSplitfileKeys() {
        this.splitfileDataKeys = null;
        this.splitfileCheckKeys = null;
    }

    static {
        Logger.registerClass(Metadata.class);
    }
}

