/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.FailureCodeTracker;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class InsertException
extends Exception {
    private static final long serialVersionUID = -1106716067841151962L;
    private final int mode;
    public FailureCodeTracker errorCodes;
    public FreenetURI uri;
    public final String extra;
    private static volatile boolean logMINOR;
    public static final int INVALID_URI = 1;
    public static final int BUCKET_ERROR = 2;
    public static final int INTERNAL_ERROR = 3;
    public static final int REJECTED_OVERLOAD = 4;
    public static final int ROUTE_NOT_FOUND = 5;
    public static final int FATAL_ERRORS_IN_BLOCKS = 6;
    public static final int TOO_MANY_RETRIES_IN_BLOCKS = 7;
    public static final int ROUTE_REALLY_NOT_FOUND = 8;
    public static final int COLLISION = 9;
    public static final int CANCELLED = 10;
    public static final int META_STRINGS_NOT_SUPPORTED = 11;
    public static final int BINARY_BLOB_FORMAT_ERROR = 12;

    public int getMode() {
        return this.mode;
    }

    public InsertException(int m, String msg, FreenetURI expectedURI) {
        super(InsertException.getMessage(m) + ": " + msg);
        if (m == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extra = msg;
        this.mode = m;
        if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(this.mode) + ": " + msg, (Throwable)this);
        }
        this.errorCodes = null;
        this.uri = expectedURI;
    }

    public InsertException(int m, FreenetURI expectedURI) {
        super(InsertException.getMessage(m));
        if (m == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extra = null;
        this.mode = m;
        if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(this.mode), (Throwable)this);
        }
        this.errorCodes = null;
        this.uri = expectedURI;
    }

    public InsertException(int mode, Throwable e, FreenetURI expectedURI) {
        super(InsertException.getMessage(mode) + ": " + e.getMessage());
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extra = e.getMessage();
        if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(mode) + ": " + e, e);
        }
        this.mode = mode;
        this.errorCodes = null;
        this.initCause(e);
        this.uri = expectedURI;
    }

    public InsertException(int mode, FailureCodeTracker errorCodes, FreenetURI expectedURI) {
        super(InsertException.getMessage(mode));
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extra = null;
        this.mode = mode;
        if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(mode), (Throwable)this);
        }
        this.errorCodes = errorCodes;
        this.uri = expectedURI;
    }

    public InsertException(int mode) {
        super(InsertException.getMessage(mode));
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extra = null;
        this.mode = mode;
        this.errorCodes = null;
        this.uri = null;
    }

    public InsertException(InsertException e) {
        super(e.getMessage());
        if (e.mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extra = e.extra;
        this.mode = e.mode;
        this.errorCodes = e.errorCodes.clone();
        this.uri = e.uri == null ? null : e.uri.clone();
    }

    public static String getMessage(int mode) {
        String ret = L10n.getString("InsertException.longError." + mode);
        if (ret == null) {
            return "Unknown error " + mode;
        }
        return ret;
    }

    public static String getShortMessage(int mode) {
        String ret = L10n.getString("InsertException.shortError." + mode);
        if (ret == null) {
            return "Unknown error " + mode;
        }
        return ret;
    }

    public boolean isFatal() {
        return InsertException.isFatal(this.mode);
    }

    public static boolean isFatal(int mode) {
        switch (mode) {
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return false;
            }
        }
        Logger.error(InsertException.class, "Error unknown to isFatal(): " + InsertException.getMessage(mode));
        return false;
    }

    public static InsertException construct(FailureCodeTracker errors) {
        if (errors == null) {
            return null;
        }
        if (errors.isEmpty()) {
            return null;
        }
        if (errors.isOneCodeOnly()) {
            return new InsertException(errors.getFirstCode());
        }
        int mode = errors.isFatal(true) ? 6 : 7;
        return new InsertException(mode, errors, null);
    }

    public InsertException clone() {
        return new InsertException(this);
    }

    public void removeFrom(ObjectContainer container) {
        StackTraceElement[] elements;
        if (this.errorCodes != null) {
            container.activate((Object)this.errorCodes, 1);
            this.errorCodes.removeFrom(container);
        }
        if (this.uri != null) {
            container.activate((Object)this.uri, 5);
            this.uri.removeFrom(container);
        }
        if ((elements = this.getStackTrace()) != null) {
            for (StackTraceElement element : elements) {
                container.delete((Object)element);
            }
        }
        container.delete((Object)this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

