/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.SimpleEventProducer;
import freenet.support.Logger;
import freenet.support.api.BucketFactory;
import freenet.support.io.PersistentFileTracker;

public class InsertContext {
    public final BucketFactory persistentBucketFactory;
    public final PersistentFileTracker persistentFileTracker;
    public boolean dontCompress;
    public final short splitfileAlgorithm;
    public int maxInsertRetries;
    final int maxSplitInsertThreads;
    public final int consecutiveRNFsCountAsSuccess;
    public final int splitfileSegmentDataBlocks;
    public final int splitfileSegmentCheckBlocks;
    public final ClientEventProducer eventProducer;
    public final boolean cacheLocalRequests;

    public InsertContext(BucketFactory bf, BucketFactory persistentBF, PersistentFileTracker tracker, int maxRetries, int rnfsToSuccess, int maxThreads, int splitfileSegmentDataBlocks, int splitfileSegmentCheckBlocks, ClientEventProducer eventProducer, boolean cacheLocalRequests) {
        this.persistentFileTracker = tracker;
        this.persistentBucketFactory = persistentBF;
        this.dontCompress = false;
        this.splitfileAlgorithm = 1;
        this.consecutiveRNFsCountAsSuccess = rnfsToSuccess;
        this.maxInsertRetries = maxRetries;
        this.maxSplitInsertThreads = maxThreads;
        this.eventProducer = eventProducer;
        this.splitfileSegmentDataBlocks = splitfileSegmentDataBlocks;
        this.splitfileSegmentCheckBlocks = splitfileSegmentCheckBlocks;
        this.cacheLocalRequests = cacheLocalRequests;
    }

    public InsertContext(InsertContext ctx, SimpleEventProducer producer) {
        this.persistentFileTracker = ctx.persistentFileTracker;
        this.persistentBucketFactory = ctx.persistentBucketFactory;
        this.dontCompress = ctx.dontCompress;
        this.splitfileAlgorithm = ctx.splitfileAlgorithm;
        this.consecutiveRNFsCountAsSuccess = ctx.consecutiveRNFsCountAsSuccess;
        this.maxInsertRetries = ctx.maxInsertRetries;
        this.maxSplitInsertThreads = ctx.maxSplitInsertThreads;
        this.eventProducer = producer;
        this.splitfileSegmentDataBlocks = ctx.splitfileSegmentDataBlocks;
        this.splitfileSegmentCheckBlocks = ctx.splitfileSegmentCheckBlocks;
        this.cacheLocalRequests = ctx.cacheLocalRequests;
    }

    public void removeFrom(ObjectContainer container) {
        if (this.eventProducer == null) {
            Logger.error(this, "No EventProducer on InsertContext! activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), new Exception("error"));
        } else {
            container.activate((Object)this.eventProducer, 1);
            this.eventProducer.removeFrom(container);
        }
        container.delete((Object)this);
    }
}

