/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.keys.FreenetURI;
import freenet.support.api.Bucket;

public class InsertBlock {
    private Bucket data;
    private boolean isFreed;
    public FreenetURI desiredURI;
    public ClientMetadata clientMetadata;

    public InsertBlock(Bucket data, ClientMetadata metadata, FreenetURI desiredURI) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.isFreed = false;
        this.clientMetadata = metadata == null ? new ClientMetadata() : metadata;
        this.desiredURI = desiredURI;
    }

    public Bucket getData() {
        return this.isFreed ? null : this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(ObjectContainer container) {
        InsertBlock insertBlock = this;
        synchronized (insertBlock) {
            if (this.isFreed) {
                return;
            }
            this.isFreed = true;
            if (this.data == null) {
                return;
            }
        }
        this.data.free();
        if (container != null) {
            this.data.removeFrom(container);
            this.data = null;
        }
        if (container != null) {
            container.store((Object)this);
        }
    }

    public void removeFrom(ObjectContainer container) {
        if (this.data != null) {
            container.activate((Object)this.data, 1);
            this.data.removeFrom(container);
        }
        if (this.desiredURI != null) {
            container.activate((Object)this.desiredURI, 5);
            this.desiredURI.removeFrom(container);
        }
        if (this.clientMetadata != null) {
            container.activate((Object)this.clientMetadata, 5);
            this.clientMetadata.removeFrom(container);
        }
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        container.activate((Object)this.data, 1);
        container.activate((Object)this.desiredURI, 5);
    }

    public void nullData() {
        this.data = null;
    }

    public void nullURI() {
        this.desiredURI = null;
    }

    public void nullMetadata() {
        this.clientMetadata = null;
    }
}

