/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.FetchWaiter;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.NullClientCallback;
import freenet.client.PutWaiter;
import freenet.client.async.ClientCallback;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.SimpleManifestPutter;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.EventLogger;
import freenet.client.events.SimpleEventProducer;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.NullBucket;
import freenet.support.io.NullPersistentFileTracker;
import freenet.support.io.PersistentFileTracker;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

public class HighLevelSimpleClientImpl
implements HighLevelSimpleClient,
RequestClient {
    private final short priorityClass;
    private final BucketFactory bucketFactory;
    private final BucketFactory persistentBucketFactory;
    private final PersistentFileTracker persistentFileTracker;
    private final NodeClientCore core;
    private final ClientEventProducer eventProducer;
    private long curMaxLength;
    private long curMaxTempLength;
    private int curMaxMetadataLength;
    private final RandomSource random;
    private final boolean cacheLocalRequests;
    static final int MAX_RECURSION = 10;
    static final int MAX_ARCHIVE_RESTARTS = 2;
    static final int MAX_ARCHIVE_LEVELS = 4;
    static final boolean DONT_ENTER_IMPLICIT_ARCHIVES = true;
    static final int SPLITFILE_THREADS = 20;
    static final int SPLITFILE_BLOCK_RETRIES = Math.min(3, 2);
    static final int NON_SPLITFILE_RETRIES = Math.min(3, 2);
    static final int USK_RETRIES = 2;
    static final boolean FETCH_SPLITFILES = true;
    static final boolean FOLLOW_REDIRECTS = true;
    static final boolean LOCAL_REQUESTS_ONLY = false;
    static final int SPLITFILE_INSERT_THREADS = 20;
    static final int INSERT_RETRIES = 10;
    static final int CONSECUTIVE_RNFS_ASSUME_SUCCESS = 2;
    static final int MAX_SPLITFILE_BLOCKS_PER_SEGMENT = 1024;
    static final int MAX_SPLITFILE_CHECK_BLOCKS_PER_SEGMENT = 1536;
    public static final int SPLITFILE_BLOCKS_PER_SEGMENT = 128;
    static final int SPLITFILE_CHECK_BLOCKS_PER_SEGMENT = 128;
    private final ClientGetCallback nullCallback = new NullClientCallback();

    public HighLevelSimpleClientImpl(NodeClientCore node, BucketFactory bf, RandomSource r, boolean cacheLocalRequests, short priorityClass, boolean forceDontIgnoreTooManyPathComponents) {
        this.core = node;
        this.priorityClass = priorityClass;
        this.bucketFactory = bf;
        this.persistentFileTracker = node.persistentTempBucketFactory;
        this.random = r;
        this.eventProducer = new SimpleEventProducer();
        this.eventProducer.addEventListener(new EventLogger(4, false));
        this.curMaxLength = Long.MAX_VALUE;
        this.curMaxTempLength = Long.MAX_VALUE;
        this.curMaxMetadataLength = 0x100000;
        this.cacheLocalRequests = cacheLocalRequests;
        this.persistentBucketFactory = node.persistentTempBucketFactory;
    }

    public void setMaxLength(long maxLength) {
        this.curMaxLength = maxLength;
    }

    public void setMaxIntermediateLength(long maxIntermediateLength) {
        this.curMaxTempLength = maxIntermediateLength;
    }

    public FetchResult fetch(FreenetURI uri) throws FetchException {
        if (uri == null) {
            throw new NullPointerException();
        }
        FetchContext context = this.getFetchContext();
        FetchWaiter fw = new FetchWaiter();
        ClientGetter get = new ClientGetter(fw, uri, context, this.priorityClass, (RequestClient)this, null, null);
        try {
            this.core.clientContext.start(get);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
        return fw.waitForCompletion();
    }

    public FetchResult fetch(FreenetURI uri, long overrideMaxSize) throws FetchException {
        return this.fetch(uri, overrideMaxSize, this);
    }

    public FetchResult fetch(FreenetURI uri, long overrideMaxSize, RequestClient clientContext) throws FetchException {
        if (uri == null) {
            throw new NullPointerException();
        }
        FetchWaiter fw = new FetchWaiter();
        FetchContext context = this.getFetchContext(overrideMaxSize);
        ClientGetter get = new ClientGetter(fw, uri, context, this.priorityClass, clientContext, null, null);
        try {
            this.core.clientContext.start(get);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
        return fw.waitForCompletion();
    }

    @Deprecated
    public ClientGetter fetch(FreenetURI uri, long maxSize, RequestClient clientContext, ClientCallback callback, FetchContext fctx) throws FetchException {
        return this.fetch(uri, maxSize, clientContext, (ClientGetCallback)callback, fctx);
    }

    public ClientGetter fetch(FreenetURI uri, long maxSize, RequestClient clientContext, ClientGetCallback callback, FetchContext fctx) throws FetchException {
        if (uri == null) {
            throw new NullPointerException();
        }
        ClientGetter get = new ClientGetter(callback, uri, fctx, this.priorityClass, clientContext, null, null);
        try {
            this.core.clientContext.start(get);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
        return get;
    }

    public FreenetURI insert(InsertBlock insert, boolean getCHKOnly, String filenameHint) throws InsertException {
        return this.insert(insert, getCHKOnly, filenameHint, false);
    }

    public FreenetURI insert(InsertBlock insert, boolean getCHKOnly, String filenameHint, boolean isMetadata) throws InsertException {
        InsertContext context = this.getInsertContext(true);
        PutWaiter pw = new PutWaiter();
        ClientPutter put = new ClientPutter(pw, insert.getData(), insert.desiredURI, insert.clientMetadata, context, this.priorityClass, getCHKOnly, isMetadata, (RequestClient)this, null, filenameHint, false);
        try {
            this.core.clientContext.start(put, false);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
        return pw.waitForCompletion();
    }

    @Deprecated
    public ClientPutter insert(InsertBlock insert, boolean getCHKOnly, String filenameHint, boolean isMetadata, InsertContext ctx, ClientCallback cb) throws InsertException {
        return this.insert(insert, getCHKOnly, filenameHint, isMetadata, ctx, (ClientPutCallback)cb);
    }

    public ClientPutter insert(InsertBlock insert, boolean getCHKOnly, String filenameHint, boolean isMetadata, InsertContext ctx, ClientPutCallback cb) throws InsertException {
        ClientPutter put = new ClientPutter(cb, insert.getData(), insert.desiredURI, insert.clientMetadata, ctx, this.priorityClass, getCHKOnly, isMetadata, (RequestClient)this, null, filenameHint, false);
        try {
            this.core.clientContext.start(put, false);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
        return put;
    }

    public FreenetURI insertRedirect(FreenetURI insertURI, FreenetURI targetURI) throws InsertException {
        Bucket b;
        Metadata m = new Metadata(0, null, null, targetURI, new ClientMetadata());
        try {
            b = BucketTools.makeImmutableBucket(this.bucketFactory, m.writeToByteArray());
        }
        catch (IOException e) {
            Logger.error(this, "Bucket error: " + e, e);
            throw new InsertException(3, e, null);
        }
        catch (MetadataUnresolvedException e) {
            Logger.error(this, "Impossible error: " + e, e);
            throw new InsertException(3, e, null);
        }
        InsertBlock block = new InsertBlock(b, null, insertURI);
        return this.insert(block, false, null, true);
    }

    public FreenetURI insertManifest(FreenetURI insertURI, HashMap bucketsByName, String defaultName) throws InsertException {
        PutWaiter pw = new PutWaiter();
        SimpleManifestPutter putter = new SimpleManifestPutter(pw, SimpleManifestPutter.bucketsByNameToManifestEntries(bucketsByName), this.priorityClass, insertURI, defaultName, this.getInsertContext(true), false, this, false);
        try {
            this.core.clientContext.start(putter);
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
        return pw.waitForCompletion();
    }

    public void addGlobalHook(ClientEventListener listener) {
        this.addEventHook(listener);
    }

    public void addEventHook(ClientEventListener listener) {
        this.eventProducer.addEventListener(listener);
    }

    public FetchContext getFetchContext() {
        return this.getFetchContext(-1L);
    }

    public FetchContext getFetchContext(long overrideMaxSize) {
        long maxLength = this.curMaxLength;
        long maxTempLength = this.curMaxTempLength;
        if (overrideMaxSize >= 0L) {
            maxLength = overrideMaxSize;
            maxTempLength = overrideMaxSize;
        }
        return new FetchContext(maxLength, maxTempLength, this.curMaxMetadataLength, 10, 2, 4, true, 20, SPLITFILE_BLOCK_RETRIES, NON_SPLITFILE_RETRIES, 2, true, true, false, 1024, 1536, this.bucketFactory, this.eventProducer, this.cacheLocalRequests, false);
    }

    public InsertContext getInsertContext(boolean forceNonPersistent) {
        return new InsertContext(this.bucketFactory, forceNonPersistent ? this.bucketFactory : this.persistentBucketFactory, forceNonPersistent ? NullPersistentFileTracker.getInstance() : this.persistentFileTracker, 10, 2, 20, 128, 128, this.eventProducer, this.cacheLocalRequests);
    }

    public FreenetURI[] generateKeyPair(String docName) {
        InsertableClientSSK key = InsertableClientSSK.createRandom(this.random, docName);
        return new FreenetURI[]{key.getInsertURI(), key.getURI()};
    }

    public void prefetch(FreenetURI uri, long timeout, long maxSize, Set allowedTypes) {
        this.prefetch(uri, timeout, maxSize, allowedTypes, (short)5);
    }

    public void prefetch(FreenetURI uri, long timeout, long maxSize, Set allowedTypes, short prio) {
        FetchContext ctx = this.getFetchContext(maxSize);
        ctx.allowedMIMETypes = allowedTypes;
        final ClientGetter get = new ClientGetter(this.nullCallback, uri, ctx, prio, (RequestClient)this, (Bucket)new NullBucket(), null);
        this.core.getTicker().queueTimedJob(new Runnable(){

            public void run() {
                get.cancel(null, ((HighLevelSimpleClientImpl)HighLevelSimpleClientImpl.this).core.clientContext);
            }
        }, timeout);
        try {
            this.core.clientContext.start(get);
        }
        catch (FetchException e) {
        }
        catch (DatabaseDisabledException e) {
            // empty catch block
        }
    }

    public boolean persistent() {
        return false;
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

