/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveRestartException;
import freenet.client.FailureCodeTracker;
import freenet.client.MetadataParseException;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.support.Logger;

public class FetchException
extends Exception {
    private static volatile boolean logMINOR;
    private static final long serialVersionUID = -1106716067841151962L;
    public final int mode;
    public final FreenetURI newURI;
    public final long expectedSize;
    String expectedMimeType;
    boolean finalizedSizeAndMimeType;
    public final FailureCodeTracker errorCodes;
    public final String extraMessage;
    @Deprecated
    public static final int TOO_DEEP_ARCHIVE_RECURSION = 1;
    @Deprecated
    public static final int UNKNOWN_SPLITFILE_METADATA = 2;
    @Deprecated
    public static final int TOO_MANY_REDIRECTS = 16;
    public static final int UNKNOWN_METADATA = 3;
    public static final int INVALID_METADATA = 4;
    public static final int ARCHIVE_FAILURE = 5;
    public static final int BLOCK_DECODE_ERROR = 6;
    @Deprecated
    public static final int TOO_MANY_METADATA_LEVELS = 7;
    public static final int TOO_MANY_ARCHIVE_RESTARTS = 8;
    public static final int TOO_MUCH_RECURSION = 9;
    public static final int NOT_IN_ARCHIVE = 10;
    public static final int TOO_MANY_PATH_COMPONENTS = 11;
    public static final int BUCKET_ERROR = 12;
    public static final int DATA_NOT_FOUND = 13;
    public static final int ALL_DATA_NOT_FOUND = 28;
    public static final int ROUTE_NOT_FOUND = 14;
    public static final int REJECTED_OVERLOAD = 15;
    public static final int INTERNAL_ERROR = 17;
    public static final int TRANSFER_FAILED = 18;
    public static final int SPLITFILE_ERROR = 19;
    public static final int INVALID_URI = 20;
    public static final int TOO_BIG = 21;
    public static final int TOO_BIG_METADATA = 22;
    public static final int TOO_MANY_BLOCKS_PER_SEGMENT = 23;
    public static final int NOT_ENOUGH_PATH_COMPONENTS = 24;
    public static final int CANCELLED = 25;
    public static final int ARCHIVE_RESTART = 26;
    public static final int PERMANENT_REDIRECT = 27;
    public static final int WRONG_MIME_TYPE = 29;
    public static final int RECENTLY_FAILED = 30;

    public String getExpectedMimeType() {
        return this.expectedMimeType;
    }

    public boolean finalizedSize() {
        return this.finalizedSizeAndMimeType;
    }

    public int getMode() {
        return this.mode;
    }

    public FetchException(int m) {
        super(FetchException.getMessage(m));
        if (m == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = null;
        this.mode = m;
        this.errorCodes = null;
        this.newURI = null;
        this.expectedSize = -1L;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int m, long expectedSize, boolean finalizedSize, String expectedMimeType) {
        super(FetchException.getMessage(m));
        if (m == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = null;
        this.finalizedSizeAndMimeType = finalizedSize;
        this.mode = m;
        this.errorCodes = null;
        this.newURI = null;
        this.expectedSize = expectedSize;
        this.expectedMimeType = expectedMimeType;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int m, long expectedSize, boolean finalizedSize, String expectedMimeType, FreenetURI uri) {
        super(FetchException.getMessage(m));
        if (m == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = null;
        this.finalizedSizeAndMimeType = finalizedSize;
        this.mode = m;
        this.errorCodes = null;
        this.newURI = uri;
        this.expectedSize = expectedSize;
        this.expectedMimeType = expectedMimeType;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(MetadataParseException e) {
        super(FetchException.getMessage(4) + ": " + e.getMessage());
        this.extraMessage = e.getMessage();
        this.mode = 4;
        this.errorCodes = null;
        this.initCause(e);
        this.newURI = null;
        this.expectedSize = -1L;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(ArchiveFailureException e) {
        super(FetchException.getMessage(5) + ": " + e.getMessage());
        this.extraMessage = e.getMessage();
        this.mode = 5;
        this.errorCodes = null;
        this.newURI = null;
        this.initCause(e);
        this.expectedSize = -1L;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(ArchiveRestartException e) {
        super(FetchException.getMessage(26) + ": " + e.getMessage());
        this.extraMessage = e.getMessage();
        this.mode = 5;
        this.errorCodes = null;
        this.initCause(e);
        this.newURI = null;
        this.expectedSize = -1L;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int mode, Throwable t) {
        super(FetchException.getMessage(mode) + ": " + t.getMessage());
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = t.getMessage();
        this.mode = mode;
        this.errorCodes = null;
        this.initCause(t);
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int mode, String reason, Throwable t) {
        super(reason + " : " + FetchException.getMessage(mode) + ": " + t.getMessage());
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = t.getMessage();
        this.mode = mode;
        this.errorCodes = null;
        this.initCause(t);
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int mode, FailureCodeTracker errorCodes) {
        super(FetchException.getMessage(mode));
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = null;
        this.mode = mode;
        this.errorCodes = errorCodes;
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int mode, String msg) {
        super(FetchException.getMessage(mode) + ": " + msg);
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = msg;
        this.errorCodes = null;
        this.mode = mode;
        this.newURI = null;
        this.expectedSize = -1L;
        if (mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int mode, FreenetURI newURI) {
        super(FetchException.getMessage(mode));
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = null;
        this.mode = mode;
        this.errorCodes = null;
        this.newURI = newURI;
        this.expectedSize = -1L;
        if (mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(int mode, String msg, FreenetURI uri) {
        super(FetchException.getMessage(mode) + ": " + msg);
        if (mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.extraMessage = msg;
        this.errorCodes = null;
        this.mode = mode;
        this.newURI = uri;
        this.expectedSize = -1L;
        if (mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchException e, int newMode) {
        super(FetchException.getMessage(newMode) + (e.extraMessage != null ? ": " + e.extraMessage : ""));
        if (newMode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.mode = newMode;
        this.newURI = e.newURI;
        this.errorCodes = e.errorCodes;
        this.expectedMimeType = e.expectedMimeType;
        this.expectedSize = e.expectedSize;
        this.extraMessage = e.extraMessage;
        this.finalizedSizeAndMimeType = e.finalizedSizeAndMimeType;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchException e, FreenetURI uri) {
        super(e.getMessage());
        if (e.getCause() != null) {
            this.initCause(e.getCause());
        }
        if (e.mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.mode = e.mode;
        this.newURI = uri;
        this.errorCodes = e.errorCodes;
        this.expectedMimeType = e.expectedMimeType;
        this.expectedSize = e.expectedSize;
        this.extraMessage = e.extraMessage;
        this.finalizedSizeAndMimeType = e.finalizedSizeAndMimeType;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public FetchException(FetchException e) {
        super(e.getMessage());
        this.initCause(e);
        if (e.mode == 0) {
            Logger.error(this, "Can't increment failure mode 0, not a valid mode", new Exception("error"));
        }
        this.mode = e.mode;
        this.newURI = e.newURI == null ? null : e.newURI.clone();
        this.errorCodes = e.errorCodes == null ? null : e.errorCodes.clone();
        this.expectedMimeType = e.expectedMimeType;
        this.expectedSize = e.expectedSize;
        this.extraMessage = e.extraMessage;
        this.finalizedSizeAndMimeType = e.finalizedSizeAndMimeType;
        if (this.mode == 17) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "FetchException(" + FetchException.getMessage(this.mode) + ')', (Throwable)this);
        }
    }

    public static String getShortMessage(int mode) {
        String ret = L10n.getString("FetchException.shortError." + mode);
        if (ret == null) {
            return "Unknown code " + mode;
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("FetchException:");
        sb.append(FetchException.getShortMessage(this.mode));
        sb.append(':');
        sb.append(this.newURI);
        sb.append(':');
        sb.append(this.expectedSize);
        sb.append(':');
        sb.append(this.expectedMimeType);
        sb.append(':');
        sb.append(this.finalizedSizeAndMimeType);
        sb.append(':');
        sb.append(this.errorCodes);
        sb.append(':');
        sb.append(this.extraMessage);
        return sb.toString();
    }

    public static String getMessage(int mode) {
        String ret = L10n.getString("FetchException.longError." + mode);
        if (ret == null) {
            return "Unknown fetch error code: " + mode;
        }
        return ret;
    }

    public boolean isFatal() {
        return FetchException.isFatal(this.mode);
    }

    public static boolean isFatal(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 28: 
            case 30: {
                return false;
            }
            case 12: 
            case 17: {
                return true;
            }
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                return true;
            }
        }
        Logger.error(FetchException.class, "Do not know if error code is fatal: " + FetchException.getMessage(mode));
        return false;
    }

    public void setNotFinalizedSize() {
        this.finalizedSizeAndMimeType = false;
    }

    public void removeFrom(ObjectContainer container) {
        StackTraceElement[] elements;
        if (this.errorCodes != null) {
            this.errorCodes.removeFrom(container);
        }
        if (this.newURI != null) {
            this.newURI.removeFrom(container);
        }
        if ((elements = this.getStackTrace()) != null) {
            for (StackTraceElement element : elements) {
                container.delete((Object)element);
            }
        }
        container.delete((Object)this);
    }

    public FetchException clone() {
        return new FetchException(this);
    }

    static {
        Logger.registerClass(FetchException.class);
    }
}

