/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.async.BlockSet;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.SimpleEventProducer;
import freenet.support.api.BucketFactory;
import java.util.Set;

public class FetchContext
implements Cloneable {
    public static final int IDENTICAL_MASK = 0;
    public static final int SPLITFILE_DEFAULT_BLOCK_MASK = 1;
    public static final int SPLITFILE_DEFAULT_MASK = 2;
    public static final int SET_RETURN_ARCHIVES = 4;
    public long maxOutputLength;
    public long maxTempLength;
    public int maxRecursionLevel;
    public int maxArchiveRestarts;
    public int maxArchiveLevels;
    public boolean dontEnterImplicitArchives;
    public int maxSplitfileThreads;
    public int maxSplitfileBlockRetries;
    public int maxNonSplitfileRetries;
    public final int maxUSKRetries;
    public boolean allowSplitfiles;
    public boolean followRedirects;
    public boolean localRequestOnly;
    public boolean ignoreStore;
    public final ClientEventProducer eventProducer;
    public int maxMetadataSize;
    public int maxDataBlocksPerSegment;
    public int maxCheckBlocksPerSegment;
    public boolean cacheLocalRequests;
    public boolean returnZIPManifests;
    public final boolean ignoreTooManyPathComponents;
    public final BlockSet blocks;
    public Set allowedMIMETypes;
    private final boolean hasOwnEventProducer;

    public FetchContext(long curMaxLength, long curMaxTempLength, int maxMetadataSize, int maxRecursionLevel, int maxArchiveRestarts, int maxArchiveLevels, boolean dontEnterImplicitArchives, int maxSplitfileThreads, int maxSplitfileBlockRetries, int maxNonSplitfileRetries, int maxUSKRetries, boolean allowSplitfiles, boolean followRedirects, boolean localRequestOnly, int maxDataBlocksPerSegment, int maxCheckBlocksPerSegment, BucketFactory bucketFactory, ClientEventProducer producer, boolean cacheLocalRequests, boolean ignoreTooManyPathComponents) {
        this.blocks = null;
        this.maxOutputLength = curMaxLength;
        this.maxTempLength = curMaxTempLength;
        this.maxMetadataSize = maxMetadataSize;
        this.maxRecursionLevel = maxRecursionLevel;
        this.maxArchiveRestarts = maxArchiveRestarts;
        this.maxArchiveLevels = maxArchiveLevels;
        this.dontEnterImplicitArchives = dontEnterImplicitArchives;
        this.maxSplitfileThreads = maxSplitfileThreads;
        this.maxSplitfileBlockRetries = maxSplitfileBlockRetries;
        this.maxNonSplitfileRetries = maxNonSplitfileRetries;
        this.maxUSKRetries = maxUSKRetries;
        this.allowSplitfiles = allowSplitfiles;
        this.followRedirects = followRedirects;
        this.localRequestOnly = localRequestOnly;
        this.eventProducer = producer;
        this.maxDataBlocksPerSegment = maxDataBlocksPerSegment;
        this.maxCheckBlocksPerSegment = maxCheckBlocksPerSegment;
        this.cacheLocalRequests = cacheLocalRequests;
        this.ignoreTooManyPathComponents = ignoreTooManyPathComponents;
        this.hasOwnEventProducer = true;
    }

    public FetchContext(FetchContext ctx, int maskID, boolean keepProducer, BlockSet blocks) {
        this.eventProducer = keepProducer ? ctx.eventProducer : new SimpleEventProducer();
        this.hasOwnEventProducer = !keepProducer;
        this.ignoreTooManyPathComponents = ctx.ignoreTooManyPathComponents;
        this.blocks = blocks != null ? blocks : ctx.blocks;
        this.allowedMIMETypes = ctx.allowedMIMETypes;
        this.maxUSKRetries = ctx.maxUSKRetries;
        this.cacheLocalRequests = ctx.cacheLocalRequests;
        this.localRequestOnly = ctx.localRequestOnly;
        this.maxArchiveLevels = ctx.maxArchiveLevels;
        this.maxMetadataSize = ctx.maxMetadataSize;
        this.maxNonSplitfileRetries = ctx.maxNonSplitfileRetries;
        this.maxOutputLength = ctx.maxOutputLength;
        this.maxSplitfileBlockRetries = ctx.maxSplitfileBlockRetries;
        this.maxTempLength = ctx.maxTempLength;
        this.allowSplitfiles = ctx.allowSplitfiles;
        this.dontEnterImplicitArchives = ctx.dontEnterImplicitArchives;
        this.followRedirects = ctx.followRedirects;
        this.maxArchiveRestarts = ctx.maxArchiveRestarts;
        this.maxCheckBlocksPerSegment = ctx.maxCheckBlocksPerSegment;
        this.maxDataBlocksPerSegment = ctx.maxDataBlocksPerSegment;
        this.maxRecursionLevel = ctx.maxRecursionLevel;
        this.maxSplitfileThreads = ctx.maxSplitfileThreads;
        this.returnZIPManifests = ctx.returnZIPManifests;
        if (maskID != 0 && maskID != 2) {
            if (maskID == 1) {
                this.maxRecursionLevel = 1;
                this.maxArchiveRestarts = 0;
                this.dontEnterImplicitArchives = true;
                this.maxSplitfileThreads = 0;
                this.allowSplitfiles = false;
                this.followRedirects = false;
                this.maxDataBlocksPerSegment = 0;
                this.maxCheckBlocksPerSegment = 0;
                this.returnZIPManifests = false;
            } else if (maskID == 4) {
                this.returnZIPManifests = true;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public FetchContext clone() {
        try {
            return (FetchContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void removeFrom(ObjectContainer container) {
        if (this.hasOwnEventProducer) {
            container.activate((Object)this.eventProducer, 1);
            this.eventProducer.removeFrom(container);
        }
        container.delete((Object)this);
    }
}

