/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Constraint;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.StandardOnionFECCodec;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.OOMHook;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;

public class FECQueue
implements OOMHook {
    private transient LinkedList<FECJob>[] transientQueue;
    private transient LinkedList<FECJob>[] persistentQueueCache;
    private transient int maxPersistentQueueCacheSize;
    private transient int priorities;
    private transient DBJobRunner databaseJobRunner;
    private transient Executor executor;
    private transient ClientContext clientContext;
    private transient int runningFECThreads;
    private transient int fecPoolCounter;
    private transient PrioRunnable runner;
    private transient DBJob cacheFillerJob;
    private final long nodeDBHandle;
    private int maxRunningFECThreads = -1;

    public static FECQueue create(final long nodeDBHandle, ObjectContainer container) {
        ObjectSet result = container.query((Predicate)new Predicate<FECQueue>(){

            public boolean match(FECQueue queue) {
                return queue.nodeDBHandle == nodeDBHandle;
            }
        });
        if (result.hasNext()) {
            FECQueue queue = (FECQueue)result.next();
            container.activate((Object)queue, 1);
            return queue;
        }
        FECQueue queue = new FECQueue(nodeDBHandle);
        container.store((Object)queue);
        return queue;
    }

    public FECQueue(long nodeDBHandle) {
        this.nodeDBHandle = nodeDBHandle;
    }

    public void init(int priorities, int maxCacheSize, DBJobRunner dbJobRunner, Executor exec, ClientContext clientContext) {
        this.priorities = priorities;
        this.maxPersistentQueueCacheSize = maxCacheSize;
        this.databaseJobRunner = dbJobRunner;
        this.executor = exec;
        this.clientContext = clientContext;
        this.transientQueue = new LinkedList[priorities];
        this.persistentQueueCache = new LinkedList[priorities];
        for (int i = 0; i < priorities; ++i) {
            this.transientQueue[i] = new LinkedList();
            this.persistentQueueCache[i] = new LinkedList();
        }
        this.maxRunningFECThreads = this.getMaxRunningFECThreads();
        OOMHandler.addOOMHook(this);
        this.initRunner();
        this.initCacheFillerJob();
        this.queueCacheFiller();
    }

    private void queueCacheFiller() {
        try {
            this.databaseJobRunner.queue(this.cacheFillerJob, 5, false);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(FECJob job, FECCodec codec, ObjectContainer container) {
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(StandardOnionFECCodec.class, "Adding a new job to the queue: " + job + ".");
        }
        int maxThreads = this.getMaxRunningFECThreads();
        if (job.persistent) {
            job.activateForExecution(container);
            container.store((Object)job);
        }
        boolean kept = false;
        FECQueue fECQueue = this;
        synchronized (fECQueue) {
            if (!job.persistent) {
                this.transientQueue[job.priority].addLast(job);
                kept = true;
            } else {
                int totalAbove = 0;
                for (int i = 0; i < job.priority; ++i) {
                    totalAbove += this.persistentQueueCache[i].size();
                }
                if (totalAbove >= this.maxPersistentQueueCacheSize) {
                    if (logMINOR) {
                        Logger.minor(this, "Not adding persistent job to in-RAM cache, too many above it");
                    }
                } else if (totalAbove + this.persistentQueueCache[job.priority].size() >= this.maxPersistentQueueCacheSize) {
                    if (logMINOR) {
                        Logger.minor(this, "Not adding persistent job to in-RAM cache, too many at same priority");
                    }
                } else {
                    this.persistentQueueCache[job.priority].addLast(job);
                    kept = true;
                    int total = totalAbove + this.persistentQueueCache[job.priority].size();
                    for (int i = job.priority + 1; i < this.priorities; ++i) {
                        total += this.persistentQueueCache[i].size();
                        while (total >= this.maxPersistentQueueCacheSize && !this.persistentQueueCache[i].isEmpty()) {
                            if (logMINOR) {
                                Logger.minor(this, "Removing low priority job from cache, total now " + total);
                            }
                            this.persistentQueueCache[i].removeLast();
                            --total;
                        }
                    }
                }
            }
            if (!kept) {
                if (logMINOR) {
                    Logger.minor(this, "Deactivating job " + job);
                }
                job.deactivate(container);
            }
            if (this.runningFECThreads < maxThreads) {
                this.executor.execute(this.runner, "FEC Pool(" + this.fecPoolCounter++ + ")");
                ++this.runningFECThreads;
            }
            this.notifyAll();
        }
    }

    private void initRunner() {
        this.runner = new PrioRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Logger.OSThread.logPID(this);
                block17: while (true) {
                    try {
                        try {
                            while (true) {
                                FECJob job;
                                FECQueue fECQueue = FECQueue.this;
                                synchronized (fECQueue) {
                                    job = FECQueue.this.getFECJobBlockingNoDBAccess();
                                    job.running = true;
                                }
                                if (Logger.shouldLog(4, this)) {
                                    Logger.minor(this, "Running job " + job);
                                }
                                try {
                                    if (job.isADecodingJob) {
                                        job.getCodec().realDecode(job.dataBlockStatus, job.checkBlockStatus, job.blockLength, job.bucketFactory);
                                    } else {
                                        job.getCodec().realEncode(job.dataBlocks, job.checkBlocks, job.blockLength, job.bucketFactory);
                                        if (job.dataBlockStatus != null || job.checkBlockStatus != null) {
                                            int i;
                                            for (i = 0; i < job.dataBlocks.length; ++i) {
                                                job.dataBlockStatus[i].setData(job.dataBlocks[i]);
                                            }
                                            for (i = 0; i < job.checkBlocks.length; ++i) {
                                                job.checkBlockStatus[i].setData(job.checkBlocks[i]);
                                            }
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    Logger.error(this, "BOH! ioe:" + e.getMessage(), e);
                                }
                                try {
                                    int prio;
                                    if (!job.persistent) {
                                        if (job.isADecodingJob) {
                                            job.callback.onDecodedSegment(null, FECQueue.this.clientContext, job, job.dataBlocks, job.checkBlocks, job.dataBlockStatus, job.checkBlockStatus);
                                            continue block17;
                                        }
                                        job.callback.onEncodedSegment(null, FECQueue.this.clientContext, job, job.dataBlocks, job.checkBlocks, job.dataBlockStatus, job.checkBlockStatus);
                                        continue block17;
                                    }
                                    if (Logger.shouldLog(4, this)) {
                                        Logger.minor(this, "Scheduling callback for " + job + "...");
                                    }
                                    int n = prio = job.isADecodingJob ? 6 : 5;
                                    if (job.priority > 2) {
                                        --prio;
                                    }
                                    if (job.priority >= 4) {
                                        --prio;
                                    }
                                    FECQueue.this.databaseJobRunner.queue(new DBJob(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public boolean run(ObjectContainer container, ClientContext context) {
                                            job.storeBlockStatuses(container);
                                            Logger.minor(this, "Activating " + job.callback + " is active=" + container.ext().isActive((Object)job.callback));
                                            container.activate((Object)job.callback, 1);
                                            if (Logger.shouldLog(4, this)) {
                                                Logger.minor(this, "Running callback for " + job);
                                            }
                                            try {
                                                if (job.isADecodingJob) {
                                                    job.callback.onDecodedSegment(container, FECQueue.this.clientContext, job, job.dataBlocks, job.checkBlocks, job.dataBlockStatus, job.checkBlockStatus);
                                                } else {
                                                    job.callback.onEncodedSegment(container, FECQueue.this.clientContext, job, job.dataBlocks, job.checkBlocks, job.dataBlockStatus, job.checkBlockStatus);
                                                }
                                            }
                                            catch (Throwable t) {
                                                Logger.error(this, "Caught " + t + " in FECQueue callback", t);
                                            }
                                            finally {
                                                container.delete((Object)job);
                                            }
                                            if (container.ext().isStored((Object)job.callback)) {
                                                container.deactivate((Object)job.callback, 1);
                                            }
                                            return true;
                                        }
                                    }, prio, false);
                                    if (!Logger.shouldLog(4, this)) continue block17;
                                    Logger.minor(this, "Scheduled callback for " + job + "...");
                                    continue block17;
                                }
                                catch (Throwable e) {
                                    Logger.error(this, "The callback failed!" + e, e);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Caught " + t + " in " + this, t);
                            FECQueue fECQueue = FECQueue.this;
                            synchronized (fECQueue) {
                                FECQueue.this.runningFECThreads--;
                                break;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        FECQueue fECQueue = FECQueue.this;
                        synchronized (fECQueue) {
                            FECQueue.this.runningFECThreads--;
                        }
                        throw throwable;
                    }
                }
            }

            public int getPriority() {
                return 3;
            }
        };
    }

    private void initCacheFillerJob() {
        this.cacheFillerJob = new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                boolean logMINOR = Logger.shouldLog(4, this);
                if (logMINOR) {
                    Logger.minor(this, "Running FEC cache filler job");
                }
                while (true) {
                    boolean addedAny = false;
                    int totalCached = 0;
                    for (short prio = 0; prio < FECQueue.this.priorities; prio = (short)(prio + 1)) {
                        int grab = 0;
                        FECQueue fECQueue = FECQueue.this;
                        synchronized (fECQueue) {
                            int newCached = totalCached + FECQueue.this.persistentQueueCache[prio].size();
                            if (newCached >= FECQueue.this.maxPersistentQueueCacheSize) {
                                return false;
                            }
                            grab = FECQueue.this.maxPersistentQueueCacheSize - newCached;
                            totalCached = newCached;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Grabbing up to " + grab + " jobs at priority " + prio);
                        }
                        Query query = container.query();
                        query.constrain(FECJob.class);
                        Constraint con = query.descend("priority").constrain((Object)prio);
                        con.and(query.descend("queue").constrain((Object)FECQueue.this).identity());
                        query.descend("addedTime").orderAscending();
                        ObjectSet results = query.execute();
                        if (!results.hasNext()) continue;
                        for (int j = 0; j < grab && results.hasNext(); ++j) {
                            FECJob job = (FECJob)results.next();
                            job.activateForExecution(container);
                            if (job.isCancelled(container)) {
                                container.delete((Object)job);
                                continue;
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Maybe adding " + job);
                            }
                            FECQueue fECQueue2 = FECQueue.this;
                            synchronized (fECQueue2) {
                                if (job.running) {
                                    --j;
                                    if (logMINOR) {
                                        Logger.minor(this, "Not adding, already running: " + job);
                                    }
                                    continue;
                                }
                                if (FECQueue.this.persistentQueueCache[prio].contains(job)) {
                                    --j;
                                    if (logMINOR) {
                                        Logger.minor(this, "Not adding as on persistent queue cache for " + prio + " : " + job);
                                    }
                                    continue;
                                }
                                boolean added = false;
                                ListIterator<FECJob> it = FECQueue.this.persistentQueueCache[prio].listIterator();
                                while (it.hasNext()) {
                                    FECJob cmp = (FECJob)it.next();
                                    if (cmp.addedTime < job.addedTime) continue;
                                    it.previous();
                                    it.add(job);
                                    added = true;
                                    if (!logMINOR) break;
                                    Logger.minor(this, "Adding " + job + " before " + it);
                                    break;
                                }
                                if (!added) {
                                    FECQueue.this.persistentQueueCache[prio].addLast(job);
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Added " + job);
                                }
                                addedAny = true;
                                continue;
                            }
                        }
                    }
                    if (!addedAny) {
                        if (logMINOR) {
                            Logger.minor(this, "No more jobs to add");
                        }
                        return false;
                    }
                    FECQueue fECQueue = FECQueue.this;
                    synchronized (fECQueue) {
                        int maxRunningThreads = FECQueue.this.maxRunningFECThreads;
                        if (FECQueue.this.runningFECThreads < maxRunningThreads) {
                            int queueSize = 0;
                            for (int i = 0; i < FECQueue.this.priorities && (queueSize += FECQueue.this.persistentQueueCache[i].size()) + FECQueue.this.runningFECThreads <= maxRunningThreads; ++i) {
                            }
                            if (queueSize + FECQueue.this.runningFECThreads < maxRunningThreads) {
                                maxRunningThreads = queueSize + FECQueue.this.runningFECThreads;
                            }
                            while (FECQueue.this.runningFECThreads < maxRunningThreads) {
                                FECQueue.this.executor.execute(FECQueue.this.runner, "FEC Pool " + FECQueue.this.fecPoolCounter++);
                                FECQueue.this.runningFECThreads++;
                            }
                        }
                        FECQueue.this.notifyAll();
                    }
                }
            }
        };
    }

    private synchronized int getMaxRunningFECThreads() {
        if (this.maxRunningFECThreads != -1) {
            return this.maxRunningFECThreads;
        }
        String osName = System.getProperty("os.name");
        if (!(osName.indexOf("Windows") != -1 || osName.toLowerCase().indexOf("mac os x") <= 0 && NativeThread.usingNativeCode())) {
            this.maxRunningFECThreads = 1;
        } else {
            Runtime r = Runtime.getRuntime();
            int max = r.availableProcessors();
            long maxMemory = r.maxMemory();
            max = maxMemory < 0x10000000L ? 1 : Math.min(3, Math.min(max, (int)Math.min(Integer.MAX_VALUE, maxMemory / 0x8000000L)));
            this.maxRunningFECThreads = max;
        }
        Logger.minor(FECCodec.class, "Maximum FEC threads: " + this.maxRunningFECThreads);
        return this.maxRunningFECThreads;
    }

    protected synchronized FECJob getFECJobBlockingNoDBAccess() {
        while (this.runningFECThreads <= this.getMaxRunningFECThreads()) {
            for (int i = 0; i < this.priorities; ++i) {
                if (!this.transientQueue[i].isEmpty()) {
                    return this.transientQueue[i].removeFirst();
                }
                if (this.persistentQueueCache[i].isEmpty()) continue;
                return this.persistentQueueCache[i].removeFirst();
            }
            this.queueCacheFiller();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return null;
    }

    public synchronized void handleLowMemory() throws Exception {
        this.maxRunningFECThreads = Math.max(1, this.maxRunningFECThreads - 1);
        this.notify();
    }

    public synchronized void handleOutOfMemory() throws Exception {
        this.maxRunningFECThreads = 1;
        this.notifyAll();
    }

    public void objectOnDeactivate(ObjectContainer container) {
        Logger.error(this, "Attempting to deactivate FECQueue!", new Exception("debug"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(FECJob job, ObjectContainer container, ClientContext context) {
        Object object = this;
        synchronized (object) {
            for (int i = 0; i < this.priorities; ++i) {
                this.transientQueue[i].remove(job);
                this.persistentQueueCache[i].remove(job);
            }
        }
        object = job;
        synchronized (object) {
            if (job.running) {
                return false;
            }
        }
        if (job.persistent) {
            container.delete((Object)job);
        }
        return true;
    }
}

