/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.FECCallback;
import freenet.client.FECCodec;
import freenet.client.FECQueue;
import freenet.client.SplitfileBlock;
import freenet.client.async.ClientContext;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;

public class FECJob {
    private transient FECCodec codec;
    private final short fecAlgo;
    final Bucket[] dataBlocks;
    final Bucket[] checkBlocks;
    final SplitfileBlock[] dataBlockStatus;
    final SplitfileBlock[] checkBlockStatus;
    final BucketFactory bucketFactory;
    final int blockLength;
    final FECCallback callback;
    final boolean isADecodingJob;
    final long addedTime;
    final short priority;
    final boolean persistent;
    final FECQueue queue;
    private final int hashCode;
    transient boolean running;

    public int hashCode() {
        return this.hashCode;
    }

    public FECJob(FECCodec codec, FECQueue queue, SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus, int blockLength, BucketFactory bucketFactory, FECCallback callback, boolean isADecodingJob, short priority, boolean persistent) {
        int i;
        this.codec = codec;
        this.fecAlgo = codec.getAlgorithm();
        this.queue = queue;
        this.priority = priority;
        this.addedTime = System.currentTimeMillis();
        this.dataBlockStatus = new SplitfileBlock[dataBlockStatus.length];
        this.checkBlockStatus = new SplitfileBlock[checkBlockStatus.length];
        for (i = 0; i < dataBlockStatus.length; ++i) {
            this.dataBlockStatus[i] = dataBlockStatus[i];
        }
        for (i = 0; i < checkBlockStatus.length; ++i) {
            this.checkBlockStatus[i] = checkBlockStatus[i];
        }
        this.dataBlocks = new Bucket[dataBlockStatus.length];
        this.checkBlocks = new Bucket[checkBlockStatus.length];
        for (i = 0; i < this.dataBlocks.length; ++i) {
            this.dataBlocks[i] = dataBlockStatus[i].getData();
        }
        for (i = 0; i < this.checkBlocks.length; ++i) {
            this.checkBlocks[i] = checkBlockStatus[i].getData();
        }
        this.blockLength = blockLength;
        this.bucketFactory = bucketFactory;
        this.callback = callback;
        this.isADecodingJob = isADecodingJob;
        this.persistent = persistent;
        this.hashCode = super.hashCode();
    }

    public String toString() {
        return super.toString() + ":decode=" + this.isADecodingJob + ":callback=" + this.callback + ":persistent=" + this.persistent;
    }

    public FECJob(FECCodec codec, FECQueue queue, Bucket[] dataBlocks, Bucket[] checkBlocks, int blockLength, BucketFactory bucketFactory, FECCallback callback, boolean isADecodingJob, short priority, boolean persistent) {
        this.hashCode = super.hashCode();
        this.codec = codec;
        this.fecAlgo = codec.getAlgorithm();
        this.queue = queue;
        this.priority = priority;
        this.addedTime = System.currentTimeMillis();
        this.dataBlocks = dataBlocks;
        this.checkBlocks = checkBlocks;
        this.dataBlockStatus = null;
        this.checkBlockStatus = null;
        this.blockLength = blockLength;
        this.bucketFactory = bucketFactory;
        this.callback = callback;
        this.isADecodingJob = isADecodingJob;
        this.persistent = persistent;
    }

    public FECCodec getCodec() {
        if (this.codec == null) {
            this.codec = FECCodec.getCodec(this.fecAlgo, this.dataBlocks.length, this.checkBlocks.length);
            if (this.codec == null) {
                Logger.error(this, "No codec found for algo " + this.fecAlgo + " data blocks length " + this.dataBlocks.length + " check blocks length " + this.checkBlocks.length);
            }
        }
        return this.codec;
    }

    public void activateForExecution(ObjectContainer container) {
        int i;
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "Activating FECJob...");
        }
        if (this.dataBlockStatus != null && logMINOR) {
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                Logger.minor(this, "Data block status " + i + ": " + this.dataBlockStatus[i] + " (before activation)");
            }
        }
        container.activate((Object)this, 2);
        if (this.dataBlockStatus != null) {
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                container.activate((Object)this.dataBlockStatus[i], 2);
            }
        }
        if (this.dataBlockStatus != null && logMINOR) {
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                Logger.minor(this, "Data block status " + i + ": " + this.dataBlockStatus[i] + " (after activation)");
            }
        }
        if (this.checkBlockStatus != null) {
            for (i = 0; i < this.checkBlockStatus.length; ++i) {
                container.activate((Object)this.checkBlockStatus[i], 2);
            }
        }
        if (this.dataBlocks != null) {
            for (i = 0; i < this.dataBlocks.length; ++i) {
                Logger.minor(this, "Data bucket " + i + ": " + this.dataBlocks[i] + " (before activation)");
                container.activate((Object)this.dataBlocks[i], 1);
                Logger.minor(this, "Data bucket " + i + ": " + this.dataBlocks[i] + " (after activation)");
            }
        }
        if (this.checkBlocks != null) {
            for (i = 0; i < this.checkBlocks.length; ++i) {
                container.activate((Object)this.checkBlocks[i], 1);
            }
        }
    }

    public void deactivate(ObjectContainer container) {
        int i;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Deactivating FECJob...");
        }
        if (this.dataBlockStatus != null) {
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                container.deactivate((Object)this.dataBlockStatus[i], 2);
            }
        }
        if (this.checkBlockStatus != null) {
            for (i = 0; i < this.checkBlockStatus.length; ++i) {
                container.deactivate((Object)this.checkBlockStatus[i], 2);
            }
        }
        if (this.dataBlocks != null) {
            for (i = 0; i < this.dataBlocks.length; ++i) {
                container.deactivate((Object)this.dataBlocks[i], 1);
            }
        }
        if (this.checkBlocks != null) {
            for (i = 0; i < this.checkBlocks.length; ++i) {
                container.deactivate((Object)this.checkBlocks[i], 1);
            }
        }
    }

    public void storeBlockStatuses(ObjectContainer container) {
        SplitfileBlock block;
        int i;
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "Storing block statuses");
        }
        if (this.dataBlockStatus != null) {
            for (i = 0; i < this.dataBlockStatus.length; ++i) {
                block = this.dataBlockStatus[i];
                if (logMINOR) {
                    Logger.minor(this, "Storing data block " + i + ": " + block);
                }
                block.storeTo(container);
            }
        }
        if (this.checkBlockStatus != null) {
            for (i = 0; i < this.checkBlockStatus.length; ++i) {
                block = this.checkBlockStatus[i];
                if (logMINOR) {
                    Logger.minor(this, "Storing check block " + i + ": " + block);
                }
                block.storeTo(container);
            }
        }
    }

    public boolean isCancelled(ObjectContainer container) {
        if (this.callback == null) {
            Bucket data;
            for (Bucket bucket : this.dataBlocks) {
                if (bucket == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + bucket);
                bucket.free();
                bucket.removeFrom(container);
            }
            for (Bucket bucket : this.checkBlocks) {
                if (bucket == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + bucket);
                bucket.free();
                bucket.removeFrom(container);
            }
            for (SplitfileBlock splitfileBlock : this.dataBlockStatus) {
                if (splitfileBlock == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + splitfileBlock);
                data = splitfileBlock.getData();
                if (data != null) {
                    Logger.error(this, "Callback is null (deleted??) but data is valid: " + data);
                    data.free();
                    data.removeFrom(container);
                }
                container.delete((Object)splitfileBlock);
            }
            for (SplitfileBlock splitfileBlock : this.checkBlockStatus) {
                if (splitfileBlock == null) continue;
                Logger.error(this, "Callback is null (deleted??) but data is valid: " + splitfileBlock);
                data = splitfileBlock.getData();
                if (data != null) {
                    Logger.error(this, "Callback is null (deleted??) but data is valid: " + data);
                    data.free();
                    data.removeFrom(container);
                }
                container.delete((Object)splitfileBlock);
            }
            return true;
        }
        return false;
    }

    public boolean cancel(ObjectContainer container, ClientContext context) {
        return this.queue.cancel(this, container, context);
    }
}

