/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import com.onionnetworks.fec.FECCode;
import com.onionnetworks.util.Buffer;
import freenet.client.FECJob;
import freenet.client.FECQueue;
import freenet.client.SplitfileBlock;
import freenet.client.StandardOnionFECCodec;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FECCodec {
    private static int STRIPE_SIZE = 4096;
    static boolean logMINOR;
    protected transient FECCode fec;
    protected final int k;
    protected final int n;

    protected abstract void loadFEC();

    protected FECCodec(int k, int n) {
        this.k = k;
        this.n = n;
        if (n == 0 || n < k) {
            throw new IllegalArgumentException("Invalid: k=" + k + " n=" + n);
        }
    }

    public static FECCodec getCodec(short splitfileType, int dataBlocks, int checkBlocks) {
        if (Logger.shouldLog(4, FECCodec.class)) {
            Logger.minor(FECCodec.class, "getCodec: splitfileType=" + splitfileType + " dataBlocks=" + dataBlocks + " checkBlocks=" + checkBlocks);
        }
        if (splitfileType == 0) {
            return null;
        }
        if (splitfileType == 1) {
            return StandardOnionFECCodec.getInstance(dataBlocks, checkBlocks);
        }
        return null;
    }

    public static FECCodec getCodec(short splitfileType, int dataBlocks) {
        if (splitfileType == 0) {
            return null;
        }
        if (splitfileType == 1) {
            int checkBlocks = FECCodec.standardOnionCheckBlocks(dataBlocks);
            return StandardOnionFECCodec.getInstance(dataBlocks, checkBlocks);
        }
        return null;
    }

    private static int standardOnionCheckBlocks(int dataBlocks) {
        int checkBlocks = dataBlocks * 128 / 128;
        if (dataBlocks >= 128) {
            checkBlocks = 128;
        }
        return checkBlocks;
    }

    public static int getCheckBlocks(short splitfileType, int dataBlocks) {
        if (splitfileType == 1) {
            return FECCodec.standardOnionCheckBlocks(dataBlocks);
        }
        return 0;
    }

    public abstract int countCheckBlocks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realDecode(SplitfileBlock[] dataBlockStatus, SplitfileBlock[] checkBlockStatus, int blockLength, BucketFactory bf) throws IOException {
        int i;
        this.loadFEC();
        logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "Doing decode: " + dataBlockStatus.length + " data blocks, " + checkBlockStatus.length + " check blocks, block length " + blockLength + " with " + this, (Throwable)new Exception("debug"));
        }
        if (dataBlockStatus.length + checkBlockStatus.length != this.n) {
            throw new IllegalArgumentException();
        }
        if (dataBlockStatus.length != this.k) {
            throw new IllegalArgumentException();
        }
        Buffer[] packets = new Buffer[this.k];
        Bucket[] buckets = new Bucket[this.n];
        DataInputStream[] readers = new DataInputStream[this.n];
        OutputStream[] writers = new OutputStream[this.k];
        int numberToDecode = 0;
        try {
            byte[] realBuffer = new byte[this.k * STRIPE_SIZE];
            int[] packetIndexes = new int[this.k];
            for (int i2 = 0; i2 < packetIndexes.length; ++i2) {
                packetIndexes[i2] = -1;
            }
            int idx = 0;
            for (int i3 = 0; i3 < this.k; ++i3) {
                packets[i3] = new Buffer(realBuffer, i3 * STRIPE_SIZE, STRIPE_SIZE);
            }
            boolean needDecode = false;
            for (i = 0; i < dataBlockStatus.length; ++i) {
                if (dataBlockStatus[i].getData() != null) continue;
                needDecode = true;
            }
            if (!needDecode) {
                return;
            }
            for (i = 0; i < dataBlockStatus.length; ++i) {
                buckets[i] = dataBlockStatus[i].getData();
                if (buckets[i] == null) {
                    buckets[i] = bf.makeBucket(blockLength);
                    writers[i] = buckets[i].getOutputStream();
                    if (logMINOR) {
                        Logger.minor(this, "writers[" + i + "] != null");
                    }
                    readers[i] = null;
                    ++numberToDecode;
                    continue;
                }
                long sz = buckets[i].size();
                if (sz < (long)blockLength) {
                    if (i == dataBlockStatus.length - 1) continue;
                    throw new IllegalArgumentException("All buckets must be the full size (caller must pad if needed) but data bucket " + i + " of " + dataBlockStatus.length + " (" + dataBlockStatus[i] + ") is " + sz + " not " + blockLength);
                }
                if (logMINOR) {
                    Logger.minor(this, "writers[" + i + "] = null (already filled)");
                }
                writers[i] = null;
                readers[i] = new DataInputStream(buckets[i].getInputStream());
                packetIndexes[idx++] = i;
            }
            for (i = 0; i < checkBlockStatus.length; ++i) {
                buckets[i + this.k] = checkBlockStatus[i].getData();
                if (buckets[i + this.k] == null) {
                    readers[i + this.k] = null;
                    continue;
                }
                readers[i + this.k] = new DataInputStream(buckets[i + this.k].getInputStream());
                if (idx >= this.k) continue;
                packetIndexes[idx++] = i + this.k;
            }
            if (idx < this.k) {
                throw new IllegalArgumentException("Must have at least k packets (k=" + this.k + ",idx=" + idx + ')');
            }
            if (logMINOR) {
                for (i = 0; i < packetIndexes.length; ++i) {
                    Logger.minor(this, "[" + i + "] = " + packetIndexes[i]);
                }
            }
            if (numberToDecode > 0) {
                for (int offset = 0; offset < blockLength; offset += STRIPE_SIZE) {
                    for (int i4 = 0; i4 < this.k; ++i4) {
                        int x = packetIndexes[i4];
                        readers[x].readFully(realBuffer, i4 * STRIPE_SIZE, STRIPE_SIZE);
                    }
                    int[] disposableIndexes = new int[packetIndexes.length];
                    System.arraycopy(packetIndexes, 0, disposableIndexes, 0, packetIndexes.length);
                    this.fec.decode(packets, disposableIndexes);
                    for (int i5 = 0; i5 < this.k; ++i5) {
                        if (writers[i5] == null) continue;
                        writers[i5].write(realBuffer, i5 * STRIPE_SIZE, STRIPE_SIZE);
                    }
                }
            }
        }
        finally {
            for (i = 0; i < this.k; ++i) {
                Closer.close(writers[i]);
            }
            for (i = 0; i < this.n; ++i) {
                Closer.close(readers[i]);
            }
        }
        for (int i6 = 0; i6 < dataBlockStatus.length; ++i6) {
            Bucket data = buckets[i6];
            if (data.size() != (long)blockLength) {
                throw new IllegalStateException("Block " + i6 + ": " + data + " : " + dataBlockStatus[i6] + " length " + data.size() + " whereas blockLength=" + blockLength);
            }
            dataBlockStatus[i6].setData(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realEncode(Bucket[] dataBlockStatus, Bucket[] checkBlockStatus, int blockLength, BucketFactory bf) throws IOException {
        int i;
        this.loadFEC();
        logMINOR = Logger.shouldLog(4, this);
        long memUsedAtStart = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (logMINOR) {
            Logger.minor(this, "Memory in use at start: " + memUsedAtStart + " max=" + Runtime.getRuntime().maxMemory());
            Logger.minor(this, "Doing encode: " + dataBlockStatus.length + " data blocks, " + checkBlockStatus.length + " check blocks, block length " + blockLength + " with " + this);
        }
        if (dataBlockStatus.length + checkBlockStatus.length != this.n || dataBlockStatus.length != this.k) {
            throw new IllegalArgumentException("Data blocks: " + dataBlockStatus.length + ", Check blocks: " + checkBlockStatus.length + ", n: " + this.n + ", k: " + this.k);
        }
        Buffer[] dataPackets = new Buffer[this.k];
        Buffer[] checkPackets = new Buffer[this.n - this.k];
        Bucket[] buckets = new Bucket[this.n];
        DataInputStream[] readers = new DataInputStream[this.k];
        OutputStream[] writers = new OutputStream[this.n - this.k];
        try {
            int i2;
            int[] toEncode = new int[this.n - this.k];
            int numberToEncode = 0;
            byte[] realBuffer = new byte[this.n * STRIPE_SIZE];
            for (i2 = 0; i2 < this.k; ++i2) {
                dataPackets[i2] = new Buffer(realBuffer, i2 * STRIPE_SIZE, STRIPE_SIZE);
            }
            for (i2 = 0; i2 < this.n - this.k; ++i2) {
                checkPackets[i2] = new Buffer(realBuffer, (i2 + this.k) * STRIPE_SIZE, STRIPE_SIZE);
            }
            for (i2 = 0; i2 < dataBlockStatus.length; ++i2) {
                buckets[i2] = dataBlockStatus[i2];
                if (buckets[i2] == null) {
                    throw new NullPointerException("Data bucket " + i2 + " is null!");
                }
                long sz = buckets[i2].size();
                if (sz < (long)blockLength) {
                    throw new IllegalArgumentException("All buckets must be the full size: caller must pad the last one if needed");
                }
                readers[i2] = new DataInputStream(buckets[i2].getInputStream());
            }
            int created = 0;
            for (int i3 = 0; i3 < checkBlockStatus.length; ++i3) {
                buckets[i3 + this.k] = checkBlockStatus[i3];
                if (buckets[i3 + this.k] == null) {
                    buckets[i3 + this.k] = bf.makeBucket(blockLength);
                    writers[i3] = buckets[i3 + this.k].getOutputStream();
                    toEncode[numberToEncode++] = i3 + this.k;
                    ++created;
                    continue;
                }
                writers[i3] = null;
            }
            if (logMINOR) {
                Logger.minor(this, "Created " + created + " check buckets");
            }
            long memUsedBeforeEncodes = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (logMINOR) {
                Logger.minor(this, "Memory in use before encodes: " + memUsedBeforeEncodes);
            }
            if (numberToEncode > 0) {
                for (int offset = 0; offset < blockLength; offset += STRIPE_SIZE) {
                    long memUsedBeforeRead = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    if (logMINOR) {
                        Logger.minor(this, "Memory in use before read: " + memUsedBeforeRead);
                    }
                    for (int i4 = 0; i4 < this.k; ++i4) {
                        readers[i4].readFully(realBuffer, i4 * STRIPE_SIZE, STRIPE_SIZE);
                    }
                    long startTime = System.currentTimeMillis();
                    long memUsedBeforeStripe = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    if (logMINOR) {
                        Logger.minor(this, "Memory in use before stripe: " + memUsedBeforeStripe);
                    }
                    this.fec.encode(dataPackets, checkPackets, toEncode);
                    long memUsedAfterStripe = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    if (logMINOR) {
                        Logger.minor(this, "Memory in use after stripe: " + memUsedAfterStripe);
                    }
                    long endTime = System.currentTimeMillis();
                    if (logMINOR) {
                        Logger.minor(this, "Stripe encode took " + (endTime - startTime) + "ms for k=" + this.k + ", n=" + this.n + ", stripeSize=" + STRIPE_SIZE);
                    }
                    for (int i5 = this.k; i5 < this.n; ++i5) {
                        if (writers[i5 - this.k] == null) continue;
                        writers[i5 - this.k].write(realBuffer, i5 * STRIPE_SIZE, STRIPE_SIZE);
                    }
                }
            }
        }
        finally {
            for (i = 0; i < this.k; ++i) {
                Closer.close(readers[i]);
            }
            for (i = 0; i < this.n - this.k; ++i) {
                Closer.close(writers[i]);
            }
        }
        for (i = 0; i < checkBlockStatus.length; ++i) {
            Bucket data = buckets[i + this.k];
            if (data == null) {
                throw new NullPointerException();
            }
            checkBlockStatus[i] = data;
        }
    }

    public void addToQueue(FECJob job, FECQueue queue, ObjectContainer container) {
        queue.addToQueue(job, this, container);
    }

    public void objectCanDeactivate(ObjectContainer container) {
        Logger.minor(this, "Deactivating " + this, (Throwable)new Exception("debug"));
    }

    public abstract short getAlgorithm();
}

