/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import freenet.client.ArchiveContext;
import freenet.client.ArchiveExtractCallback;
import freenet.client.ArchiveExtractTag;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveHandler;
import freenet.client.ArchiveManager;
import freenet.client.ArchiveRestartException;
import freenet.client.ArchiveStoreContext;
import freenet.client.FetchException;
import freenet.client.MetadataParseException;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import java.io.IOException;

class ArchiveHandlerImpl
implements ArchiveHandler {
    private static volatile boolean logMINOR;
    private final FreenetURI key;
    private boolean forceRefetchArchive;
    ArchiveManager.ARCHIVE_TYPE archiveType;
    Compressor.COMPRESSOR_TYPE compressorType;

    ArchiveHandlerImpl(FreenetURI key, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE ctype, boolean forceRefetchArchive) {
        this.key = key;
        this.archiveType = archiveType;
        this.compressorType = ctype;
        this.forceRefetchArchive = forceRefetchArchive;
    }

    public Bucket get(String internalName, ArchiveContext archiveContext, ArchiveManager manager) throws ArchiveFailureException, ArchiveRestartException, MetadataParseException, FetchException {
        Bucket data;
        archiveContext.doLoopDetection(this.key);
        if (this.forceRefetchArchive) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Checking cache: " + this.key + ' ' + internalName);
        }
        if ((data = manager.getCached(this.key, internalName)) != null) {
            return data;
        }
        return null;
    }

    public Bucket getMetadata(ArchiveContext archiveContext, ArchiveManager manager) throws ArchiveFailureException, ArchiveRestartException, MetadataParseException, FetchException {
        return this.get(".metadata", archiveContext, manager);
    }

    public void extractToCache(Bucket bucket, ArchiveContext actx, String element, ArchiveExtractCallback callback, ArchiveManager manager, ObjectContainer container, ClientContext context) throws ArchiveFailureException, ArchiveRestartException {
        this.forceRefetchArchive = false;
        ArchiveStoreContext ctx = manager.makeContext(this.key, this.archiveType, this.compressorType, false);
        manager.extractToCache(this.key, this.archiveType, this.compressorType, bucket, actx, ctx, element, callback, container, context);
    }

    public ArchiveManager.ARCHIVE_TYPE getArchiveType() {
        return this.archiveType;
    }

    public Compressor.COMPRESSOR_TYPE getCompressorType() {
        return this.compressorType;
    }

    public FreenetURI getKey() {
        return this.key;
    }

    public void extractPersistentOffThread(Bucket bucket, boolean freeBucket, ArchiveContext actx, String element, ArchiveExtractCallback callback, ObjectContainer container, ClientContext context) {
        assert (element != null);
        ArchiveManager manager = context.archiveManager;
        ArchiveExtractTag tag = new ArchiveExtractTag(this, bucket, freeBucket, actx, element, callback, context.nodeDBHandle);
        container.store((Object)tag);
        ArchiveHandlerImpl.runPersistentOffThread(tag, context, manager, context.persistentBucketFactory);
    }

    private static void runPersistentOffThread(final ArchiveExtractTag tag, final ClientContext context, final ArchiveManager manager, final BucketFactory bf) {
        final ProxyCallback proxyCallback = new ProxyCallback();
        if (logMINOR) {
            Logger.minor(ArchiveHandlerImpl.class, "Scheduling off-thread extraction: " + tag.data + " for " + tag.handler.key + " element " + tag.element + " for " + tag.callback, (Throwable)new Exception("debug"));
        }
        context.mainExecutor.execute(new Runnable(){

            public void run() {
                try {
                    Bucket data;
                    if (logMINOR) {
                        Logger.minor(this, "Extracting off-thread: " + tag.data + " for " + tag.handler.key + " element " + tag.element + " for " + tag.callback);
                    }
                    tag.handler.extractToCache(tag.data, tag.actx, tag.element, proxyCallback, manager, null, context);
                    if (logMINOR) {
                        Logger.minor(this, "Extracted");
                    }
                    if (proxyCallback.data == null) {
                        data = null;
                    } else {
                        try {
                            if (logMINOR) {
                                Logger.minor(this, "Copying data...");
                            }
                            data = bf.makeBucket(proxyCallback.data.size());
                            BucketTools.copy(proxyCallback.data, data);
                            proxyCallback.data.free();
                            if (logMINOR) {
                                Logger.minor(this, "Copied and freed original");
                            }
                        }
                        catch (IOException e) {
                            throw new ArchiveFailureException("Failure copying data to persistent storage", e);
                        }
                    }
                    context.jobRunner.queue(new DBJob(){

                        public boolean run(ObjectContainer container, ClientContext context) {
                            if (logMINOR) {
                                Logger.minor(this, "Calling callback for " + tag.data + " for " + tag.handler.key + " element " + tag.element + " for " + tag.callback);
                            }
                            container.activate((Object)tag.callback, 1);
                            if (proxyCallback.data == null) {
                                tag.callback.notInArchive(container, context);
                            } else {
                                tag.callback.gotBucket(data, container, context);
                            }
                            tag.callback.removeFrom(container);
                            if (tag.freeBucket) {
                                tag.data.free();
                                tag.data.removeFrom(container);
                            }
                            container.deactivate((Object)tag.callback, 1);
                            container.delete((Object)tag);
                            return false;
                        }
                    }, 5, false);
                }
                catch (ArchiveFailureException e) {
                    try {
                        context.jobRunner.queue(new DBJob(){

                            public boolean run(ObjectContainer container, ClientContext context) {
                                container.activate((Object)tag.callback, 1);
                                tag.callback.onFailed(e, container, context);
                                tag.callback.removeFrom(container);
                                if (tag.freeBucket) {
                                    tag.data.free();
                                    tag.data.removeFrom(container);
                                }
                                container.delete((Object)tag);
                                return false;
                            }
                        }, 5, false);
                    }
                    catch (DatabaseDisabledException e1) {
                        Logger.error(this, "Extracting off thread but persistence is disabled");
                    }
                }
                catch (ArchiveRestartException e) {
                    try {
                        context.jobRunner.queue(new DBJob(){

                            public boolean run(ObjectContainer container, ClientContext context) {
                                container.activate((Object)tag.callback, 1);
                                tag.callback.onFailed(e, container, context);
                                tag.callback.removeFrom(container);
                                if (tag.freeBucket) {
                                    tag.data.free();
                                    tag.data.removeFrom(container);
                                }
                                container.delete((Object)tag);
                                return false;
                            }
                        }, 5, false);
                    }
                    catch (DatabaseDisabledException e1) {
                        Logger.error(this, "Extracting off thread but persistence is disabled");
                    }
                }
                catch (DatabaseDisabledException e) {
                    Logger.error(this, "Extracting off thread but persistence is disabled");
                }
            }
        }, "Off-thread extract");
    }

    static void init(ObjectContainer container, ClientContext context, final long nodeDBHandle) {
        ObjectSet set = container.query((Predicate)new Predicate<ArchiveExtractTag>(){

            public boolean match(ArchiveExtractTag tag) {
                return tag.nodeDBHandle == nodeDBHandle;
            }
        });
        while (set.hasNext()) {
            ArchiveExtractTag tag = (ArchiveExtractTag)set.next();
            tag.activateForExecution(container);
            ArchiveHandlerImpl.runPersistentOffThread(tag, context, context.archiveManager, context.persistentBucketFactory);
        }
    }

    public void activateForExecution(ObjectContainer container) {
        container.activate((Object)this, 1);
        container.activate((Object)this.key, 5);
    }

    public ArchiveHandler cloneHandler() {
        return new ArchiveHandlerImpl(this.key.clone(), this.archiveType, this.compressorType, this.forceRefetchArchive);
    }

    public void removeFrom(ObjectContainer container) {
        if (this.key == null) {
            Logger.error(this, "removeFrom() : key = null for " + this + " I exist = " + container.ext().isStored((Object)this) + " I am active: " + container.ext().isActive((Object)this), new Exception("error"));
        } else {
            this.key.removeFrom(container);
        }
        container.delete((Object)this);
    }

    static {
        Logger.registerClass(ArchiveHandlerImpl.class);
    }

    private static class ProxyCallback
    implements ArchiveExtractCallback {
        Bucket data;

        private ProxyCallback() {
        }

        public void gotBucket(Bucket data, ObjectContainer container, ClientContext context) {
            this.data = data;
        }

        public void notInArchive(ObjectContainer container, ClientContext context) {
            this.data = null;
        }

        public void onFailed(ArchiveRestartException e, ObjectContainer container, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        public void onFailed(ArchiveFailureException e, ObjectContainer container, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        public void removeFrom(ObjectContainer container) {
            container.delete((Object)this);
        }
    }
}

