(*
This script is meant to
	1) Identify installed instances of the product
	2) check whether the user has write-access (and if not
	ask for authentification)
	3) install the correct shipped tarball
	4) Update profile
*)


set sourcedir to (do shell script "dirname " & quoted form of POSIX path of (path to of me))
set isItTff to false

set TFFVersions to {"45.41.0", "45.41.1", "45.41.2", "45.41.3", "45.41.4", "45.41.5", "45.41.6"} -- versions compatible with the installer {"4.0.2", "5.0.2", "6.0.1"} for example


set strVersions to ""
repeat with theCurrentValue in TFFVersions
	set strVersions to strVersions & ", " & theCurrentValue
end repeat

-- strings for localisations - to be meant to be replaced
-- by a makefile or similar

set OKLabel to "OK"
set InstallLabel to "Installer"
set AbortLabel to "Annuler"
set intro to "Bienvenue ! 

Cet assistant ajoute le pack de langue et la correction orthographique en franais  TenFourFox FPR32.

Enregistrez votre travail si ncessaire et quitter TenFourFox avant de cliquer sur  Installer ."
set chooseMyOwn to "Non trouv (slectionnez l'emplacement dans l'tape suivante)"
set listPrompt to "Slectionnez la version de TenFourFox  laquelle vous voulez ajouter le pack de langue en franais."
set chooseManual to "Slection de TenFourFox."
set listOKLabel to "Installer"
set listCancelLabel to "Annuler"
set appInvalid to " Non reconnu comme TenFourFox. 

Excutez  nouveau le programme d'installation et choisissez une installation valide de TenFourFox." -- string will begin with the chosen application's name
set startInstall to "Cliquez sur Installer pour lancer l'installation."
set IdentifyQ to "L'installation a chou. Votre compte utilisateur ne dispose peut-tre pas des droits suffisants.

Voulez-vous vous identifier en tant qu'administrateur et essayer  nouveau?"
set IdentifyYES to "Oui, identifier"
set IdentifyNO to "Non, annuler l'installation"
set installFailed to "chec de l'installation"
set installComplete to "L'installation du pack de langue en franais pour TenFourFox est termine."

set profilupdate to "TenFourFox a mis  jour votre profil utilisateur. Assurez-vous que TenFourFox n'est pas lanc."

set Nottranslatable to ": malheureusement, la version slectionne de TenFourFox n'est pas compatible avec cette version du pack de langue. Veuillez mettre  jour vers la version FPR32 ou ultrieure, puis redmarrez le programme d'installation." -- Unable to apply translation because your have an incompatible version of TFF. This istaller works with the @String@ version of TFF.

set Localeident to "fr" -- your locale short string for profile updating

-- end of localisation string


activate
display dialog intro buttons {AbortLabel, InstallLabel} default button 2 with icon 1

if (button returned of result) is AbortLabel then
	return 2
end if
try -- kill Tff
	do shell script ("killall -kill firefox-bin firefox")
end try

set found_ooos to {}
try
	set the found_ooos_all to (do shell script "mdfind \"kMDItemContentType == 'com.apple.application-bundle' && kMDItemDisplayName == 'TenFourFox*' && kMDItemDisplayName != 'TenFourFox Language Pack.app'\"") & "
" & chooseMyOwn
	
	set found_ooos_all_paragraphs to paragraphs in found_ooos_all
	
	set found_ooos to {}
	repeat with currentApp in found_ooos_all_paragraphs
		if currentApp does not start with "/Volumes" then
			copy currentApp to the end of found_ooos
		end if
	end repeat
	
end try
-- repeat with oneApp in found_ooos
--  display dialog oneApp
-- end repeat

-- the choice returned is of type "list"
-- Show selection dialog only if more than one or no product was found
-- The first item is an empty string, if no app was found and no app started with "/Volumes"
-- The first item is chooseMyOwn, if no app was found and at least one app started with "/Volumes"
if found_ooos is {} then
	set the choice to POSIX path of (choose file with prompt chooseManual of type "com.apple.application-bundle" without showing package contents and invisibles)
	
else if (get first item of found_ooos as string) is "" then
	set the choice to (choose from list found_ooos default items (get second item of found_ooos) with prompt listPrompt OK button name listOKLabel cancel button name listCancelLabel)
	if choice is false then
		-- do nothing, the user cancelled the installation
		return 2 --aborted by user
	else if (choice as string) is chooseMyOwn then
		
		
		-- yeah, one needs to use "choose file", otherwise
		-- the user would not be able to select the .app
		set the choice to POSIX path of (choose file with prompt chooseManual of type "com.apple.application-bundle" without showing package contents and invisibles)
	end if
else if (get first item of found_ooos as string) is chooseMyOwn then
	set the choice to (choose from list found_ooos default items (get first item of found_ooos) with prompt listPrompt OK button name listOKLabel cancel button name listCancelLabel)
	if choice is false then
		-- do nothing, the user cancelled the installation
		return 2 --aborted by user
	else if (choice as string) is chooseMyOwn then
		-- yeah, one needs to use "choose file", otherwise
		-- the user would not be able to select the .app
		set the choice to POSIX path of (choose file with prompt chooseManual of type "com.apple.application-bundle" without showing package contents and invisibles)
	end if
else if (get second item of found_ooos as string) is chooseMyOwn then
	-- set choice to found installation
	-- set the choice to (get first paragraph of found_ooos)
	set the choice to (get first item of found_ooos)
else
	set the choice to (choose from list found_ooos default items (get first item of found_ooos) with prompt listPrompt OK button name listOKLabel cancel button name listCancelLabel)
	if choice is false then
		-- do nothing, the user cancelled the installation
		return 2 --aborted by user
	else if (choice as string) is chooseMyOwn then
		-- yeah, one needs to use "choose file", otherwise
		-- the user would not be able to select the .app
		set the choice to POSIX path of (choose file with prompt chooseManual of type "com.apple.application-bundle" without showing package contents and invisibles)
	end if
end if

-- now only check if it is really TFF and if the translation is possilbe

set thePListPath to POSIX path of (choice as string) & "/Contents/Info.plist" -- le plist file to read

tell application "System Events"
	tell property list file thePListPath
		tell contents
			set VersionKey to value of property list item "CFBundleShortVersionString" -- the version returned in 4.0.1 form
			set BundleName to value of property list item "CFBundleIdentifier" -- the identifier string must be "com.floodgap.tenfourfox"
			
		end tell
	end tell
end tell


if BundleName is "com.floodgap.tenfourfox" then -- if everything is ok
	set isItTff to true
else
	display dialog (choice as string) & appInvalid buttons {OKLabel} default button 1 with icon 0
	return 3 --wrong target-directory
end if
if isItTff is true and VersionKey is in TFFVersions then
	set fileToUncompress to "tarball.tar.bz2" -- set a tarball name to un compress	
else
	display dialog (choice as string) & Nottranslatable buttons {OKLabel} default button 1 with icon 0
	return 3
end if
(*
display dialog startInstall buttons {AbortLabel, InstallLabel} default button 2

if (button returned of result) is AbortLabel then
	return 2
end if
*)
set filePathTounCompress to sourcedir & "/" & fileToUncompress

set tarCommand to "/usr/bin/tar -C " & quoted form of (choice as string) & " -xjf " & quoted form of filePathTounCompress
try
	
	do shell script tarCommand
	
on error errMSG number errNUM
	display dialog IdentifyQ buttons {IdentifyYES, IdentifyNO} with icon 2
	if (button returned of result) is IdentifyYES then
		try
			do shell script tarCommand with administrator privileges
		on error errMSG number errNUM
			display dialog installFailed buttons {OKLabel} default button 1 with icon 0
			-- -60005 username/password wrong
			-- -128   aborted by user
			-- 2 error from tar - tarball not found (easy to test)
			return errNUM
		end try
	else
		return 2 -- aborted by user 
	end if
end try


display dialog profilupdate buttons {OKLabel} default button 1 with icon 2
-- force tff to quit
try
	do shell script ("killall -kill firefox-bin")
end try
-- find application support
try
	set apppath to path to application support from user domain
	
	
	-- convert it in posix path
	set apppathp to POSIX path of apppath
	
	
	-- find firefox profiles
	set this_folder to apppath & "Firefox:Profiles:" as string
	-- convert it to posix path
	set thisfolderp to POSIX path of this_folder
	
	-- lis folder in the profiles folder
	tell application "System Events"
		set these_files to every folder of folder this_folder
	end tell
	-- for each folder
	repeat with i from 1 to the count of these_files
		set this_file to (item i of these_files)
		set this_name to the name of this_file
		set dirp to thisfolderp & this_name & "/prefs.js" as string
		set sedscpt to "sed -i\".bak\" \"/general.useragent.locale/d\" " & quoted form of dirp
		do shell script (sedscpt) -- delete local configuration
		
		set theText to "user_pref(\"general.useragent.locale\", \"" & Localeident & "\");"
		
		
		set dir to this_folder & this_name & ":prefs.js"
		-- add french string
		set theFileReference to open for access dir with write permission
		write theText to theFileReference starting at eof
		close access theFileReference
		
		
	end repeat
end try

display dialog installComplete buttons {OKLabel} default button 1 with icon 1

