#!/bin/sh
#
# Copyright 2005,2006 Brian Bergstrand
#
# This program is free software; you can redistribute it and/or modify it under the terms of the
# GNU General Public License as published by the Free Software Foundation;
# either version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with this program;
# if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

PATH=/bin:/usr/bin

echo "This script permanently removes the PeerGuardian support files (including preferences) with no further confirmations."
echo "Note: PeerGuardian.app will NOT be removed, you will need to drag it to the Trash."
echo "Continue? [Yy]"
read doit

if [ "$doit" != "y" ] && [ "$doit" != "Y" ]; then
	echo "Uninstall cancelled."
	exit 0
fi

cd /Library/LaunchDaemons
if [ -f xxx.qnation.PeerProtector.kextload.plist ]; then
	echo "Removing Launch Daemon plist..."
	sudo rm ./xxx.qnation.PeerProtector.kextload.plist 
fi
if [ -f xxx.qnation.PeerGuardian.kextload.plist ]; then
	echo "Removing Launch Daemon plist..."
	sudo rm ./xxx.qnation.PeerGuardian.kextload.plist 
fi

cd ../Extensions
if [ -d ./PeerProtector.kext ] || [ -d ./PeerGuardian.kext ] ; then
	echo "Unloading kext..."
	sudo /Library/Application\ Support/ppktool -u
fi

if [ -d ./PeerProtector.kext ]; then
	echo "Removing PP kext..."
	sudo rm -rf ./PeerProtector.kext
fi

if [ -d ./PeerGuardian.kext ]; then
	echo "Removing kext..."
	sudo rm -rf ./PeerGuardian.kext
fi

cd ../Application\ Support
if [ -f ./ppktool ]; then
	echo "Removing kext tool..."
	sudo rm ./ppktool
fi

cd ../Receipts
if [ -d ./PeerProtector.pkg ]; then
	echo "Removing PP Install receipt..."
	sudo rm -rf ./PeerProtector.pkg
fi

if [ -d ./PeerGuardian.pkg ]; then
	echo "Removing Install receipt..."
	sudo rm -rf ./PeerGuardian.pkg
fi

cd ../Widgets
if [ -d ./PeerProtector.wdgt ]; then
	echo "Removing PP widget..."
	sudo rm -rf ./PeerProtector.wdgt
fi

if [ -d ./PeerGuardian.wdgt ]; then
	echo "Removing widget..."
	sudo rm -rf ./PeerGuardian.wdgt
fi	

cd ~/Library/Caches
if [ -d xxx.qnation.PeerProtector ]; then
	echo "Removing PP list cache"
	rm -rf ./xxx.qnation.PeerProtector
fi

if [ -d xxx.qnation.PeerGuardian ]; then
	echo "Removing list cache"
	rm -rf ./xxx.qnation.PeerGuardian
fi

if [ -d ../Widgets ]; then
	cd ../Widgets
	if [ -d ./PeerProtector.wdgt ]; then
		echo "Removing PP widget..."
		rm -rf ./PeerProtector.wdgt
	fi
	
	if [ -d ./PeerGuardian.wdgt ]; then
		echo "Removing widget..."
		rm -rf ./PeerGuardian.wdgt
	fi
fi

cd ../Preferences/
echo "Removing preferences..."
rm -f ./*xxx.qnation.*
