/*
 * Decompiled with CFR 0.152.
 */
package cdt2wav;

import cdt2wav.Main;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PCMFilePlayer
implements Runnable {
    File file;
    AudioInputStream in;
    SourceDataLine line;
    int frameSize;
    byte[] buffer = new byte[32768];
    Thread playThread;
    boolean playing;
    boolean notYetEOF;
    int choosenpos = 0;
    int interval = 0;
    int skip = 0;

    public PCMFilePlayer(File f) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        this.file = f;
        this.in = AudioSystem.getAudioInputStream(f);
        AudioFormat format = this.in.getFormat();
        AudioFormat.Encoding formatEncoding = format.getEncoding();
        if (!formatEncoding.equals(AudioFormat.Encoding.PCM_SIGNED) && !formatEncoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new UnsupportedAudioFileException(this.file.getName() + " is not PCM audio");
        }
        System.out.println("got PCM format");
        this.frameSize = format.getFrameSize();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        System.out.println("got info");
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        System.out.println("got line");
        this.line.open();
        System.out.println("opened line");
        this.playThread = new Thread(this);
        this.playing = false;
        this.notYetEOF = true;
        this.playThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int readPoint = 0;
        int bytesRead = 0;
        try {
            while (this.notYetEOF) {
                if (this.playing) {
                    bytesRead = this.in.read(this.buffer, readPoint, this.buffer.length - readPoint);
                    if (bytesRead == -1) {
                        this.notYetEOF = false;
                        break;
                    }
                    int frames = bytesRead / this.frameSize;
                    int leftover = bytesRead % this.frameSize;
                    this.line.write(this.buffer, readPoint, bytesRead - leftover);
                    System.arraycopy(this.buffer, bytesRead, this.buffer, 0, leftover);
                    readPoint = leftover;
                    continue;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {}
            }
            System.out.println("reached eof");
            this.line.drain();
            this.line.stop();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void start() {
        this.skip = 0;
        this.playing = true;
        if (!this.playThread.isAlive()) {
            this.playThread.start();
        }
        this.line.start();
    }

    public void stop() {
        this.skip = 0;
        this.playing = false;
        this.line.stop();
    }

    public void close() {
        this.line.drain();
        this.line.stop();
        this.line.close();
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Old stream closed");
    }

    public SourceDataLine getLine() {
        return this.line;
    }

    public int getPos() {
        ++this.interval;
        int g = this.line.getFramePosition() + this.skip;
        if (this.interval > 5) {
            this.interval = 0;
            for (int i = Main.blocks.length - 1; i >= 0; --i) {
                if (g < Main.blocks[i]) continue;
                Main.blocklist.setSelectedIndex(i);
                Main.jScrollPane1.getVerticalScrollBar().setValue(i * Main.blocklist.getCellBounds((int)0, (int)0).height);
                break;
            }
        }
        return g;
    }

    public void setPos(int pos) {
        try {
            this.stop();
            if (pos > 4096) {
                pos -= 4096;
            }
            this.in.close();
            this.line.drain();
            this.line.close();
            this.in = AudioSystem.getAudioInputStream(this.file);
            this.in.skip(pos);
            this.skip = pos;
            this.line.open();
            this.playing = true;
            this.line.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }
}

