/*
 * Decompiled with CFR 0.152.
 */
package cdt2wav;

import cdt2wav.CDT2WAV;
import cdt2wav.PCMFilePlayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends JFrame {
    private ArrayList<DropTarget> dropTargetList;
    public static int[] blocks;
    private String[] ids;
    private byte[] tapesample;
    AdjustmentListener hListener = new AdjustmentListener(){

        public void adjustmentValueChanged(AdjustmentEvent e) {
            Main.this.bar.repaint();
        }
    };
    int divider = 500;
    int h = 0;
    boolean wait = false;
    ActionListener updateScroll = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (Main.this.tapesample != null && Main.this.tapesample.length > 1000) {
                        Main.this.Update(Main.this.bar.getGraphics());
                    }
                }
            });
        }
    };
    public Timer cycleUpdate = new Timer(30, this.updateScroll);
    boolean playing = false;
    int freq = 44100;
    String playname = "";
    String savename = "";
    PCMFilePlayer player;
    private JPanel bar;
    public static JList blocklist;
    private ButtonGroup buttonGroup1;
    private JRadioButton high;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    public static JScrollPane jScrollPane1;
    private JRadioButton low;
    private JRadioButton medium;
    private JButton play;
    private JProgressBar progress;
    private JButton rewind;
    private JButton save;
    private JScrollPane scroll;
    private JButton stop;

    public void setTape(int index) {
        System.out.println("Jumping to " + blocks[index]);
        this.player.setPos(blocks[index]);
    }

    public void Update(Graphics g) {
        if (this.tapesample != null && !this.wait) {
            this.wait = true;
            int i = 0;
            int y = 8;
            int p = 0;
            int oldy = 20;
            int k = 0;
            while ((i += this.divider) < this.tapesample.length) {
                y = this.tapesample[i] == -128 ? 20 : ((this.tapesample[i] & 0x28) == 0 ? 10 : 30);
                g.setColor(Color.GREEN);
                g.drawLine(p + 100, oldy, p + 100, y);
                ++p;
                if (k < this.tapesample.length / this.divider) {
                    g.setColor(Color.YELLOW);
                    g.drawLine(k + 100, 36, k + 100, 50);
                    g.drawLine(k + 100, 0, k + 100, 6);
                    k += 100;
                }
                oldy = y;
            }
            g.setColor(Color.RED);
            g.fillRect(this.h + 98, 0, 4, 37);
            this.progress.setValue(this.h);
            this.UpdateScroller();
            this.wait = false;
        }
    }

    private void Convert(byte[] data) {
        this.tapesample = new byte[10000];
        if (this.high.isSelected()) {
            this.freq = 44100;
            this.divider = 400;
        }
        if (this.medium.isSelected()) {
            this.freq = 22050;
            this.divider = 200;
        }
        if (this.low.isSelected()) {
            this.freq = 11025;
            this.divider = 100;
        }
        CDT2WAV cdt2wav = new CDT2WAV(data, this.freq, this.jCheckBox1.isSelected());
        this.tapesample = cdt2wav.convert();
        this.scroll.getHorizontalScrollBar().setValue(0);
        this.progress.setValue(0);
        blocks = cdt2wav.blocks;
        this.ids = cdt2wav.ids;
        Main.blocks[Main.blocks.length - 1] = this.tapesample.length - 44;
        for (int i = 0; i < blocks.length; ++i) {
            System.out.println(blocks[i]);
        }
        this.ids[this.ids.length - 1] = "Eject tape";
        cdt2wav.dispose();
    }

    private void Convert(String name) {
        File cdt = new File(name);
        this.savename = name;
        this.savename = this.savename.replace(".cdt", "");
        this.savename = this.savename.replace(".CDT", "");
        this.savename = this.savename + ".wav";
        if (this.player != null) {
            this.player.stop();
            this.player.close();
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(cdt));
            int length = in.available();
            byte[] data = new byte[length];
            in.read(data);
            in.close();
            this.Convert(data);
            if (this.tapesample != null && this.tapesample.length > 10) {
                if (this.high.isSelected()) {
                    this.divider = 1000;
                }
                if (this.medium.isSelected()) {
                    this.divider = 500;
                }
                if (this.low.isSelected()) {
                    this.divider = 250;
                }
                this.progress.setMinimum(0);
                this.progress.setMaximum(this.scroll.getHorizontalScrollBar().getMaximum());
                this.bar.setSize(this.tapesample.length / this.divider + 300, 64);
                this.bar.setPreferredSize(new Dimension(this.tapesample.length / this.divider + 300, 64));
                this.save.setEnabled(true);
                this.feedInfo();
                this.Save(this.savename);
            } else {
                this.save.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void feedInfo() {
        String[] blockinfo = new String[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            int o = i;
            String pre = "";
            if (o < 1000) {
                pre = pre + "0";
            }
            if (o < 100) {
                pre = pre + "0";
            }
            if (o < 10) {
                pre = pre + "0";
            }
            pre = pre + i;
            blockinfo[i] = pre + " - " + this.ids[i];
        }
        this.buildInfo(blockinfo);
    }

    public void buildInfo(final String[] block) {
        blocklist.setModel(new AbstractListModel(){

            public int getSize() {
                return block.length;
            }

            public Object getElementAt(int i) {
                return block[i];
            }
        });
    }

    private void Convert() {
        this.setAlwaysOnTop(false);
        JFrame dummy = new JFrame();
        System.out.println("Load CDT");
        FileDialog filedia = new FileDialog((Frame)dummy, "Load CDT", 0);
        filedia.setFile("*.cdt");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            this.Convert(filename);
        }
        this.setAlwaysOnTop(true);
    }

    private void Save() {
        JFrame dummy = new JFrame();
        System.out.println("Save WAV");
        FileDialog filedia = new FileDialog((Frame)dummy, "Save WAV", 1);
        filedia.setFile("*.wav");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            this.Save(filename);
        }
    }

    private void Save(String name) {
        File cdt = new File(name);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cdt));
            out.write(this.tapesample);
            out.close();
            this.playname = name;
            this.play.setEnabled(true);
            this.stop.setEnabled(true);
            this.rewind.setEnabled(true);
            this.prepareToPlay();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void UpdateScroller() {
        if (this.playing) {
            try {
                this.h = this.player.getPos() / this.divider;
                this.scroll.getHorizontalScrollBar().setValue(this.h);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void play() {
        if (this.player != null) {
            this.playing = true;
            this.progress.setMinimum(0);
            this.progress.setMaximum(this.scroll.getHorizontalScrollBar().getMaximum());
            try {
                this.player.start();
                this.scroll.getHorizontalScrollBar().setValue(60);
                this.progress.setValue(60);
            }
            catch (Exception e) {
                this.prepareToPlay();
            }
        }
    }

    public void stop() {
        if (this.player != null) {
            this.playing = false;
            this.player.stop();
        }
    }

    public void prepareToPlay() {
        if (this.player != null) {
            this.player.stop();
            this.player.close();
        }
        this.player = null;
        System.gc();
        try {
            this.player = new PCMFilePlayer(new File(this.savename));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Main() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initComponents();
        this.cycleUpdate.start();
        this.dropTargetList = new ArrayList();
        DropListener myListener = new DropListener();
        Main.registerDropListener(this.dropTargetList, this, myListener);
        this.save.setVisible(false);
        this.scroll.getHorizontalScrollBar().addAdjustmentListener(this.hListener);
        this.save.setEnabled(false);
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                Main.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, myListener));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.save = new JButton();
        this.jButton1 = new JButton();
        this.scroll = new JScrollPane();
        this.bar = new JPanel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Main.this.Update(g);
            }
        };
        this.play = new JButton();
        this.stop = new JButton();
        this.rewind = new JButton();
        this.progress = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.low = new JRadioButton();
        this.medium = new JRadioButton();
        this.high = new JRadioButton();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel3 = new JLabel();
        jScrollPane1 = new JScrollPane();
        blocklist = new JList();
        this.setDefaultCloseOperation(3);
        this.setTitle("CDT2WAV 1.1 - by Markus Hohmann");
        this.setAlwaysOnTop(true);
        this.save.setText("Save WAV");
        this.save.setFocusable(false);
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.saveActionPerformed(evt);
            }
        });
        this.jButton1.setText("Convert CDT");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.jButton1ActionPerformed(evt);
            }
        });
        this.scroll.setBorder(BorderFactory.createEtchedBorder());
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.scroll.setEnabled(false);
        this.bar.setBackground(new Color(0, 0, 51));
        GroupLayout barLayout = new GroupLayout(this.bar);
        this.bar.setLayout(barLayout);
        barLayout.setHorizontalGroup(barLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 238, Short.MAX_VALUE));
        barLayout.setVerticalGroup(barLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.scroll.setViewportView(this.bar);
        this.play.setText("Play");
        this.play.setEnabled(false);
        this.play.setFocusable(false);
        this.play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.playActionPerformed(evt);
            }
        });
        this.stop.setText("Pause");
        this.stop.setEnabled(false);
        this.stop.setFocusable(false);
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.stopActionPerformed(evt);
            }
        });
        this.rewind.setText("Stop");
        this.rewind.setEnabled(false);
        this.rewind.setFocusable(false);
        this.rewind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.rewindActionPerformed(evt);
            }
        });
        this.progress.setFocusable(false);
        this.progress.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Main.this.progressStateChanged(evt);
            }
        });
        this.jLabel1.setText("CDT routines by John Girvin");
        this.jLabel1.setEnabled(false);
        this.jLabel2.setText("CDT2WAV \u00a92010-2011 by Markus Hohmann");
        this.jLabel2.setEnabled(false);
        this.buttonGroup1.add(this.low);
        this.low.setText("11khz");
        this.low.setFocusable(false);
        this.buttonGroup1.add(this.medium);
        this.medium.setText("22khz");
        this.medium.setFocusable(false);
        this.buttonGroup1.add(this.high);
        this.high.setSelected(true);
        this.high.setText("44khz");
        this.high.setFocusable(false);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Use 3 states (High, Low, No)");
        this.jCheckBox1.setFocusable(false);
        this.jLabel3.setText("Based on TZX2WAV by Francisco Javier Crespo");
        this.jLabel3.setEnabled(false);
        jScrollPane1.setAutoscrolls(true);
        blocklist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Main.this.blocklistMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                Main.this.blocklistMousePressed(evt);
            }
        });
        blocklist.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                Main.this.blocklistMouseMoved(evt);
            }
        });
        jScrollPane1.setViewportView(blocklist);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 238, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.play).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rewind)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.low).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.medium).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.high)).addComponent(this.jCheckBox1).addComponent(this.progress, -1, 238, Short.MAX_VALUE)).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(6, 6, 6).addComponent(jScrollPane1, -2, 201, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 247, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.save)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.play).addComponent(this.stop).addComponent(this.rewind)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.low).addComponent(this.medium).addComponent(this.high)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3))).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.Convert();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.Save();
    }

    private void playActionPerformed(ActionEvent evt) {
        this.play();
    }

    private void stopActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void rewindActionPerformed(ActionEvent evt) {
        this.prepareToPlay();
    }

    private void progressStateChanged(ChangeEvent evt) {
        this.Update(this.bar.getGraphics());
    }

    private void blocklistMouseClicked(MouseEvent evt) {
        this.player.interval = -50;
        if (evt.getClickCount() == 2) {
            this.setTape(blocklist.getSelectedIndex());
        }
    }

    private void blocklistMousePressed(MouseEvent evt) {
        this.player.interval = -50;
    }

    private void blocklistMouseMoved(MouseEvent evt) {
        this.player.interval = -50;
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Main main = new Main();
                if (args.length > 0 && args[0].toLowerCase().contains(".cdt")) {
                    main.Convert(args[0]);
                }
                main.setVisible(true);
            }
        });
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    String fileName;
                    dtde.acceptDrop(3);
                    Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List && (fileName = ((List)userObject).get(0).toString()).toLowerCase().endsWith("cdt")) {
                        if (Main.this.player != null) {
                            Main.this.player.stop();
                            Main.this.player.close();
                        }
                        Main.this.Convert(fileName);
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

